/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.basicstorage.block;

import com.khazoda.basicstorage.block.entity.CrateBlockEntity;
import com.khazoda.basicstorage.block.entity.CrateStationBlockEntity;
import com.khazoda.basicstorage.registry.BlockEntityRegistry;
import com.khazoda.basicstorage.registry.BlockRegistry;
import com.khazoda.basicstorage.registry.SoundRegistry;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2464;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class CrateStationBlock
extends class_2237
implements class_2343 {
    public static final MapCodec<CrateStationBlock> CODEC = CrateStationBlock.method_54094(CrateStationBlock::new);
    public static final class_4970.class_2251 defaultSettings = class_4970.class_2251.method_9637().method_9626(class_2498.field_11547).method_9632(3.5f).method_50012(class_3619.field_15972).method_51368(class_2766.field_12651).method_31710(class_3620.field_15996);

    public CrateStationBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    public CrateStationBlock() {
        this(defaultSettings);
    }

    public static void initOnUseMethod() {
        UseBlockCallback.EVENT.register((player, world, hand, hit) -> {
            if (!world.method_8320(hit.method_17777()).method_27852(BlockRegistry.CRATE_STATION_BLOCK)) {
                return class_1269.field_5811;
            }
            if (!player.method_7294() || player.method_7325()) {
                return class_1269.field_5811;
            }
            if (player.method_5998(hand).method_31574(BlockRegistry.CRATE_BLOCK.method_8389()) && player.method_5715()) {
                return class_1269.field_5811;
            }
            class_2338 pos = hit.method_17777();
            class_2680 state = world.method_8320(pos);
            class_2586 be = world.method_8321(pos);
            if (be == null) {
                return class_1269.field_5811;
            }
            CrateStationBlockEntity cdbe = (CrateStationBlockEntity)be;
            class_1799 playerStack = player.method_6047();
            int connectedCrateCount = cdbe.getConnectedCrates().size();
            int inserted = 0;
            if (player.method_5715()) {
                inserted = CrateStationBlock.depositInventory(player, cdbe);
            } else if (!player.method_5715()) {
                if (playerStack.method_7960()) {
                    if (!world.method_8608()) {
                        player.method_7353((class_2561)class_2561.method_43469((String)"message.basicstorage.station.connected_crate_count", (Object[])new Object[]{connectedCrateCount}).method_54663(0xDDFF99), true);
                    }
                    return class_1269.field_5811;
                }
                inserted = CrateStationBlock.depositStack(player.method_5998(hand), cdbe);
            }
            if (!world.method_8608()) {
                if (inserted <= 0) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.basicstorage.station.no_matching_crates").method_54663(0xFF9999), true);
                    world.method_8396(null, pos, SoundRegistry.NO_MATCH, class_3419.field_15245, 1.1f, 1.0f);
                    return class_1269.field_21466;
                }
                if (inserted == 1) {
                    world.method_8396(null, pos, SoundRegistry.INSERT_ONE, class_3419.field_15245, 1.0f, 1.05f);
                } else if (inserted <= 64) {
                    world.method_8396(null, pos, SoundRegistry.INSERT_MANY, class_3419.field_15245, 1.0f, 1.05f);
                } else {
                    world.method_8396(null, pos, SoundRegistry.INSERT_LOADS, class_3419.field_15245, 1.0f, 1.05f);
                }
                state.method_30101((class_1936)world, pos, 1);
                cdbe.method_5431();
                player.method_7259(class_3468.field_15372.method_14956((Object)playerStack.method_7909()));
                world.method_33596((class_1297)player, (class_6880)class_5712.field_28733, pos);
            }
            return class_1269.field_5812;
        });
    }

    private static int depositStack(class_1799 stack, CrateStationBlockEntity cdbe) {
        int inserted = 0;
        if (stack.method_7960()) {
            return 0;
        }
        ItemVariant variant = ItemVariant.of((class_1799)stack);
        List<class_2338> compatibleCrates = cdbe.getCrateRegistry().get(variant);
        if (compatibleCrates == null) {
            return 0;
        }
        class_1937 world = cdbe.method_10997();
        for (class_2338 cratePos : new ArrayList<class_2338>(compatibleCrates)) {
            if (world == null) {
                return 0;
            }
            class_2586 be = world.method_8321(cratePos);
            if (!(be instanceof CrateBlockEntity)) continue;
            CrateBlockEntity crate = (CrateBlockEntity)be;
            Transaction transaction = Transaction.openOuter();
            try {
                inserted = (int)crate.storage.insert(variant, (long)stack.method_7947(), (TransactionContext)transaction);
                if (inserted <= 0) continue;
                stack.method_7934(inserted);
                transaction.commit();
                int n = inserted;
                return n;
            }
            finally {
                if (transaction == null) continue;
                transaction.close();
            }
        }
        return inserted;
    }

    private static int depositInventory(class_1657 player, CrateStationBlockEntity cdbe) {
        int inserted = 0;
        PlayerInventoryStorage invStorage = PlayerInventoryStorage.of((class_1657)player);
        class_1937 world = cdbe.method_10997();
        block5: for (int i = 0; i < player.method_31548().field_7547.size(); ++i) {
            class_1799 stack = (class_1799)player.method_31548().field_7547.get(i);
            if (stack.method_7960()) continue;
            ItemVariant variant = ItemVariant.of((class_1799)stack);
            List<class_2338> compatibleCrates = cdbe.getCrateRegistry().get(variant);
            if (compatibleCrates == null) continue;
            for (class_2338 cratePos : compatibleCrates) {
                if (world == null) {
                    return 0;
                }
                class_2586 be = world.method_8321(cratePos);
                if (!(be instanceof CrateBlockEntity)) continue;
                CrateBlockEntity crate = (CrateBlockEntity)be;
                Transaction transaction = Transaction.openOuter();
                try {
                    if ((inserted += (int)crate.storage.insert(variant, (long)stack.method_7947(), (TransactionContext)transaction)) <= 0) continue;
                    stack.method_7934(inserted);
                    transaction.commit();
                    continue block5;
                }
                finally {
                    if (transaction == null) continue;
                    transaction.close();
                }
            }
        }
        return inserted;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return CrateStationBlock.method_31618(type, BlockEntityRegistry.CRATE_STATION_BLOCK_ENTITY, CrateStationBlockEntity::tick);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new CrateStationBlockEntity(pos, state);
    }

    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564();
    }

    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public MapCodec<CrateStationBlock> method_53969() {
        return CODEC;
    }
}

