/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.basicstorage.util;

import java.text.DecimalFormat;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class NumberFormatter {
    private static final NavigableMap<Integer, String> suffixes = new TreeMap<Integer, String>();

    public static String toFormattedNumber(double value) {
        DecimalFormat df = new DecimalFormat("###,###,###,###");
        return df.format(value);
    }

    public static String format(int value) {
        if (value == Integer.MIN_VALUE) {
            return NumberFormatter.format(-2147483647);
        }
        if (value < 0) {
            return "-" + NumberFormatter.format(-value);
        }
        if (value < 100000) {
            return NumberFormatter.toFormattedNumber(value);
        }
        Map.Entry<Integer, String> e = suffixes.floorEntry(value);
        Integer divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = value / (divideBy / 10);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)truncated / 10.0;
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    static {
        suffixes.put(1000, "K");
        suffixes.put(1000000, "M");
        suffixes.put(1000000000, "B");
    }
}

