/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.entityculling.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.tr7zw.entityculling.access.EntityRendererInter;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={EntityRenderer.class})
public abstract class EntityRendererMixin<T extends Entity>
implements EntityRendererInter<T> {
    @Override
    public boolean shadowShouldShowName(T entity) {
        return ((EntityRenderer)this).createRenderState(entity, (float)0.0f).nameTag != null;
    }

    @Override
    public void shadowRenderNameTag(T entity, Component component, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, float delta) {
        this.renderNameTag(((EntityRenderer)this).createRenderState(entity, delta), component, poseStack, multiBufferSource, light);
    }

    @Shadow
    public abstract void renderNameTag(EntityRenderState var1, Component var2, PoseStack var3, MultiBufferSource var4, int var5);

    @Override
    public boolean entityCullingIgnoresCulling(T entity) {
        return !this.affectedByCulling(entity);
    }

    @Override
    public AABB entityCullingGetCullingBox(T entity) {
        return this.getBoundingBoxForCulling(entity);
    }

    @Shadow
    abstract boolean affectedByCulling(T var1);

    @Shadow
    abstract AABB getBoundingBoxForCulling(T var1);
}

