/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.entityculling.mixin;

import com.logisticscraft.occlusionculling.util.MathUtilities;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.tr7zw.entityculling.EntityCullingModBase;
import dev.tr7zw.entityculling.NMSCullingHelper;
import dev.tr7zw.entityculling.mixin.LivingEntityRendererAccessor;
import dev.tr7zw.entityculling.versionless.access.Cullable;
import dev.tr7zw.transition.mc.GeneralUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.ArmorStandRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.state.LevelRenderState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelRenderer.class})
public class WorldRendererMixin {
    private EntityRenderDispatcher entityCulling$entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
    private List<Runnable> lateRenders = new ArrayList<Runnable>();
    private double aabbExpansion = 0.5;

    @Inject(at={@At(value="HEAD")}, method={"extractEntity(Lnet/minecraft/world/entity/Entity;F)Lnet/minecraft/client/renderer/entity/state/EntityRenderState;"}, cancellable=true)
    private void extractEntityRedir(Entity entity, float partialTick, CallbackInfoReturnable<EntityRenderState> ci) {
        if (EntityCullingModBase.instance.config.skipEntityCulling) {
            return;
        }
        Cullable cullable = (Cullable)entity;
        if (!cullable.isForcedVisible() && cullable.isCulled() && !NMSCullingHelper.ignoresCulling(entity)) {
            ++EntityCullingModBase.instance.skippedEntities;
            ArmorStandRenderState state = new ArmorStandRenderState();
            state.entityType = EntityType.ARMOR_STAND;
            state.x = entity.getX();
            state.y = entity.getY();
            state.z = entity.getZ();
            state.isInvisible = true;
            state.isInvisibleToPlayer = true;
            if (EntityCullingModBase.instance.config.renderNametagsThroughWalls && entity.shouldShowName()) {
                if (entity instanceof LivingEntity) {
                    LivingEntityRendererAccessor accessor;
                    LivingEntity living = (LivingEntity)entity;
                    EntityRenderer renderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)living);
                    if (renderer instanceof LivingEntityRendererAccessor && (accessor = (LivingEntityRendererAccessor)renderer).invokeShouldShowName(living, GeneralUtil.getCameraEntity().distanceToSqr(entity))) {
                        state.nameTag = entity.getDisplayName();
                        state.nameTagAttachment = entity.getAttachments().getNullable(EntityAttachment.NAME_TAG, 0, entity.getYRot(partialTick));
                    }
                } else {
                    state.nameTag = entity.getDisplayName();
                    state.nameTagAttachment = entity.getAttachments().getNullable(EntityAttachment.NAME_TAG, 0, entity.getYRot(partialTick));
                }
            }
            ci.setReturnValue((Object)state);
            return;
        }
        ++EntityCullingModBase.instance.renderedEntities;
        cullable.setOutOfCamera(false);
    }

    @Inject(at={@At(value="HEAD")}, method={"extractVisibleEntities(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;Lnet/minecraft/client/DeltaTracker;Lnet/minecraft/client/renderer/state/LevelRenderState;)V"})
    private void extractVisibleEntities(Camera camera, Frustum frustum, DeltaTracker deltaTracker, LevelRenderState levelRenderState, CallbackInfo ci) {
        EntityCullingModBase.instance.frustum = frustum;
    }

    private void renderDebugBox(Entity entity, double cameraX, double cameraY, double cameraZ, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, boolean visible) {
        AABB boundingBox = NMSCullingHelper.getCullingBox(entity);
        double maxX = (double)MathUtilities.ceil(boundingBox.maxX + this.aabbExpansion) - cameraX;
        double maxY = (double)MathUtilities.ceil(boundingBox.maxY + this.aabbExpansion) - cameraY;
        double maxZ = (double)MathUtilities.ceil(boundingBox.maxZ + this.aabbExpansion) - cameraZ;
        double minX = (double)MathUtilities.floor(boundingBox.minX - this.aabbExpansion) - cameraX;
        double minY = (double)MathUtilities.floor(boundingBox.minY - this.aabbExpansion) - cameraY;
        double minZ = (double)MathUtilities.floor(boundingBox.minZ - this.aabbExpansion) - cameraZ;
        DebugRenderer.renderFilledBox((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (AABB)new AABB(maxX, maxY, maxZ, minX, minY, minZ), (float)(visible ? 0.0f : 1.0f), (float)(visible ? 1.0f : 0.0f), (float)0.0f, (float)0.25f);
    }
}

