/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.entityculling.mixin;

import com.logisticscraft.occlusionculling.util.MathUtilities;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.tr7zw.entityculling.EntityCullingModBase;
import dev.tr7zw.entityculling.NMSCullingHelper;
import dev.tr7zw.entityculling.access.EntityRendererInter;
import dev.tr7zw.entityculling.versionless.access.Cullable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class WorldRendererMixin {
    private EntityRenderDispatcher entityCulling$entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
    private List<Runnable> lateRenders = new ArrayList<Runnable>();
    private double aabbExpansion = 0.5;

    @Inject(at={@At(value="HEAD")}, method={"renderEntity(Lnet/minecraft/world/entity/Entity;DDDFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;)V"}, cancellable=true)
    private void renderEntity(Entity entity, double cameraX, double cameraY, double cameraZ, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, CallbackInfo info) {
        EntityRenderer entityRenderer;
        EntityRenderer entityRenderer2;
        if (EntityCullingModBase.instance.config.skipEntityCulling) {
            return;
        }
        Cullable cullable = (Cullable)entity;
        if (!cullable.isForcedVisible() && cullable.isCulled() && !NMSCullingHelper.ignoresCulling(entity) && (entityRenderer2 = this.entityCulling$entityRenderDispatcher.getRenderer(entity)) instanceof EntityRenderer && (entityRenderer = entityRenderer2) instanceof EntityRendererInter) {
            EntityRendererInter entityRendererInter = (EntityRendererInter)entityRenderer;
            if (EntityCullingModBase.instance.config.renderNametagsThroughWalls && matrices != null && vertexConsumers != null && entityRendererInter.shadowShouldShowName(entity)) {
                double x = Mth.lerp((double)tickDelta, (double)entity.xOld, (double)entity.getX()) - cameraX;
                double y = Mth.lerp((double)tickDelta, (double)entity.yOld, (double)entity.getY()) - cameraY;
                double z = Mth.lerp((double)tickDelta, (double)entity.zOld, (double)entity.getZ()) - cameraZ;
                Vec3 vec3d = NMSCullingHelper.getRenderOffset(entityRenderer, entity, tickDelta);
                double d = x + vec3d.x;
                double e = y + vec3d.y;
                double f = z + vec3d.z;
                matrices.pushPose();
                matrices.translate(d, e, f);
                entityRendererInter.shadowRenderNameTag(entity, entity.getDisplayName(), matrices, vertexConsumers, this.entityCulling$entityRenderDispatcher.getPackedLightCoords(entity, tickDelta), tickDelta);
                matrices.popPose();
            }
            if (EntityCullingModBase.instance.debugHitboxes) {
                this.lateRenders.add(() -> this.renderDebugBox(entity, cameraX, cameraY, cameraZ, tickDelta, matrices, vertexConsumers, false));
            }
            ++EntityCullingModBase.instance.skippedEntities;
            info.cancel();
            return;
        }
        ++EntityCullingModBase.instance.renderedEntities;
        cullable.setOutOfCamera(false);
        if (EntityCullingModBase.instance.debugHitboxes) {
            this.lateRenders.add(() -> this.renderDebugBox(entity, cameraX, cameraY, cameraZ, tickDelta, matrices, vertexConsumers, true));
        }
    }

    private void renderDebugBox(Entity entity, double cameraX, double cameraY, double cameraZ, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, boolean visible) {
        AABB boundingBox = NMSCullingHelper.getCullingBox(entity);
        double maxX = (double)MathUtilities.ceil(boundingBox.maxX + this.aabbExpansion) - cameraX;
        double maxY = (double)MathUtilities.ceil(boundingBox.maxY + this.aabbExpansion) - cameraY;
        double maxZ = (double)MathUtilities.ceil(boundingBox.maxZ + this.aabbExpansion) - cameraZ;
        double minX = (double)MathUtilities.floor(boundingBox.minX - this.aabbExpansion) - cameraX;
        double minY = (double)MathUtilities.floor(boundingBox.minY - this.aabbExpansion) - cameraY;
        double minZ = (double)MathUtilities.floor(boundingBox.minZ - this.aabbExpansion) - cameraZ;
        DebugRenderer.renderFilledBox((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (AABB)new AABB(maxX, maxY, maxZ, minX, minY, minZ), (float)(visible ? 0.0f : 1.0f), (float)(visible ? 1.0f : 0.0f), (float)0.0f, (float)0.25f);
    }
}

