/*
 * Decompiled with CFR 0.152.
 */
package uk.protonull.civianmod;

import java.util.Iterator;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_9290;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.class_9335;
import org.jetbrains.annotations.NotNull;

public final class CivianModHelpers {
    private static final Pattern LEGACY_FORMATTER_REGEX = Pattern.compile("\u00a7.");

    public static boolean isNullOrEmpty(class_2561 component) {
        return component == null || class_2561.method_43473().equals((Object)component);
    }

    public static boolean hasPlainDisplayName(@NotNull class_1799 item, @NotNull String expected, boolean ignoreCase) {
        return CivianModHelpers.matchesPlainText((class_2561)item.method_57353().method_58694(class_9334.field_49631), expected, ignoreCase);
    }

    public static boolean hasPlainLoreLine(@NotNull class_1799 item, @NotNull String expected, boolean ignoreCase) {
        Iterator iterator = item.method_57353().method_58694(class_9334.field_49632);
        if (iterator instanceof class_9290) {
            class_9290 lore = (class_9290)iterator;
            for (class_2561 line : lore.comp_2400()) {
                if (!CivianModHelpers.matchesPlainText(line, expected, ignoreCase)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean matchesPlainText(class_2561 component, @NotNull String expected, boolean ignoreCase) {
        if (CivianModHelpers.isNullOrEmpty(component)) {
            return false;
        }
        StringBuilder combined = new StringBuilder();
        for (class_2561 child : component.method_44746()) {
            if (!class_2583.field_24360.equals((Object)child.method_10866())) {
                return false;
            }
            String content = child.getString();
            if (LEGACY_FORMATTER_REGEX.matcher(content).matches()) {
                return false;
            }
            combined.append(content);
        }
        return ignoreCase ? expected.equalsIgnoreCase(combined.toString()) : expected.contentEquals(combined);
    }

    @NotNull
    public static String getPlainString(@NotNull class_2561 component) {
        return LEGACY_FORMATTER_REGEX.matcher(component.getString()).replaceAll("");
    }

    @NotNull
    public static class_1799 createMaxStackItem(@NotNull class_1792 material, Integer amount, @NotNull class_9323 components) {
        class_9335 defaultComponents = new class_9335(material.method_57347());
        defaultComponents.method_57933(components);
        return new class_1799((class_1935)material, Objects.requireNonNullElseGet(amount, () -> ((class_1792)material).method_7882()).intValue(), defaultComponents);
    }
}

