/*
 * Decompiled with CFR 0.152.
 */
package uk.protonull.civianmod.config;

import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import java.awt.Color;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import uk.protonull.civianmod.CivianMod;
import uk.protonull.civianmod.config.TooltipLineOption;
import uk.protonull.civianmod.config.gui.IntegrationConfigGui;
import uk.protonull.civianmod.config.gui.ItemConfigGui;
import uk.protonull.civianmod.config.gui.MacroConfigGui;
import uk.protonull.civianmod.config.old.LegacyIceRoadSettings;
import uk.protonull.civianmod.config.old.LegacyItemSettings;
import uk.protonull.civianmod.config.old.LegacyPolyfillsSettings;
import uk.protonull.civianmod.features.ClickRailDest;
import uk.protonull.civianmod.features.CompactedItem;
import uk.protonull.civianmod.features.ExpIngredients;
import uk.protonull.civianmod.features.ItemDurability;
import uk.protonull.civianmod.features.SafeMining;
import uk.protonull.civianmod.features.macros.IceRoadMacro;

public final class CivianModConfig {
    @SerialEntry
    @NotNull
    public Color itemColourCrate;
    @SerialEntry
    @NotNull
    public Color itemColourCompacted;
    @SerialEntry
    @NotNull
    public TooltipLineOption showRepairLevel;
    @SerialEntry
    @NotNull
    public TooltipLineOption showDamageLevel;
    @SerialEntry
    public boolean showExpTooltip;
    @SerialEntry
    public boolean safeMiningEnabled;
    @SerialEntry
    public int safeMiningThreshold;
    @SerialEntry
    public boolean clickDestEnabled;
    @SerialEntry
    public long clickDestCooldown;
    @SerialEntry
    public boolean iceRoadSnapPitch;
    @SerialEntry
    public boolean iceRoadSnapYaw;
    @SerialEntry
    public boolean iceRoadAutoEat;
    @SerialEntry
    public boolean iceRoadStopWhenStarving;
    @SerialEntry(value="items", required=false, nullable=true)
    public LegacyItemSettings legacyItemSettings;
    @SerialEntry(value="polyfills", required=false, nullable=true)
    public LegacyPolyfillsSettings legacyPolyfillsSettings;
    @SerialEntry(value="iceRoad", required=false, nullable=true)
    public LegacyIceRoadSettings legacyIceRoadSettings;
    public static ConfigClassHandler<CivianModConfig> HANDLER = ConfigClassHandler.createBuilder(CivianModConfig.class).id(class_2960.method_43902((String)"civianmod", (String)"global_config")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(FabricLoader.getInstance().getConfigDir().resolve("civianmod.json")).setJson5(false).build()).build();

    public CivianModConfig() {
        this.itemColourCrate = CompactedItem.CRATE.defaultAwtColor;
        this.itemColourCompacted = CompactedItem.COMPACTED.defaultAwtColor;
        this.showRepairLevel = ItemDurability.DEFAULT_SHOW_REPAIR_LEVEL;
        this.showDamageLevel = ItemDurability.DEFAULT_SHOW_DAMAGE_LEVEL;
        this.showExpTooltip = true;
        this.safeMiningEnabled = true;
        this.safeMiningThreshold = 5;
        this.clickDestEnabled = false;
        this.clickDestCooldown = 1000L;
        this.iceRoadSnapPitch = false;
        this.iceRoadSnapYaw = true;
        this.iceRoadAutoEat = false;
        this.iceRoadStopWhenStarving = true;
        this.legacyItemSettings = null;
        this.legacyPolyfillsSettings = null;
        this.legacyIceRoadSettings = null;
    }

    public void apply() {
        CompactedItem.CRATE.colour = this.itemColourCrate.getRGB();
        CompactedItem.COMPACTED.colour = this.itemColourCompacted.getRGB();
        ItemDurability.showDamageLevel = this.showDamageLevel;
        ItemDurability.showRepairLevel = this.showRepairLevel;
        ExpIngredients.enabled = this.showExpTooltip;
        SafeMining.enabled = this.safeMiningEnabled;
        SafeMining.threshold = this.safeMiningThreshold;
        ClickRailDest.enabled = this.clickDestEnabled;
        ClickRailDest.cooldown = this.clickDestCooldown;
        IceRoadMacro.snapPitch = this.iceRoadSnapPitch;
        IceRoadMacro.snapYaw = this.iceRoadSnapYaw;
        IceRoadMacro.autoEat = this.iceRoadAutoEat;
        IceRoadMacro.stopWhenStarving = this.iceRoadStopWhenStarving;
    }

    public static void migrateFromCivModernConfig() {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        try {
            Files.copy(configDir.resolve("civmodern.json"), configDir.resolve("civianmod.json"), StandardCopyOption.COPY_ATTRIBUTES);
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            CivianMod.LOGGER.warn("Could not migrate CivModern YACL config!", (Throwable)e);
        }
    }

    public static boolean migrateToFlattenedConfig(@NotNull CivianModConfig config) {
        Object legacy;
        boolean hadLegacySettings = false;
        Object object = config.legacyItemSettings;
        if (object instanceof LegacyItemSettings) {
            legacy = object;
            config.itemColourCrate = ((LegacyItemSettings)legacy).crateItemColour;
            config.itemColourCompacted = ((LegacyItemSettings)legacy).compactedItemColour;
            config.showRepairLevel = ((LegacyItemSettings)legacy).showRepairLevel;
            config.showDamageLevel = ((LegacyItemSettings)legacy).showDamageLevel;
            config.showExpTooltip = ((LegacyItemSettings)legacy).showIsExpIngredient;
            config.safeMiningEnabled = ((LegacyItemSettings)legacy).safeMiningEnabled;
            config.safeMiningThreshold = ((LegacyItemSettings)legacy).safeMiningThreshold;
            config.legacyItemSettings = null;
            hadLegacySettings = true;
        }
        if ((object = config.legacyPolyfillsSettings) instanceof LegacyPolyfillsSettings) {
            legacy = object;
            config.clickDestEnabled = ((LegacyPolyfillsSettings)legacy).clickDestEnabled;
            config.clickDestCooldown = ((LegacyPolyfillsSettings)legacy).clickDestCooldown;
            config.legacyPolyfillsSettings = null;
            hadLegacySettings = true;
        }
        if ((object = config.legacyIceRoadSettings) instanceof LegacyIceRoadSettings) {
            legacy = object;
            config.iceRoadSnapPitch = ((LegacyIceRoadSettings)legacy).snapPitch;
            config.iceRoadSnapYaw = ((LegacyIceRoadSettings)legacy).snapYaw;
            config.iceRoadAutoEat = ((LegacyIceRoadSettings)legacy).autoEat;
            config.iceRoadStopWhenStarving = ((LegacyIceRoadSettings)legacy).stopWhenHungry;
            config.legacyIceRoadSettings = null;
            hadLegacySettings = true;
        }
        return hadLegacySettings;
    }

    @NotNull
    public static YetAnotherConfigLib generateScreenGenerator(@NotNull CivianModConfig config) {
        return YetAnotherConfigLib.createBuilder().title((class_2561)class_2561.method_43471((String)"category.civianmod")).category(ItemConfigGui.generateCategory(config)).category(IntegrationConfigGui.generateCategory(config)).category(MacroConfigGui.generateCategory(config)).save(() -> {
            HANDLER.save();
            config.apply();
        }).build();
    }
}

