/*
 * Decompiled with CFR 0.152.
 */
package uk.protonull.civianmod.features;

import java.awt.Color;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_9290;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import uk.protonull.civianmod.CivianModHelpers;

public enum CompactedItem {
    CRATE(0xFF4141),
    COMPACTED(0xFFFF58);

    public final int defaultColour;
    public final Color defaultAwtColor;
    public volatile int colour;
    private static final String CRATE_LORE = "Crate";
    private static final String COMPACTED_LORE = "Compacted Item";

    private CompactedItem(int defaultColour) {
        this.defaultColour = defaultColour;
        this.defaultAwtColor = new Color(defaultColour);
        this.colour = defaultColour;
    }

    public int getRBG() {
        return 0xFF000000 | this.colour;
    }

    @Nullable
    public static CompactedItem determineCompactedItemType(@NotNull class_1799 item) {
        if (CompactedItem.isCrate(item)) {
            return CRATE;
        }
        if (CompactedItem.isCompacted(item)) {
            return COMPACTED;
        }
        return null;
    }

    private static boolean isCrate(@NotNull class_1799 item) {
        return item.method_7909() == class_1802.field_8106 && CivianModHelpers.hasPlainLoreLine(item, CRATE_LORE, false);
    }

    private static boolean isCompacted(@NotNull class_1799 item) {
        return CivianModHelpers.hasPlainLoreLine(item, COMPACTED_LORE, false);
    }

    @NotNull
    public static class_1799 createExampleCrate() {
        return CivianModHelpers.createMaxStackItem(class_1802.field_8106, null, class_9323.method_57827().method_57840(class_9334.field_49632, (Object)new class_9290(List.of(class_2561.method_43470((String)CRATE_LORE)))).method_57838());
    }

    @NotNull
    public static class_1799 createExampleCompacted() {
        return CivianModHelpers.createMaxStackItem(class_1802.field_20391, null, class_9323.method_57827().method_57840(class_9334.field_49632, (Object)new class_9290(List.of(class_2561.method_43470((String)COMPACTED_LORE)))).method_57838());
    }
}

