/*
 * Decompiled with CFR 0.152.
 */
package com.arcaryx.cobblemonintegrations.toughasnails;

import com.arcaryx.cobblemonintegrations.config.CobblemonIntegrationsConfig;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.FormData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import toughasnails.api.temperature.IPlayerTemperatureModifier;
import toughasnails.api.temperature.TemperatureLevel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ5\u0010\u0014\u001a\u00020\u00132\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lcom/arcaryx/cobblemonintegrations/toughasnails/PokemonTemperatureModifier;", "Ltoughasnails/api/temperature/IPlayerTemperatureModifier;", "<init>", "()V", "Lnet/minecraft/class_1657;", "player", "Ltoughasnails/api/temperature/TemperatureLevel;", "temperatureLevel", "modify", "(Lnet/minecraft/class_1657;Ltoughasnails/api/temperature/TemperatureLevel;)Ltoughasnails/api/temperature/TemperatureLevel;", "", "Lcom/arcaryx/cobblemonintegrations/toughasnails/PokemonTemperatureModifier$PokemonTemp;", "pokemonList", "", "owned", "", "dist", "Lnet/minecraft/class_2487;", "pokemonTag", "", "addShoulderPokemon", "(Ljava/util/List;ZDLnet/minecraft/class_2487;)V", "PokemonTemp", "cobblemonintegrations-common-1.21.1"})
@SourceDebugExtension(value={"SMAP\nPokemonTemperatureModifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokemonTemperatureModifier.kt\ncom/arcaryx/cobblemonintegrations/toughasnails/PokemonTemperatureModifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1563#2:95\n1634#2,3:96\n*S KotlinDebug\n*F\n+ 1 PokemonTemperatureModifier.kt\ncom/arcaryx/cobblemonintegrations/toughasnails/PokemonTemperatureModifier\n*L\n26#1:95\n26#1:96,3\n*E\n"})
public final class PokemonTemperatureModifier
implements IPlayerTemperatureModifier {
    @NotNull
    public static final PokemonTemperatureModifier INSTANCE = new PokemonTemperatureModifier();

    private PokemonTemperatureModifier() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public TemperatureLevel modify(@NotNull class_1657 player, @NotNull TemperatureLevel temperatureLevel) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)temperatureLevel, (String)"temperatureLevel");
        double range = ((Number)CobblemonIntegrationsConfig.INSTANCE.getTEMPERATURE_RANGE().get()).doubleValue() + ((Number)CobblemonIntegrationsConfig.INSTANCE.getTEMPERATURE_RANGE_PER_LEVEL().get()).doubleValue() * 10.0;
        List nearbyPokemon = player.method_37908().method_18467(PokemonEntity.class, player.method_5829().method_1014(range));
        List nearbyPlayers = player.method_37908().method_18467(class_1657.class, player.method_5829().method_1014(range));
        Intrinsics.checkNotNull((Object)nearbyPokemon);
        Iterable $this$map$iv = nearbyPokemon;
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void x;
            PokemonEntity pokemonEntity = (PokemonEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PokemonTemp(x.getPokemon().isWild(), x.method_6171((class_1309)player), player.method_5858((class_1297)x), x.getForm(), x.getPokemon().getLevel()));
        }
        List pokemonList = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        for (class_1657 x : nearbyPlayers) {
            class_2487 pokemonTag;
            if (!x.method_7356().method_33133() && x.method_7356().method_10545("Pokemon")) {
                pokemonTag = x.method_7356().method_10562("Pokemon");
                boolean bl = x.method_5779((class_1297)player);
                double d = x.method_5858((class_1297)player);
                Intrinsics.checkNotNull((Object)pokemonTag);
                this.addShoulderPokemon(pokemonList, bl, d, pokemonTag);
            }
            if (x.method_7308().method_33133() || !x.method_7308().method_10545("Pokemon")) continue;
            pokemonTag = x.method_7308().method_10562("Pokemon");
            boolean bl = x.method_5779((class_1297)player);
            double d = x.method_5858((class_1297)player);
            Intrinsics.checkNotNull((Object)pokemonTag);
            this.addShoulderPokemon(pokemonList, bl, d, pokemonTag);
        }
        if (((Number)CobblemonIntegrationsConfig.INSTANCE.getTEMPERATURE_RANGE_PER_LEVEL().get()).doubleValue() > 0.0) {
            pokemonList.removeIf(arg_0 -> PokemonTemperatureModifier.modify$lambda$2(PokemonTemperatureModifier::modify$lambda$1, arg_0));
        }
        if (!((Boolean)CobblemonIntegrationsConfig.INSTANCE.getWILD_AFFECTS_TEMPERATURE().get()).booleanValue()) {
            pokemonList.removeIf(arg_0 -> PokemonTemperatureModifier.modify$lambda$4(PokemonTemperatureModifier::modify$lambda$3, arg_0));
        }
        if (!((Boolean)CobblemonIntegrationsConfig.INSTANCE.getCAPTURED_AFFECTS_TEMPERATURE().get()).booleanValue()) {
            pokemonList.removeIf(arg_0 -> PokemonTemperatureModifier.modify$lambda$6(PokemonTemperatureModifier::modify$lambda$5, arg_0));
        }
        Comparator<PokemonTemp> comparator = Comparator.comparingDouble(PokemonTemperatureModifier::modify$lambda$7);
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparingDouble(...)");
        CollectionsKt.sortWith((List)pokemonList, comparator);
        double newTemp = temperatureLevel.ordinal() - 2;
        for (PokemonTemp pokemon : pokemonList) {
            double primaryTemp = ((Number)CobblemonIntegrationsConfig.INSTANCE.getTEMPERATURE_STRENGTH().get()).doubleValue() + ((Number)CobblemonIntegrationsConfig.INSTANCE.getTEMPERATURE_STRENGTH_PER_LEVEL().get()).doubleValue() * (double)pokemon.getLevel();
            double secondaryTemp = (Boolean)CobblemonIntegrationsConfig.INSTANCE.getSECONDARY_TYPE_HALF_STRENGTH().get() != false ? primaryTemp * 0.5 : primaryTemp;
            double deltaTemp = 0.0;
            if (Intrinsics.areEqual((Object)pokemon.getForm().getPrimaryType(), (Object)ElementalTypes.FIRE)) {
                deltaTemp += primaryTemp;
            } else if (Intrinsics.areEqual((Object)pokemon.getForm().getSecondaryType(), (Object)ElementalTypes.FIRE)) {
                deltaTemp += secondaryTemp;
            }
            if (Intrinsics.areEqual((Object)pokemon.getForm().getPrimaryType(), (Object)ElementalTypes.ICE)) {
                deltaTemp -= primaryTemp;
            } else if (Intrinsics.areEqual((Object)pokemon.getForm().getSecondaryType(), (Object)ElementalTypes.ICE)) {
                deltaTemp -= secondaryTemp;
            }
            if (pokemon.getWild() && (Boolean)CobblemonIntegrationsConfig.INSTANCE.getWILD_CAUSES_HARM().get() != false || pokemon.getOwned() && (Boolean)CobblemonIntegrationsConfig.INSTANCE.getCAPTURED_CAUSES_HARM().get() != false || !pokemon.getWild() && !pokemon.getOwned() && ((Boolean)CobblemonIntegrationsConfig.INSTANCE.getCAPTURED_CAUSES_HARM_OTHER().get()).booleanValue()) {
                newTemp = class_3532.method_15350((double)(newTemp + deltaTemp), (double)-2.0, (double)2.0);
                continue;
            }
            newTemp += newTemp >= 1.999 && deltaTemp > 0.0 || newTemp <= -1.999 && deltaTemp < 0.0 ? 0.0 : class_3532.method_15350((double)deltaTemp, (double)Math.max(-1.0 - newTemp, -2.0), (double)Math.min(1.0 - newTemp, 2.0));
        }
        return (TemperatureLevel)EntriesMappings.entries$0.get(MathKt.roundToInt((double)newTemp) + 2);
    }

    private final void addShoulderPokemon(List<PokemonTemp> pokemonList, boolean owned, double dist, class_2487 pokemonTag) {
        class_2960 species = class_2960.method_12829((String)pokemonTag.method_10558("Species"));
        String formTag = pokemonTag.method_10558("FormId");
        short level = pokemonTag.method_10568("Level");
        class_2960 class_29602 = species;
        Intrinsics.checkNotNull((Object)class_29602);
        Object[] objectArray = new String[1];
        Intrinsics.checkNotNull((Object)formTag);
        objectArray[0] = formTag;
        FormData formData = Objects.requireNonNull(PokemonSpecies.getByIdentifier((class_2960)class_29602)).getForm(SetsKt.mutableSetOf((Object[])objectArray));
        pokemonList.add(new PokemonTemp(false, owned, dist, formData, level));
    }

    private static final boolean modify$lambda$1(PokemonTemp x) {
        double d = ((Number)CobblemonIntegrationsConfig.INSTANCE.getTEMPERATURE_RANGE().get()).doubleValue();
        double d2 = ((Number)CobblemonIntegrationsConfig.INSTANCE.getTEMPERATURE_RANGE_PER_LEVEL().get()).doubleValue();
        PokemonTemp pokemonTemp = x;
        Intrinsics.checkNotNull((Object)pokemonTemp);
        return d + d2 * (double)pokemonTemp.getLevel() > x.getDist();
    }

    private static final boolean modify$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean modify$lambda$3(PokemonTemp x) {
        PokemonTemp pokemonTemp = x;
        Intrinsics.checkNotNull((Object)pokemonTemp);
        return pokemonTemp.getWild();
    }

    private static final boolean modify$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean modify$lambda$5(PokemonTemp x) {
        PokemonTemp pokemonTemp = x;
        Intrinsics.checkNotNull((Object)pokemonTemp);
        return !pokemonTemp.getWild();
    }

    private static final boolean modify$lambda$6(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final double modify$lambda$7(PokemonTemp pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        return pokemon.getOwned() ? Double.MAX_VALUE : pokemon.getDist();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<TemperatureLevel> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])TemperatureLevel.values()));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000e\n\u0002\b\f\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\tH\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015JB\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\tH\u00c6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001a\u0010\u0019\u001a\u00020\u00022\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\tH\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u0015J\u0010\u0010\u001d\u001a\u00020\u001cH\u00d6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001f\u001a\u0004\b \u0010\u000eR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001f\u001a\u0004\b!\u0010\u000eR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\"\u001a\u0004\b#\u0010\u0011R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010$\u001a\u0004\b%\u0010\u0013R\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010&\u001a\u0004\b'\u0010\u0015\u00a8\u0006("}, d2={"Lcom/arcaryx/cobblemonintegrations/toughasnails/PokemonTemperatureModifier$PokemonTemp;", "", "", "wild", "owned", "", "dist", "Lcom/cobblemon/mod/common/pokemon/FormData;", "form", "", "level", "<init>", "(ZZDLcom/cobblemon/mod/common/pokemon/FormData;I)V", "component1", "()Z", "component2", "component3", "()D", "component4", "()Lcom/cobblemon/mod/common/pokemon/FormData;", "component5", "()I", "copy", "(ZZDLcom/cobblemon/mod/common/pokemon/FormData;I)Lcom/arcaryx/cobblemonintegrations/toughasnails/PokemonTemperatureModifier$PokemonTemp;", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "Z", "getWild", "getOwned", "D", "getDist", "Lcom/cobblemon/mod/common/pokemon/FormData;", "getForm", "I", "getLevel", "cobblemonintegrations-common-1.21.1"})
    private static final class PokemonTemp {
        private final boolean wild;
        private final boolean owned;
        private final double dist;
        @NotNull
        private final FormData form;
        private final int level;

        public PokemonTemp(boolean wild, boolean owned, double dist, @NotNull FormData form, int level) {
            Intrinsics.checkNotNullParameter((Object)form, (String)"form");
            this.wild = wild;
            this.owned = owned;
            this.dist = dist;
            this.form = form;
            this.level = level;
        }

        public final boolean getWild() {
            return this.wild;
        }

        public final boolean getOwned() {
            return this.owned;
        }

        public final double getDist() {
            return this.dist;
        }

        @NotNull
        public final FormData getForm() {
            return this.form;
        }

        public final int getLevel() {
            return this.level;
        }

        public final boolean component1() {
            return this.wild;
        }

        public final boolean component2() {
            return this.owned;
        }

        public final double component3() {
            return this.dist;
        }

        @NotNull
        public final FormData component4() {
            return this.form;
        }

        public final int component5() {
            return this.level;
        }

        @NotNull
        public final PokemonTemp copy(boolean wild, boolean owned, double dist, @NotNull FormData form, int level) {
            Intrinsics.checkNotNullParameter((Object)form, (String)"form");
            return new PokemonTemp(wild, owned, dist, form, level);
        }

        public static /* synthetic */ PokemonTemp copy$default(PokemonTemp pokemonTemp, boolean bl, boolean bl2, double d, FormData formData, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                bl = pokemonTemp.wild;
            }
            if ((n2 & 2) != 0) {
                bl2 = pokemonTemp.owned;
            }
            if ((n2 & 4) != 0) {
                d = pokemonTemp.dist;
            }
            if ((n2 & 8) != 0) {
                formData = pokemonTemp.form;
            }
            if ((n2 & 0x10) != 0) {
                n = pokemonTemp.level;
            }
            return pokemonTemp.copy(bl, bl2, d, formData, n);
        }

        @NotNull
        public String toString() {
            return "PokemonTemp(wild=" + this.wild + ", owned=" + this.owned + ", dist=" + this.dist + ", form=" + this.form + ", level=" + this.level + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.wild);
            result = result * 31 + Boolean.hashCode(this.owned);
            result = result * 31 + Double.hashCode(this.dist);
            result = result * 31 + this.form.hashCode();
            result = result * 31 + Integer.hashCode(this.level);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PokemonTemp)) {
                return false;
            }
            PokemonTemp pokemonTemp = (PokemonTemp)other;
            if (this.wild != pokemonTemp.wild) {
                return false;
            }
            if (this.owned != pokemonTemp.owned) {
                return false;
            }
            if (Double.compare(this.dist, pokemonTemp.dist) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.form, (Object)pokemonTemp.form)) {
                return false;
            }
            return this.level == pokemonTemp.level;
        }
    }
}

