/*
 * Decompiled with CFR 0.152.
 */
package redart15.commandly.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilderLiteral;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.net.command.CommandManager;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.ChunkCoordinate;
import redart15.commandly.util.Point;

public class CommandGrow
implements CommandManager.CommandRegistry {
    private static int worldHeight = 256;
    private static byte radius = (byte)3;

    public void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((ArgumentBuilderLiteral)((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal((String)"grow").requires(c -> ((CommandSource)c).hasAdmin())).executes(c -> this.growCommand((CommandContext<Object>)c)));
    }

    private int growCommand(CommandContext<Object> c) {
        CommandSource source = (CommandSource)c.getSource();
        Player player = source.getSender();
        World world = source.getWorld();
        Set<ChunkCoordinate> loaded = CommandGrow.getLoadedChunks(world, player.chunkCoordX, player.chunkCoordY, player.chunkCoordZ);
        List<Point> bonemealTargets = this.getAllBonemeableBlocks(world, loaded);
        source.sendTranslatableMessage("commandly.command.grow", new Object[]{this.grow(world, bonemealTargets)});
        return 1;
    }

    public int grow(World world, List<Point> targets) {
        Random rand = new Random();
        int count = 0;
        for (Point p : targets) {
            int z;
            int y;
            int x = p.getIntX();
            Block block = world.getBlock(x, y = p.getIntY(), z = p.getIntZ());
            if (block == null) continue;
            BlockLogic logic = block.getLogic();
            if (!(block.getLogic() instanceof IBonemealable)) continue;
            ((IBonemealable)logic).onBonemealUsed(new ItemStack(Items.DYE), (Player)null, world, x, y, z, Side.TOP, 0.0, 0.0);
            ++count;
        }
        return count;
    }

    public List<Point> getAllBonemeableBlocks(World world, Set<ChunkCoordinate> loaded) {
        ArrayList<Point> bonemeableBlocks = new ArrayList<Point>();
        for (ChunkCoordinate coords : loaded) {
            bonemeableBlocks.addAll(this.getBonemeableBlocks(world, coords));
            if (bonemeableBlocks.size() < 131072) continue;
            break;
        }
        return bonemeableBlocks;
    }

    public List<Point> getBonemeableBlocks(World world, ChunkCoordinate chunkCoordinate) {
        ArrayList<Point> bonemealableBlock = new ArrayList<Point>();
        int ix = chunkCoordinate.x * 16;
        int iz = chunkCoordinate.z * 16;
        for (int y = 0; y <= worldHeight; ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int curX = ix + x;
                    int curZ = iz + z;
                    Block block = world.getBlock(curX, y, curZ);
                    if (block == null || block.id() == 0 || !(block.getLogic() instanceof IBonemealable)) continue;
                    bonemealableBlock.add(new Point(curX, y, curZ));
                }
            }
        }
        return bonemealableBlock;
    }

    public static Set<ChunkCoordinate> getLoadedChunks(World world, int playerChunkX, int playerChunkY, int playerChunkZ) {
        HashSet<ChunkCoordinate> loadedChunks = new HashSet<ChunkCoordinate>();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                int chunkCoordX = x + playerChunkX;
                int chunkCoordZ = z + playerChunkZ;
                if (!world.isChunkLoaded(chunkCoordX, chunkCoordZ)) continue;
                loadedChunks.add(new ChunkCoordinate(chunkCoordX, chunkCoordZ));
            }
        }
        return loadedChunks;
    }
}

