/*
 * Decompiled with CFR 0.152.
 */
package redart15.commandly.veincapitator;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ToolMaterial;
import net.minecraft.core.item.tool.ItemToolPickaxe;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.ChunkPosition;
import org.jetbrains.annotations.NotNull;
import redart15.commandly.veincapitator.OreGroups;
import redart15.commandly.veincapitator.OreTags;
import redart15.commandly.veincapitator.PickAxeRegister;

public class VeinMining {
    private static final int MAX_VEIN_SIZE = 64;
    private final World world;
    private final ItemStack tool;
    private final ChunkPosition point;
    private final Player player;
    private Tag<Block<?>> miningTag = BlockTags.MINEABLE_BY_PICKAXE;
    private int radius;
    private HashSet<NamespaceID> miningGroup;
    private boolean onlyThisID = false;
    private ItemList clumpingList;

    public VeinMining(World world, ItemStack itemStack, int x, int y, int z, Player player) {
        this.world = world;
        this.tool = itemStack;
        this.point = new ChunkPosition(x, y, z);
        this.player = player;
        this.radius = 1;
    }

    public static VeinMining veinMining(World world, ItemStack itemStack, int x, int y, int z, Player player) {
        return new VeinMining(world, itemStack, x, y, z, player);
    }

    public VeinMining setMiningTag(Tag<Block<?>> mininTag) {
        this.miningTag = mininTag;
        return this;
    }

    public VeinMining setRadius(int radius) {
        this.radius = radius;
        return this;
    }

    public boolean mine(int blockId, Side side) {
        Block block = Blocks.getBlock((int)blockId);
        if (block == null || !this.canBeVeinMined(block)) {
            return false;
        }
        this.miningGroup = this.getGroup(block);
        boolean itemStackDamageable = this.tool.isItemStackDamageable();
        ToolMaterial material = PickAxeRegister.getMaterial(this.tool.getItem());
        EnumDropCause dropCause = material.isSilkTouch() ? EnumDropCause.SILK_TOUCH : EnumDropCause.PROPER_TOOL;
        int veinSize = 64;
        if (itemStackDamageable) {
            int durabilityLeft = this.tool.getMaxDamage() - this.tool.getMetadata();
            veinSize = Math.min(durabilityLeft, 64);
        }
        Set<ChunkPosition> toBeMined = this.findAllOreBlocks(veinSize);
        if (EntityItem.enableItemClumping) {
            this.clumpingList = new ItemList(this.world, this.point);
        }
        for (ChunkPosition pos : toBeMined) {
            if (!this.breakBlock(pos, dropCause) || !itemStackDamageable) continue;
            this.tool.damageItem(1, (Entity)this.player);
            if (this.tool.stackSize > 0) continue;
            this.player.destroyCurrentEquippedItem();
        }
        if (EntityItem.enableItemClumping) {
            this.clumpingList.dropAllItems();
        }
        return true;
    }

    private boolean canBeVeinMined(Block<?> block) {
        Block theBlock = this.world.getBlock(this.point.x, this.point.y, this.point.z);
        if (theBlock == null || theBlock.id() != block.id()) {
            return false;
        }
        if (!block.hasTag(this.miningTag)) {
            return false;
        }
        if (this.tool == null) {
            return false;
        }
        Item toolItem = this.tool.getItem();
        if (!(toolItem instanceof ItemToolPickaxe) && !PickAxeRegister.containsID(toolItem.id)) {
            return false;
        }
        int toolMiningLevel = PickAxeRegister.getMiningLevel(toolItem);
        int blockMiningLevel = ItemToolPickaxe.miningLevels.getOrDefault(block, 0);
        if (blockMiningLevel > toolMiningLevel) {
            return false;
        }
        return block.hasTag(OreTags.ORE) || this.languageKeyOre(block);
    }

    private boolean languageKeyOre(Block<?> block) {
        String[] substrings;
        String language_key = block.getLanguageKey(0);
        for (String str : substrings = language_key.split("\\.")) {
            if (!str.equalsIgnoreCase("ore")) continue;
            this.onlyThisID = true;
            return true;
        }
        return false;
    }

    private HashSet<NamespaceID> getGroup(Block<?> block) {
        if (this.onlyThisID) {
            this.onlyThisID = false;
            HashSet<NamespaceID> set = new HashSet<NamespaceID>();
            set.add(block.namespaceId());
            return set;
        }
        return OreGroups.instance.getOreGroupFromMember(block);
    }

    private Set<ChunkPosition> findAllOreBlocks(int veinSize) {
        ArrayDeque<ChunkPosition> queue = new ArrayDeque<ChunkPosition>();
        LinkedHashSet<ChunkPosition> visited = new LinkedHashSet<ChunkPosition>();
        queue.add(this.point);
        visited.add(this.point);
        while (!queue.isEmpty() && veinSize > 0) {
            ChunkPosition from = (ChunkPosition)queue.poll();
            for (int offX = -this.radius; offX <= this.radius; ++offX) {
                for (int offY = -this.radius; offY <= this.radius; ++offY) {
                    for (int offZ = -this.radius; offZ <= this.radius; ++offZ) {
                        Block nextBlock;
                        ChunkPosition to;
                        if (offX == 0 && offZ == 0 && offY == 0 || visited.contains(to = new ChunkPosition(from.x + offX, from.y + offY, from.z + offZ)) || (nextBlock = this.world.getBlock(to.x, to.y, to.z)) == null || !this.miningGroup.contains(nextBlock.namespaceId())) continue;
                        visited.add(to);
                        queue.add(to);
                        if (--veinSize > 0) continue;
                        return visited;
                    }
                }
            }
        }
        return visited;
    }

    private boolean breakBlock(ChunkPosition pos, EnumDropCause dropCause) {
        Block block = this.world.getBlock(pos.x, pos.y, pos.z);
        int meta = this.world.getBlockMetadata(pos.x, pos.y, pos.z);
        if (block == null) {
            return false;
        }
        if (!this.world.setBlockWithNotify(pos.x, pos.y, pos.z, 0)) {
            return false;
        }
        if (this.player.getGamemode().dropBlockOnBreak()) {
            if (EntityItem.enableItemClumping) {
                ItemStack[] drops = this.getBreakResult(block, this.world, dropCause, pos.x, pos.y, pos.z, meta, null);
                this.clumpingList.addAllItems(drops);
            } else {
                block.getLogic().harvestBlock(this.world, this.player, pos.x, pos.y, pos.z, meta, (TileEntity)null);
            }
        }
        this.world.playBlockEvent(this.player, 2001, pos.x, pos.y, pos.z, block.id());
        return true;
    }

    protected void dropItems(ItemStack[] items, ChunkPosition pos) {
        if (items == null) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            ItemStack stack = items[i];
            while (stack.stackSize > 0) {
                this.world.dropItem(pos.x, pos.y, pos.z, stack.splitStack(1));
            }
        }
    }

    private ItemStack[] getBreakResult(@NotNull Block<?> block, World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        ItemStack[] result = block.getBreakResult(world, dropCause, x, y, z, meta, tileEntity);
        if (!this.canGetAdditionalBreakResults(block, this.tool.getItem(), meta)) {
            return result;
        }
        return this.getAdditionalBreakResult(world, result, meta, block);
    }

    private boolean canGetAdditionalBreakResults(Block<?> block, Item tool, int meta) {
        try {
            BlockLogic logic = block.getLogic();
            Method method = logic.getClass().getMethod("canGetAdditionalBreakResult", Item.class, Integer.class);
            return (Boolean)method.invoke((Object)logic, tool, meta);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private ItemStack[] getAdditionalBreakResult(World world, ItemStack[] result, int meta, Block<?> block) {
        try {
            BlockLogic logic = block.getLogic();
            Method method = logic.getClass().getMethod("getAdditionalBreakResult", World.class, Item.class, ItemStack[].class, Integer.class);
            return (ItemStack[])method.invoke((Object)logic, world, this.tool.getItem(), result, meta);
        }
        catch (NoSuchMethodException e) {
            return result;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static class ItemList {
        private final World world;
        private final ChunkPosition point;
        private final Map<ItemStack, Integer> itemList = new HashMap<ItemStack, Integer>();

        public ItemList(World world, ChunkPosition point) {
            this.world = world;
            this.point = point;
        }

        private void dropAllItems() {
            for (Map.Entry<ItemStack, Integer> entry : this.itemList.entrySet()) {
                ItemStack itemStack = entry.getKey();
                int count = entry.getValue();
                while (entry.getKey().stackSize > 0) {
                    this.world.dropItem(this.point.x, this.point.y, this.point.z, itemStack.splitStack(Math.min(count, itemStack.getMaxStackSize())));
                }
            }
        }

        private void addAllItems(ItemStack[] itemStacks) {
            for (ItemStack item : itemStacks) {
                this.itemList.merge(item, 1, Integer::sum);
            }
        }
    }
}

