/*
 * Decompiled with CFR 0.152.
 */
package redart15.commandly;

import java.io.IOException;
import redart15.commandly.CommandlyMod;
import turniplabs.halplibe.util.TomlConfigHandler;
import turniplabs.halplibe.util.toml.Toml;

public class CommandlyConfig {
    public static int SMART_VALUE = 128;
    public static boolean SMART_VEINMINER = false;
    public static boolean SMART_TREECAPITATOR = false;

    public static void init() {
        Toml properties = new Toml("Commandly Config");
        properties.addCategory("Smart Commands").addEntry("SMART_VEINMINER", (Object)SMART_VEINMINER).addEntry("SMART_TREECAPITATOR", (Object)SMART_TREECAPITATOR);
        TomlConfigHandler config = new TomlConfigHandler("commandly", properties);
        if (config.getConfigFile().exists()) {
            config.loadConfig();
        } else {
            try {
                if (config.getConfigFile().createNewFile()) {
                    CommandlyMod.LOGGER.info("Commandly Config initialized.");
                }
            }
            catch (IOException e) {
                CommandlyMod.LOGGER.error("Commandly Config failed to generate, deleted the config and try again.");
                throw new RuntimeException(e);
            }
        }
        config.writeConfig();
        SMART_VEINMINER = config.getBoolean(CommandlyConfig.key("Smart Commands", "SMART_VEINMINER"));
        SMART_TREECAPITATOR = config.getBoolean(CommandlyConfig.key("Smart Commands", "SMART_TREECAPITATOR"));
        CommandlyMod.LOGGER.info("Commandly Config loaded.");
    }

    private static String key(String category, String key) {
        return StrBuilder.str(category).append(".").append(key).toString();
    }

    public static class StrBuilder {
        public static StringBuilder str() {
            return new StringBuilder();
        }

        public static StringBuilder str(String string) {
            return new StringBuilder(string);
        }
    }
}

