/*
 * Decompiled with CFR 0.152.
 */
package redart15.commandly.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.ArgumentTypeInteger;
import com.mojang.brigadier.builder.ArgumentBuilderLiteral;
import com.mojang.brigadier.builder.ArgumentBuilderRequired;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Predicate;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.command.CommandManager;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.arguments.ArgumentTypeVec3;
import net.minecraft.core.net.command.helpers.DoubleCoordinate;
import net.minecraft.core.net.command.helpers.DoubleCoordinates;
import net.minecraft.core.world.World;
import redart15.commandly.CommandlyConfig;
import redart15.commandly.CommandlyMod;
import redart15.commandly.command.CommandlyCommands;
import redart15.commandly.treecapitator.TreeCapitator;
import redart15.commandly.veincapitator.VeinMining;
import turniplabs.halplibe.helper.EnvironmentHelper;

public class CommandProtect
implements CommandManager.CommandRegistry {
    public void register(CommandDispatcher<CommandSource> dispatcher) {
        ArgumentBuilderLiteral command = (ArgumentBuilderLiteral)((ArgumentBuilderLiteral)((ArgumentBuilderLiteral)((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal((String)"protect").requires(t -> ((CommandSource)t).hasAdmin())).then(((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal((String)"chunk").executes(CommandProtect::chunk)).then(ArgumentBuilderRequired.argument((String)"point", (ArgumentType)ArgumentTypeVec3.vec3d()).executes(CommandProtect::chunk)))).then(((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal((String)"radius").then(ArgumentBuilderRequired.argument((String)"radius", (ArgumentType)ArgumentTypeInteger.integer()).executes(CommandProtect::radius))).then(ArgumentBuilderRequired.argument((String)"radius", (ArgumentType)ArgumentTypeInteger.integer()).then(ArgumentBuilderRequired.argument((String)"Point", (ArgumentType)ArgumentTypeVec3.vec3d()).executes(CommandProtect::radius))))).then(((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal((String)"points").then(ArgumentBuilderRequired.argument((String)"second point", (ArgumentType)ArgumentTypeVec3.vec3d()).executes(CommandProtect::points))).then(ArgumentBuilderRequired.argument((String)"first point", (ArgumentType)ArgumentTypeVec3.vec3d()).then(ArgumentBuilderRequired.argument((String)"second point", (ArgumentType)ArgumentTypeVec3.vec3d()).executes(CommandProtect::points))));
        dispatcher.register(command);
    }

    private static int chunk(CommandContext<Object> context) {
        DoubleCoordinates p1;
        if (!CommandlyConfig.SMART_VEINMINER && !CommandlyConfig.SMART_TREECAPITATOR) {
            ((CommandSource)context.getSource()).sendTranslatableMessage("commandly.all.inactive", new Object[0]);
            return CommandlyCommands.ReturnValues.code(CommandlyCommands.ReturnValues.CANNOT);
        }
        Predicate<Block<?>> treecapitator = block -> false;
        Predicate<Block<?>> veinmining = block -> false;
        if (CommandlyConfig.SMART_TREECAPITATOR) {
            treecapitator = block -> TreeCapitator.canTreecapitated(block);
        }
        if (CommandlyConfig.SMART_VEINMINER) {
            veinmining = block -> VeinMining.canBeVeinMinedCommand(block);
        }
        CommandSource source = (CommandSource)context.getSource();
        World world = source.getWorld();
        try {
            p1 = (DoubleCoordinates)context.getArgument("point", DoubleCoordinates.class);
        }
        catch (IllegalArgumentException noargs) {
            Player player = source.getSender();
            DoubleCoordinate x = new DoubleCoordinate(false, player.x);
            DoubleCoordinate y = new DoubleCoordinate(false, player.y);
            DoubleCoordinate z = new DoubleCoordinate(false, player.z);
            p1 = new DoubleCoordinates(x, y, z);
        }
        return CommandProtect.chunks_protect(source, world, treecapitator, veinmining, p1);
    }

    private static int chunks_protect(CommandSource source, World world, Predicate<Block<?>> treecapitator, Predicate<Block<?>> veinmining, DoubleCoordinates p1) {
        int fz;
        int fx;
        try {
            fx = (int)Math.round(p1.getX(source));
            int fy = (int)Math.round(p1.getY(source, EnvironmentHelper.isServerEnvironment()));
            fz = (int)Math.round(p1.getZ(source));
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
        fx = Math.floorDiv(fx, 16) * 16;
        fz = Math.floorDiv(fz, 16) * 16;
        int count_protected = 0;
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y <= world.getHeightBlocks(); ++y) {
                for (int z = 0; z < 16; ++z) {
                    Block block = world.getBlock(fx + x, y, fz + z);
                    if (block == null || !treecapitator.test(block) && !veinmining.test(block)) continue;
                    int metadata = world.getBlockMetadata(fx + x, y, fz + z);
                    world.setBlockMetadata(fx + x, y, fz + z, 1 << CommandlyMod.getMask() | metadata);
                    ++count_protected;
                }
            }
        }
        if (count_protected == 0) {
            source.sendTranslatableMessage("commandly.protected.fail", new Object[0]);
            return CommandlyCommands.ReturnValues.code(CommandlyCommands.ReturnValues.FAIL);
        }
        source.sendTranslatableMessage("commandly.protected.active", new Object[]{count_protected});
        return CommandlyCommands.ReturnValues.code(CommandlyCommands.ReturnValues.OK);
    }

    private static int radius(CommandContext<Object> context) {
        DoubleCoordinates p1;
        if (!CommandlyConfig.SMART_VEINMINER && !CommandlyConfig.SMART_TREECAPITATOR) {
            ((CommandSource)context.getSource()).sendTranslatableMessage("commandly.all.inactive", new Object[0]);
            return CommandlyCommands.ReturnValues.code(CommandlyCommands.ReturnValues.CANNOT);
        }
        Predicate<Block<?>> treecapitator = block -> false;
        Predicate<Block<?>> veinmining = block -> false;
        if (CommandlyConfig.SMART_TREECAPITATOR) {
            treecapitator = block -> TreeCapitator.canTreecapitated(block);
        }
        if (CommandlyConfig.SMART_VEINMINER) {
            veinmining = block -> VeinMining.canBeVeinMinedCommand(block);
        }
        CommandSource source = (CommandSource)context.getSource();
        World world = source.getWorld();
        try {
            p1 = (DoubleCoordinates)context.getArgument("point", DoubleCoordinates.class);
        }
        catch (IllegalArgumentException noargs) {
            Player player = source.getSender();
            DoubleCoordinate x = new DoubleCoordinate(false, player.x);
            DoubleCoordinate y = new DoubleCoordinate(false, player.y);
            DoubleCoordinate z = new DoubleCoordinate(false, player.z);
            p1 = new DoubleCoordinates(x, y, z);
        }
        int radius = (Integer)context.getArgument("radius", Integer.class);
        return CommandProtect.radius_protect(source, world, treecapitator, veinmining, radius, p1);
    }

    private static int radius_protect(CommandSource source, World world, Predicate<Block<?>> treecapitator, Predicate<Block<?>> veinmining, int radius, DoubleCoordinates p1) {
        int fz;
        int fy;
        int fx;
        try {
            fx = (int)Math.round(p1.getX(source));
            fy = (int)Math.round(p1.getY(source, EnvironmentHelper.isServerEnvironment()));
            fz = (int)Math.round(p1.getZ(source));
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
        if ((int)Math.floor(3.9269908169872414 * Math.pow(radius, 3.0)) > CommandlyMod.getMaxBlockCount()) {
            source.sendTranslatableMessage("commadly.protected.toolarge", new Object[0]);
            return CommandlyCommands.ReturnValues.code(CommandlyCommands.ReturnValues.CANNOT);
        }
        int count_protected = 0;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    Block block;
                    if (x * x + y * y + z * z >= radius * radius || (block = world.getBlock(fx + x, fy + y, fz + z)) == null || !treecapitator.test(block) && !veinmining.test(block)) continue;
                    int metadata = world.getBlockMetadata(fx + x, y, fz + z);
                    world.setBlockMetadata(fx + x, y, fz + z, 1 << CommandlyMod.getMask() | metadata);
                    ++count_protected;
                }
            }
        }
        if (count_protected == 0) {
            source.sendTranslatableMessage("commandly.protected.fail", new Object[0]);
            return CommandlyCommands.ReturnValues.code(CommandlyCommands.ReturnValues.FAIL);
        }
        source.sendTranslatableMessage("commandly.protected.active", new Object[]{count_protected});
        return CommandlyCommands.ReturnValues.code(CommandlyCommands.ReturnValues.OK);
    }

    private static int points(CommandContext<Object> context) {
        DoubleCoordinates p1;
        if (!CommandlyConfig.SMART_VEINMINER && !CommandlyConfig.SMART_TREECAPITATOR) {
            ((CommandSource)context.getSource()).sendTranslatableMessage("commandly.all.inactive", new Object[0]);
            return CommandlyCommands.ReturnValues.code(CommandlyCommands.ReturnValues.CANNOT);
        }
        Predicate<Block<?>> treecapitator = block -> false;
        Predicate<Block<?>> veinmining = block -> false;
        if (CommandlyConfig.SMART_TREECAPITATOR) {
            treecapitator = block -> TreeCapitator.canTreecapitated(block);
        }
        if (CommandlyConfig.SMART_VEINMINER) {
            veinmining = block -> VeinMining.canBeVeinMinedCommand(block);
        }
        CommandSource sauce = (CommandSource)context.getSource();
        World world = sauce.getWorld();
        try {
            p1 = (DoubleCoordinates)context.getArgument("first point", DoubleCoordinates.class);
        }
        catch (IllegalArgumentException noargs) {
            Player player = sauce.getSender();
            DoubleCoordinate x = new DoubleCoordinate(false, player.x);
            DoubleCoordinate y = new DoubleCoordinate(false, player.y);
            DoubleCoordinate z = new DoubleCoordinate(false, player.z);
            p1 = new DoubleCoordinates(x, y, z);
        }
        DoubleCoordinates p2 = (DoubleCoordinates)context.getArgument("second point", DoubleCoordinates.class);
        return CommandProtect.point_protect(sauce, world, p1, p2, treecapitator, veinmining);
    }

    public static int point_protect(CommandSource source, World world, DoubleCoordinates p1, DoubleCoordinates p2, Predicate<Block<?>> treecapitator, Predicate<Block<?>> veinmining) {
        int sz;
        int sy;
        int sx;
        int fz;
        int fy;
        int fx;
        try {
            fx = (int)Math.round(p1.getX(source));
            fy = (int)Math.round(p1.getY(source, EnvironmentHelper.isServerEnvironment()));
            fz = (int)Math.round(p1.getZ(source));
            sx = (int)Math.round(p2.getX(source));
            sy = (int)Math.round(p2.getY(source, EnvironmentHelper.isServerEnvironment()));
            sz = (int)Math.round(p2.getZ(source));
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
        if (Math.abs(fx - sx) * Math.abs(fy - sy) * Math.abs(fz - sz) > CommandlyMod.getMaxBlockCount()) {
            source.sendTranslatableMessage("commadly.protected.toolarge", new Object[0]);
            return CommandlyCommands.ReturnValues.code(CommandlyCommands.ReturnValues.CANNOT);
        }
        int count_protected = 0;
        for (int x = Math.min(fx, sx); x <= Math.max(fx, sx); ++x) {
            for (int y = Math.min(fy, sy); y <= Math.max(fy, sy); ++y) {
                for (int z = Math.min(fz, sz); z <= Math.max(fz, sz); ++z) {
                    Block block = world.getBlock(x, y, z);
                    if (block == null || !treecapitator.test(block) && !veinmining.test(block)) continue;
                    int metadata = world.getBlockMetadata(fx + x, y, fz + z);
                    world.setBlockMetadata(fx + x, y, fz + z, 1 << CommandlyMod.getMask() | metadata);
                    ++count_protected;
                }
            }
        }
        if (count_protected == 0) {
            source.sendTranslatableMessage("commandly.protected.fail", new Object[0]);
            return CommandlyCommands.ReturnValues.code(CommandlyCommands.ReturnValues.FAIL);
        }
        source.sendTranslatableMessage("commandly.protected.active", new Object[]{count_protected});
        return CommandlyCommands.ReturnValues.code(CommandlyCommands.ReturnValues.OK);
    }
}

