/*
 * Decompiled with CFR 0.152.
 */
package redart15.commandly.mixins.treecapitator;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.IPaintable;
import net.minecraft.core.data.gamerule.TreecapitatorHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.ChunkPosition;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import redart15.commandly.CommandlyMod;

@Mixin(value={TreecapitatorHelper.class}, remap=false)
public abstract class SmartTreeCapitator {
    @Shadow
    @Final
    public World world;

    @WrapOperation(method={"chopTree()Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/data/gamerule/TreecapitatorHelper;isLog(Lnet/minecraft/core/block/Block;)Z")})
    public boolean isSmartLog(TreecapitatorHelper instance, Block<?> block, Operation<Boolean> original) {
        TreecapitatorHelper asThis = (TreecapitatorHelper)this;
        ChunkPosition p = asThis.basePosition;
        int metadata = asThis.world.getBlockMetadata(p.x, p.y, p.z);
        return block != null && !(block.getLogic() instanceof IPaintable) && metadata >> CommandlyMod.getMask() == 0 && (Boolean)original.call(new Object[]{instance, block}) != false;
    }

    @Unique
    private int getBlockWrapper(World instance, int x, int y, int z, Operation<Integer> original) {
        int blockID = (Integer)original.call(new Object[]{instance, x, y, z});
        Block block = Blocks.getBlock((int)blockID);
        int metadata = this.world.getBlockMetadata(x, y, z);
        if (block != null && SmartTreeCapitator.isSmartTreecapitator(block.getLogic(), metadata)) {
            return 0;
        }
        return blockID;
    }

    @WrapOperation(method={"chopTree()Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/world/World;getBlockId(III)I")})
    private int getBlockID_addLogsAroundBlock(World instance, int x, int y, int z, Operation<Integer> original) {
        return this.getBlockWrapper(instance, x, y, z, original);
    }

    @Unique
    private static boolean isSmartTreecapitator(@NotNull BlockLogic logic, int metadata) {
        return logic instanceof IPaintable || metadata >> CommandlyMod.getMask() == 1;
    }
}

