/*
 * Decompiled with CFR 0.152.
 */
package net.brazier_modding.gdarp.mixin;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.brazier_modding.gdarp.Constants;
import net.brazier_modding.gdarp.config.PackConfig;
import net.brazier_modding.gdarp.mixin.PackAccessor;
import net.brazier_modding.gdarp.pack_finders.GlobalPackFinder;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.RepositorySource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PackRepository.class})
public abstract class PackRepositoryMixin {
    @Mutable
    @Accessor(value="sources")
    abstract Set<RepositorySource> globalPacks_getSources();

    @Inject(method={"discoverAvailable"}, at={@At(value="RETURN")}, cancellable=true)
    public void globalpackls_discoverAvailable(CallbackInfoReturnable<Map<String, Pack>> cir) {
        List<String> requiredBuiltinPacks;
        LinkedHashMap otherPacks = Maps.newLinkedHashMap();
        LinkedHashMap forceEnablePacks = Maps.newLinkedHashMap();
        LinkedHashMap globalPacks = Maps.newLinkedHashMap();
        LinkedHashMap mergedPacks = Maps.newLinkedHashMap();
        PackType packType = null;
        for (RepositorySource packSource : this.globalPacks_getSources()) {
            if (!(packSource instanceof GlobalPackFinder)) continue;
            GlobalPackFinder globalPackFinder = (GlobalPackFinder)packSource;
            globalPackFinder.m_7686_(pack -> globalPacks.put(pack.m_10446_(), pack));
            packType = globalPackFinder.packType;
        }
        List<String> list = requiredBuiltinPacks = packType == PackType.CLIENT_RESOURCES ? PackConfig.INSTANCE.getRequiredBuiltinResourcePacks() : PackConfig.INSTANCE.getRequiredBuiltinDataPacks();
        if (PackConfig.INSTANCE.logPacks()) {
            Constants.LOG.info("# Listing {} Packs #", (Object)(packType == PackType.CLIENT_RESOURCES ? "Resource" : "Data"));
        }
        for (RepositorySource repositorySource : this.globalPacks_getSources()) {
            if (repositorySource instanceof GlobalPackFinder) continue;
            repositorySource.m_7686_(pack -> {
                for (Map.Entry entryGlobal : globalPacks.entrySet()) {
                    if (!pack.m_10429_().equals(((Pack)entryGlobal.getValue()).m_10429_())) continue;
                    return;
                }
                if (requiredBuiltinPacks.contains(pack.m_10446_())) {
                    forceEnablePacks.put(pack.m_10446_(), pack);
                } else {
                    otherPacks.put(pack.m_10446_(), pack);
                }
                if (PackConfig.INSTANCE.logPacks()) {
                    Constants.LOG.info(pack.m_10446_());
                }
            });
        }
        if (PackConfig.INSTANCE.logPacks()) {
            Constants.LOG.info("# Listing {} Packs - END #", (Object)(packType == PackType.CLIENT_RESOURCES ? "Resource" : "Data"));
            Constants.LOG.info("# Set 'log_pack_ids' to false in the 'global_packs.toml' config");
        }
        mergedPacks.putAll(otherPacks);
        mergedPacks.putAll(globalPacks);
        for (Map.Entry entry : forceEnablePacks.entrySet()) {
            Pack pack2 = (Pack)entry.getValue();
            ((PackAccessor)pack2).globalPacks_setPosition(Pack.Position.TOP);
            ((PackAccessor)pack2).globalPacks_setRequired(true);
            ((PackAccessor)pack2).globalPacks_setFixedPosition(true);
            mergedPacks.put((String)entry.getKey(), pack2);
        }
        cir.setReturnValue((Object)ImmutableMap.copyOf((Map)mergedPacks));
    }
}

