/*
 * Decompiled with CFR 0.152.
 */
package io.github.yunivers.yuniutil.block;

import io.github.yunivers.yuniutil.YuniUtil;
import io.github.yunivers.yuniutil.block.entity.YuniChestBlockEntity;
import io.github.yunivers.yuniutil.screen.YuniChestScreenHandler;
import io.github.yunivers.yuniutil.util.EDoubleChestSide;
import java.util.Random;
import net.minecraft.class_110;
import net.minecraft.class_134;
import net.minecraft.class_142;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_31;
import net.minecraft.class_320;
import net.minecraft.class_339;
import net.minecraft.class_54;
import net.minecraft.class_55;
import net.minecraft.class_57;
import net.minecraft.class_71;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.gui.screen.container.GuiHelper;
import net.modificationstation.stationapi.api.item.ItemPlacementContext;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.BooleanProperty;
import net.modificationstation.stationapi.api.state.property.EnumProperty;
import net.modificationstation.stationapi.api.state.property.Property;
import net.modificationstation.stationapi.api.template.block.TemplateBlockWithEntity;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.math.Direction;

public abstract class YuniTemplateChestBlock
extends TemplateBlockWithEntity {
    public static final EnumProperty<Direction> FACING_PROPERTY = EnumProperty.of((String)"facing", Direction.class);
    public static final EnumProperty<EDoubleChestSide> DOUBLE_SIDE_PROPERTY = EnumProperty.of((String)"double_side", EDoubleChestSide.class);
    public static final BooleanProperty IS_DOUBLE_PROPERTY = BooleanProperty.of((String)"is_double");
    private final Random random = new Random();
    private final int invSize;
    private final int singleRows;
    private final int largeRows;
    private String name;
    public static int GUI_Rows;

    public YuniTemplateChestBlock(int id, class_15 material, String name, int invSize, int singleRows, int largeRows) {
        super(id, material);
        this.method_1591();
        this.setDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateManager().getDefaultState()).with(FACING_PROPERTY, (Comparable)Direction.NORTH)).with(DOUBLE_SIDE_PROPERTY, (Comparable)((Object)EDoubleChestSide.LEFT))).with((Property)IS_DOUBLE_PROPERTY, (Comparable)Boolean.valueOf(false)));
        this.name = name;
        this.invSize = invSize;
        this.singleRows = singleRows;
        this.largeRows = largeRows;
    }

    public YuniTemplateChestBlock(int id, class_15 material) {
        this(id, material, "Chest", 27, 3, 3);
    }

    public YuniTemplateChestBlock(Identifier identifier, class_15 material, String name, int invSize, int singleRows, int largeRows) {
        super(identifier, material);
        this.method_1591();
        this.setDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateManager().getDefaultState()).with(FACING_PROPERTY, (Comparable)Direction.NORTH)).with(DOUBLE_SIDE_PROPERTY, (Comparable)((Object)EDoubleChestSide.LEFT))).with((Property)IS_DOUBLE_PROPERTY, (Comparable)Boolean.valueOf(false)));
        this.name = name;
        this.invSize = invSize;
        this.singleRows = singleRows;
        this.largeRows = largeRows;
    }

    public YuniTemplateChestBlock(Identifier identifier, class_15 material) {
        this(identifier, material, "Chest", 27, 3, 3);
    }

    public void appendProperties(StateManager.Builder<class_17, BlockState> builder) {
        super.appendProperties(builder);
        builder.add(new Property[]{FACING_PROPERTY});
        builder.add(new Property[]{DOUBLE_SIDE_PROPERTY});
        builder.add(new Property[]{IS_DOUBLE_PROPERTY});
    }

    public BlockState getPlacementState(ItemPlacementContext context) {
        Direction facing = context.getHorizontalPlayerFacing().rotateClockwise(Direction.Axis.Y);
        Direction.Axis facingAxis = facing.getAxis();
        BlockState state = (BlockState)this.getDefaultState().with(FACING_PROPERTY, (Comparable)facing);
        class_54 player = context.getPlayer();
        class_18 world = context.getWorld();
        class_339 pos = context.getBlockPos();
        class_339 facingPos = pos.offset(context.getSide().getOpposite());
        class_17 facingBlock = class_17.field_1937[world.method_1776(facingPos.field_2100, facingPos.field_2101, facingPos.field_2102)];
        BlockState facingState = world.getBlockState(facingPos);
        if (!this.canBeDouble()) {
            return state;
        }
        if (player != null && player.method_1373() && context.getSide().getAxis() != Direction.Axis.Y && facingBlock.field_1915 == this.field_1915 && !((Boolean)facingState.get((Property)IS_DOUBLE_PROPERTY)).booleanValue()) {
            facing = (Direction)facingState.get(FACING_PROPERTY);
            state = (BlockState)state.with(FACING_PROPERTY, (Comparable)facing);
            state = (BlockState)state.with(DOUBLE_SIDE_PROPERTY, (Comparable)((Object)(facingPos.equals((Object)pos.offset(facing)) ? EDoubleChestSide.LEFT : EDoubleChestSide.RIGHT)));
            state = (BlockState)state.with((Property)IS_DOUBLE_PROPERTY, (Comparable)Boolean.valueOf(true));
            class_55 facingEntity = world.method_1777(facingPos.field_2100, facingPos.field_2101, facingPos.field_2102);
            facingState = (BlockState)facingState.with((Property)IS_DOUBLE_PROPERTY, (Comparable)Boolean.valueOf(true));
            facingState = (BlockState)facingState.with(DOUBLE_SIDE_PROPERTY, (Comparable)((Object)((EDoubleChestSide)((Object)state.get(DOUBLE_SIDE_PROPERTY))).getOpposite()));
            world.setBlockState(facingPos, facingState);
            world.method_157(facingPos.field_2100, facingPos.field_2101, facingPos.field_2102, facingEntity);
        } else if (player != null && !player.method_1373()) {
            for (Direction dir : Direction.values()) {
                if (dir.getAxis() != facingAxis) continue;
                class_339 checkPos = pos.offset(dir);
                class_17 checkBlock = class_17.field_1937[world.method_1776(checkPos.field_2100, checkPos.field_2101, checkPos.field_2102)];
                BlockState checkState = world.getBlockState(checkPos);
                if (checkBlock.field_1915 != this.field_1915 || ((Boolean)checkState.get((Property)IS_DOUBLE_PROPERTY)).booleanValue()) continue;
                state = (BlockState)state.with(DOUBLE_SIDE_PROPERTY, (Comparable)((Object)(checkPos.equals((Object)pos.offset(facing)) ? EDoubleChestSide.LEFT : EDoubleChestSide.RIGHT)));
                state = (BlockState)state.with((Property)IS_DOUBLE_PROPERTY, (Comparable)Boolean.valueOf(true));
                class_55 checkEntity = world.method_1777(checkPos.field_2100, checkPos.field_2101, checkPos.field_2102);
                checkState = (BlockState)checkState.with((Property)IS_DOUBLE_PROPERTY, (Comparable)Boolean.valueOf(true));
                checkState = (BlockState)checkState.with(DOUBLE_SIDE_PROPERTY, (Comparable)((Object)((EDoubleChestSide)((Object)state.get(DOUBLE_SIDE_PROPERTY))).getOpposite()));
                checkState = (BlockState)checkState.with(FACING_PROPERTY, (Comparable)((Direction)state.get(FACING_PROPERTY)));
                world.setBlockState(checkPos, checkState);
                world.method_157(checkPos.field_2100, checkPos.field_2101, checkPos.field_2102, checkEntity);
                break;
            }
        }
        return state;
    }

    public void method_1609(class_18 world, int x, int y, int z, int id) {
        class_339 pos = this.connectionBlockPos(world, x, y, z);
        if (pos != null && world.method_234(pos.field_2100, pos.field_2101, pos.field_2102)) {
            class_55 entity = world.method_1777(x, y, z);
            BlockState state = world.getBlockState(x, y, z);
            state = (BlockState)state.with((Property)IS_DOUBLE_PROPERTY, (Comparable)Boolean.valueOf(false));
            world.setBlockState(x, y, z, state);
            world.method_157(x, y, z, entity);
        }
    }

    public boolean method_1608(class_18 world, int x, int y, int z, class_54 player) {
        if (player.method_1373() && !this.sneakingPlayerCanOpen()) {
            return false;
        }
        class_55 chest = world.method_1777(x, y, z);
        class_339 connectionPos = this.connectionBlockPos(world, x, y, z);
        if (this.cantOpen(world, x, y, z) || connectionPos != null && this.cantOpen(world, connectionPos.field_2100, connectionPos.field_2101, connectionPos.field_2102)) {
            return true;
        }
        if (chest instanceof class_134) {
            class_134 chestInv = (class_134)chest;
            BlockState state = world.getBlockState(x, y, z);
            if (connectionPos != null && state.get(DOUBLE_SIDE_PROPERTY) == EDoubleChestSide.LEFT) {
                chestInv = new class_320("Large " + this.name, chestInv, (class_134)world.method_1777(connectionPos.field_2100, connectionPos.field_2101, connectionPos.field_2102));
            } else if (connectionPos != null && state.get(DOUBLE_SIDE_PROPERTY) == EDoubleChestSide.RIGHT) {
                chestInv = new class_320("Large " + this.name, (class_134)world.method_1777(connectionPos.field_2100, connectionPos.field_2101, connectionPos.field_2102), chestInv);
            }
            int n = GUI_Rows = connectionPos != null ? this.largeRows * 2 : this.singleRows;
            if (!world.field_180) {
                this.openGUI(player, chestInv, connectionPos != null);
            }
        }
        return true;
    }

    public boolean cantOpen(class_18 world, int x, int y, int z) {
        class_17 topBlock = class_17.field_1937[world.method_1776(x, y + 1, z)];
        return !(topBlock instanceof YuniTemplateChestBlock) && topBlock.method_1620();
    }

    public class_339 connectionBlockPos(class_18 world, int x, int y, int z) {
        BlockState state = world.getBlockState(x, y, z);
        if (!((Boolean)state.get((Property)IS_DOUBLE_PROPERTY)).booleanValue()) {
            return null;
        }
        Direction facing = (Direction)state.get(FACING_PROPERTY);
        EDoubleChestSide side = (EDoubleChestSide)((Object)state.get(DOUBLE_SIDE_PROPERTY));
        class_339 pos = new class_339(x, y, z);
        return pos.offset(facing, side == EDoubleChestSide.LEFT ? 1 : -1);
    }

    public void method_1630(class_18 world, int x, int y, int z) {
        class_55 chest = world.method_1777(x, y, z);
        if (chest instanceof class_134) {
            class_134 chestInv = (class_134)chest;
            for (int i = 0; i < chestInv.method_948(); ++i) {
                class_31 stack = chestInv.method_954(i);
                if (stack == null) continue;
                float xOffset = this.random.nextFloat() * 0.8f + 0.1f;
                float yOffset = this.random.nextFloat() * 0.8f + 0.1f;
                float zOffset = this.random.nextFloat() * 0.8f + 0.1f;
                while (stack.field_751 > 0) {
                    int dropCount = this.random.nextInt(21) + 10;
                    if (dropCount > stack.field_751) {
                        dropCount = stack.field_751;
                    }
                    stack.field_751 -= dropCount;
                    class_142 droppedItem = new class_142(world, (double)((float)x + xOffset), (double)((float)y + yOffset), (double)((float)z + zOffset), new class_31(stack.field_753, dropCount, stack.method_722()));
                    droppedItem.field_1603 = (float)this.random.nextGaussian() * 0.05f;
                    droppedItem.field_1604 = (float)this.random.nextGaussian() * 0.05f + 0.2f;
                    droppedItem.field_1605 = (float)this.random.nextGaussian() * 0.05f;
                    world.method_210((class_57)droppedItem);
                }
            }
        }
        super.method_1630(world, x, y, z);
    }

    public boolean method_1561(class_18 world, int x, int y, int z, int side) {
        if (!this.canVerticallyStack()) {
            class_17 topBlock = class_17.field_1937[world.method_1776(x, y + 1, z)];
            class_17 bottomBlock = class_17.field_1937[world.method_1776(x, y - 1, z)];
            if (topBlock instanceof class_110 || topBlock instanceof YuniTemplateChestBlock || bottomBlock instanceof class_110 || bottomBlock instanceof YuniTemplateChestBlock) {
                return false;
            }
        }
        return true;
    }

    protected class_55 method_1251() {
        return new YuniChestBlockEntity(this.name, this.invSize);
    }

    public class_71 getScreenHandler(class_54 player, class_134 inventory, boolean isDouble) {
        return new YuniChestScreenHandler((class_134)player.field_519, inventory, GUI_Rows, isDouble);
    }

    public void openGUI(class_54 player, class_134 inventory, boolean isDouble) {
        GuiHelper.openGUI((class_54)player, (Identifier)YuniUtil.NAMESPACE.id("openYuniChest"), (class_134)inventory, (class_71)this.getScreenHandler(player, inventory, isDouble));
    }

    public boolean canBeDouble() {
        return true;
    }

    public boolean sneakingPlayerCanOpen() {
        return false;
    }

    public boolean canVerticallyStack() {
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

