/*
 * Decompiled with CFR 0.152.
 */
package io.github.yunivers.yuniutil.impl.energy;

import io.github.yunivers.yuniutil.api.energy.IEnergyContainerItem;
import net.minecraft.class_31;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.template.item.TemplateItem;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.impl.item.StationNBTSetter;

public class ItemEnergyContainer
extends TemplateItem
implements IEnergyContainerItem {
    public static final String ENERGY = "Energy";
    protected int capacity;
    protected int maxReceive;
    protected int maxExtract;

    public ItemEnergyContainer(Identifier identifier) {
        super(identifier);
    }

    public ItemEnergyContainer(Identifier identifier, int capacity) {
        this(identifier, capacity, capacity, capacity);
    }

    public ItemEnergyContainer(Identifier identifier, int capacity, int maxTransfer) {
        this(identifier, capacity, maxTransfer, maxTransfer);
    }

    public ItemEnergyContainer(Identifier identifier, int capacity, int maxReceive, int maxExtract) {
        super(identifier);
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public ItemEnergyContainer setCapacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public ItemEnergyContainer setMaxTransfer(int maxTransfer) {
        this.setMaxReceive(maxTransfer);
        this.setMaxExtract(maxTransfer);
        return this;
    }

    public ItemEnergyContainer setMaxReceive(int maxReceive) {
        this.maxReceive = maxReceive;
        return this;
    }

    public ItemEnergyContainer setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
        return this;
    }

    @Override
    public int receiveEnergy(class_31 container, int maxReceive, boolean simulate) {
        class_8 nbt = container.getStationNbt();
        if (nbt == null) {
            nbt = new class_8();
        }
        int stored = Math.min(nbt.method_1027(ENERGY), this.getMaxEnergyStored(container));
        int energyReceived = Math.min(this.capacity - stored, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            nbt.method_1015(ENERGY, stored += energyReceived);
        }
        ((StationNBTSetter)container).setStationNbt(nbt);
        return energyReceived;
    }

    @Override
    public int extractEnergy(class_31 container, int maxExtract, boolean simulate) {
        class_8 nbt = container.getStationNbt();
        if (nbt == null || !nbt.method_1023(ENERGY)) {
            return 0;
        }
        int stored = Math.min(nbt.method_1027(ENERGY), this.getMaxEnergyStored(container));
        int energyExtracted = Math.min(stored, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            nbt.method_1015(ENERGY, stored -= energyExtracted);
        }
        ((StationNBTSetter)container).setStationNbt(nbt);
        return energyExtracted;
    }

    @Override
    public int getEnergyStored(class_31 container) {
        class_8 nbt = container.getStationNbt();
        if (nbt == null || !nbt.method_1023(ENERGY)) {
            return 0;
        }
        return Math.min(nbt.method_1027(ENERGY), this.getMaxEnergyStored(container));
    }

    @Override
    public int getMaxEnergyStored(class_31 container) {
        return this.capacity;
    }
}

