/*
 * Decompiled with CFR 0.152.
 */
package io.github.yunivers.yuniutil.structure;

import io.github.yunivers.yuniutil.structure.StructureBoundingBox;
import io.github.yunivers.yuniutil.structure.StructureComponent;
import io.github.yunivers.yuniutil.structure.StructureStart;
import io.github.yunivers.yuniutil.world.chunk.ChunkCoordIntPair;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.class_105;
import net.minecraft.class_18;
import net.minecraft.class_339;
import net.minecraft.class_51;

public abstract class StructureGenerator
extends class_105 {
    protected HashMap<Long, StructureStart> coordMap = new HashMap();
    protected class_18 world;

    public void method_395(class_51 source, class_18 world, int chunkX, int chunkZ, byte[] blocks) {
        this.world = world;
        super.method_395(source, world, chunkX, chunkZ, blocks);
    }

    protected void method_396(class_18 world, int startChunkX, int startChunkZ, int chunkX, int chunkZ, byte[] blocks) {
        this.world = world;
        long coordHash = ChunkCoordIntPair.chunkXZ2Int(startChunkX, startChunkZ);
        if (this.coordMap.containsKey(coordHash)) {
            return;
        }
        this.field_331.nextInt();
        if (this.canSpawnStructureAtCoords(startChunkX, startChunkZ)) {
            StructureStart start = this.getStructureStart(startChunkX, startChunkZ);
            this.coordMap.put(coordHash, start);
        }
    }

    public boolean generateStructuresInChunk(class_18 world, Random random, int chunkX, int chunkZ) {
        int x = (chunkX << 4) + 8;
        int z = (chunkZ << 4) + 8;
        boolean generated = false;
        for (StructureStart start : this.coordMap.values()) {
            if (!start.isSizeableStructure() || !start.getBoundingBox().isInsideStructureBB(x, z, x + 15, z + 15)) continue;
            start.generateStructure(world, random, new StructureBoundingBox(x, z, x + 15, z + 15));
            generated = true;
        }
        return generated;
    }

    public boolean positionInsideStructure(int x, int y, int z) {
        for (StructureStart start : this.coordMap.values()) {
            if (!start.isSizeableStructure() || !start.getBoundingBox().isInsideStructureBB(x, z, x, z)) continue;
            for (StructureComponent component : start.getComponents()) {
                if (!component.getBoundingBox().isVecInside(x, y, z)) continue;
                return true;
            }
        }
        return false;
    }

    public class_339 getLocatorPosition(class_18 world, int xOffset, int yOffset, int zOffset) {
        this.world = world;
        this.field_331.setSeed(world.method_254());
        long xRandom = this.field_331.nextLong();
        long zRandom = this.field_331.nextLong();
        long xSeedCalc = (long)(xOffset >> 4) * xRandom;
        long zSeedCalc = (long)(zOffset >> 4) * zRandom;
        this.field_331.setSeed(xSeedCalc ^ zSeedCalc ^ world.method_254());
        this.method_396(world, xOffset >> 4, zOffset >> 4, 0, 0, null);
        double minDistance = Double.MAX_VALUE;
        class_339 closestStructureStart = null;
        for (StructureStart start : this.coordMap.values()) {
            if (!start.isSizeableStructure()) continue;
            class_339 structureStart = start.getComponents().get(0).getCenterBlock();
            int x = structureStart.field_2100 - xOffset;
            int y = structureStart.field_2101 - yOffset;
            int z = structureStart.field_2102 - zOffset;
            double distance = x + x * y * y + z * z;
            if (distance >= minDistance) continue;
            minDistance = distance;
            closestStructureStart = structureStart;
        }
        if (closestStructureStart != null) {
            return closestStructureStart;
        }
        List<class_339> origins = this.getStructureOrigins();
        if (origins != null) {
            class_339 closestOrigin = null;
            for (class_339 origin : origins) {
                int x = origin.field_2100 - xOffset;
                int y = origin.field_2101 - yOffset;
                int z = origin.field_2102 - zOffset;
                double distance = x + x * y * y + z * z;
                if (distance >= minDistance) continue;
                minDistance = distance;
                closestOrigin = origin;
            }
            return closestOrigin;
        }
        return null;
    }

    protected List<class_339> getStructureOrigins() {
        return null;
    }

    protected abstract boolean canSpawnStructureAtCoords(int var1, int var2);

    protected abstract StructureStart getStructureStart(int var1, int var2);
}

