/*
 * Decompiled with CFR 0.152.
 */
package io.github.yunivers.yuniutil.structure;

import io.github.yunivers.yuniutil.structure.StructureBoundingBox;
import io.github.yunivers.yuniutil.structure.StructureComponent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.class_18;

public abstract class StructureStart {
    protected LinkedList<StructureComponent> components = new LinkedList();
    protected StructureBoundingBox boundingBox;

    protected StructureStart() {
    }

    public void generateStructure(class_18 world, Random random, StructureBoundingBox box) {
        Iterator iterator = this.components.iterator();
        while (iterator.hasNext()) {
            StructureComponent component = (StructureComponent)iterator.next();
            if (!component.getBoundingBox().intersectsWith(box) || component.addComponentParts(world, random, box)) continue;
            iterator.remove();
        }
    }

    protected void updateBoundingBox() {
        this.boundingBox = StructureBoundingBox.getNewBoundingBox();
        for (StructureComponent component : this.components) {
            this.boundingBox.resizeBoundingBoxTo(component.getBoundingBox());
        }
    }

    protected void markAvailableHeight(class_18 world, Random random, int yPush) {
        int maxY = world.getHeight() / 2 - 1 - yPush;
        int boxHeight = this.boundingBox.getYSize() + 1;
        if (boxHeight < maxY) {
            boxHeight += random.nextInt(maxY - boxHeight);
        }
        int yOffset = boxHeight - this.boundingBox.maxY;
        this.boundingBox.offset(0, yOffset, 0);
        for (StructureComponent component : this.components) {
            component.getBoundingBox().offset(0, yOffset, 0);
        }
    }

    protected void calculateStructureY(class_18 world, Random random, int minY, int maxY) {
        int height = maxY - minY + 1 - this.boundingBox.getYSize();
        int maxHeight = height > 1 ? minY + random.nextInt(height) : minY;
        int yOffset = maxHeight - this.boundingBox.minY;
        this.boundingBox.offset(0, yOffset, 0);
        for (StructureComponent component : this.components) {
            component.getBoundingBox().offset(0, yOffset, 0);
        }
    }

    public boolean isSizeableStructure() {
        return true;
    }

    public LinkedList<StructureComponent> getComponents() {
        return this.components;
    }

    public StructureBoundingBox getBoundingBox() {
        return this.boundingBox;
    }
}

