/*
 * Decompiled with CFR 0.152.
 */
package io.github.yunivers.yuniutil.util;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import net.minecraft.class_584;
import net.minecraft.class_67;

public class TextureYuniUtil {
    public static BufferedImage convertFile(Path path, int width, int height) throws IOException {
        byte[] rgba = Files.readAllBytes(path);
        BufferedImage restored = new BufferedImage(width, height, 2);
        int index = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int r = rgba[index++] & 0xFF;
                int g = rgba[index++] & 0xFF;
                int b = rgba[index++] & 0xFF;
                int a = rgba[index++] & 0xFF;
                int argb = a << 24 | r << 16 | g << 8 | b;
                restored.setRGB(x, y, argb);
            }
        }
        return restored;
    }

    public static class DrawContextHelper {
        public static void drawTexture(class_584 draw, double x, double y, double width, double height, double u, double v, int texWidth, int texHeight) {
            DrawContextHelper.drawTexture(draw, x, y, width, height, u, v, width, height, texWidth, texHeight);
        }

        public static void drawTexture(class_584 draw, double x, double y, double width, double height, double u, double v, double scaledWidth, double scaledHeight, int texWidth, int texHeight) {
            double scaleU = 1.0 / (double)texWidth;
            double scaleV = 1.0 / (double)texHeight;
            double minX = x;
            double minY = y;
            double maxX = x + scaledWidth;
            double maxY = y + scaledHeight;
            double minU = u * scaleU;
            double minV = v * scaleV;
            double maxU = (u + width) * scaleU;
            double maxV = (v + height) * scaleV;
            class_67 t = class_67.field_2054;
            t.method_1695();
            t.method_1688(minX, maxY, (double)draw.field_2522, minU, maxV);
            t.method_1688(maxX, maxY, (double)draw.field_2522, maxU, maxV);
            t.method_1688(maxX, minY, (double)draw.field_2522, maxU, minV);
            t.method_1688(minX, minY, (double)draw.field_2522, minU, minV);
            t.method_1685();
        }
    }
}

