/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.inhabitor.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.maxhenkel.inhabitor.Inhabitor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2264;
import net.minecraft.class_2561;
import net.minecraft.class_2818;
import net.minecraft.server.MinecraftServer;

public class InhabitorCommands {
    public static final String INHABITOR_COMMAND = "inhabitor";

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder literalBuilder = (LiteralArgumentBuilder)class_2170.method_9247((String)INHABITOR_COMMAND).requires(stack -> stack.method_9259(Inhabitor.CONFIG.inhabitorCommandPermissionLevel.get().intValue()));
        literalBuilder.then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"from", (ArgumentType)class_2264.method_9701()).then(class_2170.method_9244((String)"to", (ArgumentType)class_2264.method_9701()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).executes(context -> InhabitorCommands.addInhabitedTime((CommandContext<class_2168>)context, true))))));
        literalBuilder.then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"from", (ArgumentType)class_2264.method_9701()).then(class_2170.method_9244((String)"to", (ArgumentType)class_2264.method_9701()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).executes(context -> InhabitorCommands.addInhabitedTime((CommandContext<class_2168>)context, true))))));
        dispatcher.register(literalBuilder);
    }

    public static int addInhabitedTime(CommandContext<class_2168> context, boolean add) {
        class_1923 from = class_2264.method_9702(context, (String)"from").method_34873();
        class_1923 to = class_2264.method_9702(context, (String)"to").method_34873();
        int fromX = Math.min(from.field_9181, to.field_9181);
        int fromZ = Math.min(from.field_9180, to.field_9180);
        int toX = Math.max(from.field_9181, to.field_9181);
        int toZ = Math.max(from.field_9180, to.field_9180);
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        int totalChunkCount = (toX - fromX + 1) * (toZ - fromZ + 1);
        AtomicInteger x = new AtomicInteger(fromX);
        AtomicInteger z = new AtomicInteger(fromZ);
        AtomicInteger count = new AtomicInteger(0);
        AtomicLong lastUpdate = new AtomicLong(0L);
        MinecraftServer server = ((class_2168)context.getSource()).method_9225().method_8503();
        AtomicReference<Runnable> taskReference = new AtomicReference<Runnable>();
        Runnable task = () -> {
            class_2818 chunk;
            int chunkX = x.getAndIncrement();
            int chunkZ = z.get();
            if (chunkX > toX) {
                chunkX = fromX;
                x.set(fromX + 1);
                chunkZ = z.incrementAndGet();
                if (chunkZ > toZ) {
                    if (count.get() > 0) {
                        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully updated inhabitedTime for %s chunks".formatted(count.get())), false);
                    } else {
                        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Did not update any chunks"));
                    }
                    return;
                }
            }
            if ((chunk = ((class_2168)context.getSource()).method_9225().method_8497(chunkX, chunkZ)) != null) {
                if (add) {
                    chunk.method_12028(chunk.method_12033() + (long)amount);
                } else {
                    chunk.method_12028((long)amount);
                }
                chunk.method_65063();
                count.incrementAndGet();
                if (System.currentTimeMillis() - lastUpdate.get() > 1000L) {
                    lastUpdate.set(System.currentTimeMillis());
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Updated %s/%s chunks (%s%%)".formatted(count.get(), totalChunkCount, (int)((float)count.get() / (float)totalChunkCount * 100.0f))), false);
                }
            }
            server.execute((Runnable)taskReference.get());
        };
        taskReference.set(task);
        server.execute(task);
        return 1;
    }
}

