/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.woodworks.entity;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.macuguita.woodworks.block.SittableBlock;
import com.macuguita.woodworks.reg.GWEntityTypes;
import com.mojang.serialization.Codec;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
public class Seat
extends Entity {
    public static final Multimap<ResourceKey<Level>, BlockPos> SITTING_POSITIONS = ArrayListMultimap.create();
    private AABB shape;
    private boolean remove;
    private static final EntityDataAccessor<Boolean> CAN_ROTATE = SynchedEntityData.defineId(Seat.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public Seat(EntityType<? extends Entity> type, Level world) {
        super(type, world);
        this.setLevelCallback(EntityInLevelCallback.NULL);
    }

    @Nullable
    public static Seat of(Level world, BlockPos pos, Direction dir) {
        Seat entity;
        BlockState state = world.getBlockState(pos);
        AABB shape = new AABB(pos);
        Block block = state.getBlock();
        if (block instanceof SittableBlock) {
            SittableBlock seat = (SittableBlock)block;
            shape = seat.getSeatSize(state);
        }
        if ((entity = (Seat)((EntityType)GWEntityTypes.SEAT.get()).create(world, EntitySpawnReason.TRIGGERED)) == null) {
            return null;
        }
        if (dir != null) {
            entity.setYRot(dir.toYRot());
        } else {
            entity.setCanRotate(true);
        }
        entity.setPosRaw((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5);
        entity.shape = Seat.copyBox(shape);
        return entity;
    }

    public boolean canRotate() {
        return (Boolean)this.getEntityData().get(CAN_ROTATE);
    }

    public void setCanRotate(boolean rotate) {
        this.getEntityData().set(CAN_ROTATE, (Object)rotate);
    }

    private static AABB copyBox(AABB box) {
        return new AABB(box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ);
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity tracker) {
        return new ClientboundAddEntityPacket((Entity)this, tracker, this.canRotate() ? 1 : 0);
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        this.setCanRotate(packet.getData() == 1);
    }

    public boolean isInvulnerable() {
        return true;
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }

    protected void readAdditionalSaveData(ValueInput view) {
        this.setCanRotate(view.read("can_rotate", (Codec)Codec.BOOL).orElse(false));
    }

    protected void addAdditionalSaveData(ValueOutput view) {
        view.store("can_rotate", (Codec)Codec.BOOL, (Object)this.canRotate());
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        Direction facing = this.getDirection();
        BlockPos seatPos = this.blockPosition();
        Vec3 seatCenter = this.position();
        for (Direction offset : new Direction[]{facing, facing.getClockWise(), facing.getCounterClockWise(), facing.getOpposite()}) {
            BlockPos targetPos = seatPos.relative(offset);
            Vec3 dismountPos = DismountHelper.findSafeDismountLocation((EntityType)passenger.getType(), (CollisionGetter)this.level(), (BlockPos)targetPos, (boolean)false);
            if (dismountPos == null) continue;
            double distance = dismountPos.distanceToSqr(seatCenter);
            if (distance > 9.0) {
                return seatCenter.add(0.0, 1.0, 0.0);
            }
            return new Vec3(dismountPos.x, dismountPos.y + (double)passenger.getBbHeight() * 0.5 + 0.1, dismountPos.z);
        }
        return this.position().add(0.0, 1.0, 0.0);
    }

    public void tick() {
        ServerLevel serverWorld;
        super.tick();
        Level level = this.level();
        if (level instanceof ServerLevel && (!((serverWorld = (ServerLevel)level).getBlockState(this.blockPosition()).getBlock() instanceof SittableBlock) || this.remove)) {
            this.removeSeat();
        }
    }

    public boolean hurtClient(DamageSource source) {
        return !this.isInvulnerableToBase(source);
    }

    public boolean hurtServer(ServerLevel world, DamageSource source, float amount) {
        return false;
    }

    protected void removePassenger(Entity passenger) {
        super.removePassenger(passenger);
        if (this.level() instanceof ServerLevel && this.getPassengers().isEmpty()) {
            this.remove = true;
        }
    }

    public void removeSeat() {
        SITTING_POSITIONS.get((Object)this.level().dimension()).remove(this.blockPosition());
        this.discard();
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dims, float partialTick) {
        if (this.shape == null) {
            return super.getPassengerAttachmentPoint(entity, dims, partialTick);
        }
        return new Vec3(0.0, (double)((float)(this.shape.getYsize() * 0.75) + 0.2f), 0.0);
    }

    protected void clampRotation(Entity entity) {
        entity.setYBodyRot(this.getYRot());
        float diff = Mth.wrapDegrees((float)(entity.getYRot() - this.getYRot()));
        float clamped = Mth.clamp((float)diff, (float)-105.0f, (float)105.0f);
        entity.yRotO += clamped - diff;
        entity.setYRot(entity.getYRot() + clamped - diff);
        entity.setYHeadRot(entity.getYRot());
    }

    public void onPassengerTurned(Entity entity) {
        if (!this.canRotate()) {
            this.clampRotation(entity);
        }
    }

    public void setLevelCallback(EntityInLevelCallback callback) {
        super.setLevelCallback((EntityInLevelCallback)new WrappedCallback(callback));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(CAN_ROTATE, (Object)false);
    }

    private class WrappedCallback
    implements EntityInLevelCallback {
        private final EntityInLevelCallback delegate;

        public WrappedCallback(EntityInLevelCallback delegate) {
            this.delegate = delegate;
        }

        public void onMove() {
            if (this.delegate != null) {
                this.delegate.onMove();
                Block block = Seat.this.level().getBlockState(Seat.this.blockPosition()).getBlock();
                if (block instanceof SittableBlock) {
                    SittableBlock seat = (SittableBlock)block;
                    Seat.this.shape = seat.getSeatSize(Seat.this.level().getBlockState(Seat.this.blockPosition()));
                }
            } else {
                Seat.this.shape = null;
            }
        }

        public void onRemove(Entity.RemovalReason reason) {
            if (this.delegate != null) {
                this.delegate.onRemove(reason);
            }
        }
    }
}

