/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.woodworks.compat;

import com.macuguita.woodworks.GuitaWoodworks;
import com.macuguita.woodworks.block.CarvedLogSeatBlock;
import com.macuguita.woodworks.block.HollowLogBlock;
import com.macuguita.woodworks.block.ResizableBeamBlock;
import com.macuguita.woodworks.block.StumpSeatBlock;
import com.macuguita.woodworks.mixin.FireBlockAccessor;
import com.macuguita.woodworks.reg.GWBlockTags;
import com.macuguita.woodworks.reg.GWItemTags;
import com.macuguita.woodworks.reg.GWObjects;
import com.macuguita.woodworks.utils.GWUtils;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.EntrySet;
import net.mehvahdjukaar.every_compat.api.PaletteStrategies;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.misc.CompatSpritesHelper;
import net.mehvahdjukaar.every_compat.misc.HardcodedBlockType;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureCollager;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class WoodGood
extends SimpleModule {
    public final SimpleEntrySet<WoodType, class_2248> stump;
    public final SimpleEntrySet<WoodType, class_2248> strippedStump;
    public final SimpleEntrySet<WoodType, class_2248> carvedLog;
    public final SimpleEntrySet<WoodType, class_2248> strippedCarvedLog;
    public final SimpleEntrySet<WoodType, class_2248> beam;
    public final SimpleEntrySet<WoodType, class_2248> strippedBeam;
    public final SimpleEntrySet<WoodType, class_2248> hollowLog;
    public final SimpleEntrySet<WoodType, class_2248> strippedHollowLog;

    public WoodGood(String modId) {
        super(modId, "gww", "everycomp");
        class_2960 tab = this.modRes("main");
        this.stump = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, (String)"stump", GWObjects.OAK_STUMP, () -> VanillaWoodTypes.OAK, w -> new StumpSeatBlock(Utils.copyPropertySafe((class_2248)w.log))).addTexture(this.modRes("block/oak_stump_top"), PaletteStrategies.LOG_SIDE_STANDARD)).addTag(GWItemTags.STUMP, class_7924.field_41197)).addTag(GWBlockTags.STUMP, class_7924.field_41254)).setTabKey(tab)).excludeBlockTypes("natures_spirit", new String[]{"joshua"})).excludeBlockTypes("natures_spirit", new String[]{"coconut"})).excludeBlockTypes("terrestria", new String[]{"sakura"})).excludeBlockTypes("terrestria", new String[]{"yucca_palm"})).defaultRecipe().build();
        this.addEntry((EntrySet)this.stump);
        this.strippedStump = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, (String)"stump", (String)"stripped", GWObjects.STRIPPED_OAK_STUMP, () -> VanillaWoodTypes.OAK, w -> new StumpSeatBlock(Utils.copyPropertySafe((class_2248)w.log))).requiresChildren(new String[]{"stripped_log"})).addTexture(this.modRes("block/stripped_oak_stump_top"), PaletteStrategies.STRIPPED_LOG_SIDE_STANDARD)).addTag(GWItemTags.STUMP, class_7924.field_41197)).addTag(GWBlockTags.STUMP, class_7924.field_41254)).setTabKey(tab)).excludeBlockTypes("natures_spirit", new String[]{"joshua"})).excludeBlockTypes("natures_spirit", new String[]{"coconut"})).excludeBlockTypes("terrestria", new String[]{"sakura"})).excludeBlockTypes("terrestria", new String[]{"yucca_palm"})).defaultRecipe().build();
        this.addEntry((EntrySet)this.strippedStump);
        this.carvedLog = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, (String)"log", (String)"carved", GWObjects.CARVED_OAK_LOG, () -> VanillaWoodTypes.OAK, w -> new CarvedLogSeatBlock(Utils.copyPropertySafe((class_2248)w.log))).addTag(GWItemTags.CARVED_LOG, class_7924.field_41197)).addTag(GWBlockTags.CARVED_LOG, class_7924.field_41254)).setTabKey(tab)).excludeBlockTypes("natures_spirit", new String[]{"joshua"})).excludeBlockTypes("natures_spirit", new String[]{"coconut"})).excludeBlockTypes("terrestria", new String[]{"sakura"})).excludeBlockTypes("terrestria", new String[]{"yucca_palm"})).defaultRecipe().build();
        this.addEntry((EntrySet)this.carvedLog);
        this.strippedCarvedLog = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, (String)"log", (String)"stripped_carved", GWObjects.STRIPPED_CARVED_OAK_LOG, () -> VanillaWoodTypes.OAK, w -> new CarvedLogSeatBlock(Utils.copyPropertySafe((class_2248)w.log))).addTag(GWItemTags.CARVED_LOG, class_7924.field_41197)).addTag(GWBlockTags.CARVED_LOG, class_7924.field_41254)).setTabKey(tab)).excludeBlockTypes("natures_spirit", new String[]{"joshua"})).excludeBlockTypes("natures_spirit", new String[]{"coconut"})).excludeBlockTypes("terrestria", new String[]{"sakura"})).excludeBlockTypes("terrestria", new String[]{"yucca_palm"})).defaultRecipe().build();
        this.addEntry((EntrySet)this.strippedCarvedLog);
        this.beam = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, (String)"beam", GWObjects.OAK_BEAM, () -> VanillaWoodTypes.OAK, w -> new ResizableBeamBlock(Utils.copyPropertySafe((class_2248)w.log))).addTag(GWItemTags.BEAM, class_7924.field_41197)).addTag(GWBlockTags.BEAM, class_7924.field_41254)).setTabKey(tab)).excludeBlockTypes("natures_spirit", new String[]{"joshua"})).excludeBlockTypes("natures_spirit", new String[]{"coconut"})).excludeBlockTypes("terrestria", new String[]{"sakura"})).excludeBlockTypes("terrestria", new String[]{"yucca_palm"})).defaultRecipe().build();
        this.addEntry((EntrySet)this.beam);
        this.strippedBeam = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, (String)"beam", (String)"stripped", GWObjects.STRIPPED_OAK_BEAM, () -> VanillaWoodTypes.OAK, w -> new ResizableBeamBlock(Utils.copyPropertySafe((class_2248)w.log))).addTag(GWItemTags.BEAM, class_7924.field_41197)).addTag(GWBlockTags.BEAM, class_7924.field_41254)).setTabKey(tab)).excludeBlockTypes("natures_spirit", new String[]{"joshua"})).excludeBlockTypes("natures_spirit", new String[]{"coconut"})).excludeBlockTypes("terrestria", new String[]{"sakura"})).excludeBlockTypes("terrestria", new String[]{"yucca_palm"})).defaultRecipe().build();
        this.addEntry((EntrySet)this.strippedBeam);
        this.hollowLog = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, (String)"log", (String)"hollow", GWObjects.HOLLOW_OAK_LOG, () -> VanillaWoodTypes.OAK, w -> new HollowLogBlock(Utils.copyPropertySafe((class_2248)w.log))).requiresChildren(new String[]{"stripped_log"})).addTag(GWItemTags.BEAM, class_7924.field_41197)).addTag(GWBlockTags.BEAM, class_7924.field_41254)).setTabKey(tab)).excludeBlockTypes("natures_spirit", new String[]{"joshua"})).excludeBlockTypes("natures_spirit", new String[]{"coconut"})).excludeBlockTypes("terrestria", new String[]{"sakura"})).excludeBlockTypes("terrestria", new String[]{"yucca_palm"})).defaultRecipe().build();
        this.addEntry((EntrySet)this.hollowLog);
        this.strippedHollowLog = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, (String)"log", (String)"stripped_hollow", GWObjects.STRIPPED_HOLLOW_OAK_LOG, () -> VanillaWoodTypes.OAK, w -> new HollowLogBlock(Utils.copyPropertySafe((class_2248)w.log))).requiresChildren(new String[]{"stripped_log"})).addTag(GWItemTags.BEAM, class_7924.field_41197)).addTag(GWBlockTags.BEAM, class_7924.field_41254)).setTabKey(tab)).excludeBlockTypes("natures_spirit", new String[]{"joshua"})).excludeBlockTypes("natures_spirit", new String[]{"coconut"})).excludeBlockTypes("terrestria", new String[]{"sakura"})).excludeBlockTypes("terrestria", new String[]{"yucca_palm"})).defaultRecipe().build();
        this.addEntry((EntrySet)this.strippedHollowLog);
    }

    public void onModSetup() {
        this.stump.blocks.forEach((w, block) -> {
            class_2248 stripped = (class_2248)this.strippedStump.blocks.get(w);
            GWUtils.registerFuel(150, (class_1935)block);
            ((FireBlockAccessor)class_2246.field_10036).gwoodworks$registerFlammableBlock((class_2248)block, 5, 5);
            if (stripped != null) {
                StumpSeatBlock.STRIPPED_STUMPS.put((class_2248)block, stripped);
                GWUtils.registerFuel(150, (class_1935)stripped);
                ((FireBlockAccessor)class_2246.field_10036).gwoodworks$registerFlammableBlock(stripped, 5, 5);
            }
        });
        this.carvedLog.blocks.forEach((w, block) -> {
            class_2248 stripped = (class_2248)this.strippedCarvedLog.blocks.get(w);
            GWUtils.registerFuel(250, (class_1935)block);
            ((FireBlockAccessor)class_2246.field_10036).gwoodworks$registerFlammableBlock((class_2248)block, 5, 5);
            if (stripped != null) {
                CarvedLogSeatBlock.STRIPPED_CARVED_LOGS.put((class_2248)block, stripped);
                GWUtils.registerFuel(250, (class_1935)stripped);
                ((FireBlockAccessor)class_2246.field_10036).gwoodworks$registerFlammableBlock(stripped, 5, 5);
            }
        });
        this.beam.blocks.forEach((w, block) -> {
            class_2248 stripped = (class_2248)this.strippedBeam.blocks.get(w);
            GWUtils.registerFuel(75, (class_1935)block);
            ((FireBlockAccessor)class_2246.field_10036).gwoodworks$registerFlammableBlock((class_2248)block, 5, 5);
            if (stripped != null) {
                ResizableBeamBlock.STRIPPED_BEAM_BLOCKS.put((class_2248)block, stripped);
                GWUtils.registerFuel(75, (class_1935)stripped);
                ((FireBlockAccessor)class_2246.field_10036).gwoodworks$registerFlammableBlock(stripped, 5, 5);
            }
        });
        this.hollowLog.blocks.forEach((w, block) -> {
            class_2248 stripped = (class_2248)this.strippedHollowLog.blocks.get(w);
            GWUtils.registerFuel(150, (class_1935)block);
            ((FireBlockAccessor)class_2246.field_10036).gwoodworks$registerFlammableBlock((class_2248)block, 5, 5);
            if (stripped != null) {
                HollowLogBlock.STRIPPED_HOLLOW_LOGS.put((class_2248)block, stripped);
                GWUtils.registerFuel(150, (class_1935)stripped);
                ((FireBlockAccessor)class_2246.field_10036).gwoodworks$registerFlammableBlock(stripped, 5, 5);
            }
        });
    }

    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);
        executor.accept((manager, sink) -> {
            try {
                this.stump.blocks.forEach((w, block) -> {
                    class_2960 id = Utils.getID((class_2248)block);
                    try (TextureImage topTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)w.log, (Predicate)CompatSpritesHelper.LOOKS_LIKE_TOP_LOG_TEXTURE));){
                        class_2960 newId = EveryCompat.res((String)BlockTypeResTransformer.replaceTypeNoNamespace((String)"block/oak_stump_top", (BlockType)w, (class_2960)id, (String)"oak"));
                        TextureImage newTop = topTexture.makeCopy();
                        this.generateStumpTexture(topTexture, newTop);
                        sink.addTextureIfNotPresent(manager, newId.toString(), () -> newTop);
                    }
                    catch (Exception e) {
                        GuitaWoodworks.LOGGER.error("Failed to generate texture for {} : {}", block, (Object)e);
                    }
                });
            }
            catch (Exception e) {
                GuitaWoodworks.LOGGER.error("Failed to open stump_top texture: ", (Throwable)e);
            }
            try {
                this.strippedStump.blocks.forEach((w, block) -> {
                    class_2960 id = Utils.getID((class_2248)block);
                    try (TextureImage topTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)w.getBlockOfThis("stripped_log"), (Predicate)CompatSpritesHelper.LOOKS_LIKE_TOP_LOG_TEXTURE));){
                        class_2960 newId = EveryCompat.res((String)BlockTypeResTransformer.replaceTypeNoNamespace((String)"block/stripped_oak_stump_top", (BlockType)w, (class_2960)id, (String)"oak"));
                        TextureImage newTop = topTexture.makeCopy();
                        this.generateStumpTexture(topTexture, newTop);
                        sink.addTextureIfNotPresent(manager, newId.toString(), () -> newTop);
                    }
                    catch (Exception e) {
                        GuitaWoodworks.LOGGER.error("Failed to generate texture for {} : {}", block, (Object)e);
                    }
                });
            }
            catch (Exception e) {
                GuitaWoodworks.LOGGER.error("Failed to open stump_top texture: ", (Throwable)e);
            }
            try (TextureImage insideEdgeMask = TextureImage.open((class_3300)manager, (class_2960)GuitaWoodworks.id("block/mask/carved_log_inside_edge"));
                 TextureImage insideMask = TextureImage.open((class_3300)manager, (class_2960)GuitaWoodworks.id("block/mask/carved_log_inside"));){
                this.carvedLog.blocks.forEach((woodType, block) -> {
                    class_2960 id = Utils.getID((class_2248)block);
                    String texturePath = "block/carved_oak_log_inside";
                    try (TextureImage carvedOakLogInsideTexture = TextureImage.open((class_3300)manager, (class_2960)GuitaWoodworks.id(texturePath));
                         TextureImage logSideTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)woodType.log, (Predicate)CompatSpritesHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
                         TextureImage planksTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)woodType.planks));){
                        class_2960 newId = EveryCompat.res((String)BlockTypeResTransformer.replaceTypeNoNamespace((String)texturePath, (BlockType)woodType, (class_2960)id, (String)"oak"));
                        TextureImage finishedTexture = this.generateCarvedLogInsideTexture(carvedOakLogInsideTexture, logSideTexture, planksTexture, insideEdgeMask, insideMask);
                        sink.addTextureIfNotPresent(manager, newId.toString(), () -> finishedTexture);
                    }
                    catch (Exception e) {
                        GuitaWoodworks.LOGGER.error("Failed to generate texture for {} : {}", block, (Object)e);
                    }
                });
                this.strippedCarvedLog.blocks.forEach((w, block) -> {
                    class_2960 id = Utils.getID((class_2248)block);
                    String texturePath = "block/stripped_carved_oak_log_inside";
                    try (TextureImage strippedCarvedLogTexture = TextureImage.open((class_3300)manager, (class_2960)GuitaWoodworks.id(texturePath));
                         TextureImage logSideTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)w.getBlockOfThis("stripped_log"), (Predicate)CompatSpritesHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
                         TextureImage planksTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)w.planks));){
                        class_2960 newId = EveryCompat.res((String)BlockTypeResTransformer.replaceTypeNoNamespace((String)texturePath, (BlockType)w, (class_2960)id, (String)"oak"));
                        TextureImage finishedTexture = this.generateCarvedLogInsideTexture(strippedCarvedLogTexture, logSideTexture, planksTexture, insideEdgeMask, insideMask);
                        sink.addTextureIfNotPresent(manager, newId.toString(), () -> finishedTexture);
                    }
                    catch (Exception e) {
                        GuitaWoodworks.LOGGER.error("Failed to generate texture for {} : {}", block, (Object)e);
                    }
                });
            }
            catch (Exception e) {
                GuitaWoodworks.LOGGER.error("Failed to open the mask texture: ", (Throwable)e);
            }
            try {
                this.beam.blocks.forEach((w, block) -> {
                    class_2960 id = Utils.getID((class_2248)block);
                    String baseTexturePath = "block/oak_beam_top";
                    try (TextureImage topTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)w.log, (Predicate)CompatSpritesHelper.LOOKS_LIKE_TOP_LOG_TEXTURE));){
                        class_2960 newId2x2 = EveryCompat.res((String)BlockTypeResTransformer.replaceTypeNoNamespace((String)(baseTexturePath + "_2x2"), (BlockType)w, (class_2960)id, (String)"oak"));
                        class_2960 newId4x4 = EveryCompat.res((String)BlockTypeResTransformer.replaceTypeNoNamespace((String)(baseTexturePath + "_4x4"), (BlockType)w, (class_2960)id, (String)"oak"));
                        class_2960 newId6x6 = EveryCompat.res((String)BlockTypeResTransformer.replaceTypeNoNamespace((String)(baseTexturePath + "_6x6"), (BlockType)w, (class_2960)id, (String)"oak"));
                        class_2960 newId8x8 = EveryCompat.res((String)BlockTypeResTransformer.replaceTypeNoNamespace((String)(baseTexturePath + "_8x8"), (BlockType)w, (class_2960)id, (String)"oak"));
                        class_2960 newId10x10 = EveryCompat.res((String)BlockTypeResTransformer.replaceTypeNoNamespace((String)(baseTexturePath + "_10x10"), (BlockType)w, (class_2960)id, (String)"oak"));
                        class_2960 newId12x12 = EveryCompat.res((String)BlockTypeResTransformer.replaceTypeNoNamespace((String)(baseTexturePath + "_12x12"), (BlockType)w, (class_2960)id, (String)"oak"));
                        class_2960 newId14x14 = EveryCompat.res((String)BlockTypeResTransformer.replaceTypeNoNamespace((String)(baseTexturePath + "_14x14"), (BlockType)w, (class_2960)id, (String)"oak"));
                        class_2960[] newIds = new class_2960[]{newId2x2, newId4x4, newId6x6, newId8x8, newId10x10, newId12x12, newId14x14};
                        TextureImage newTop2x2 = topTexture.makeCopy();
                        TextureImage newTop4x4 = topTexture.makeCopy();
                        TextureImage newTop6x6 = topTexture.makeCopy();
                        TextureImage newTop8x8 = topTexture.makeCopy();
                        TextureImage newTop10x10 = topTexture.makeCopy();
                        TextureImage newTop12x12 = topTexture.makeCopy();
                        TextureImage newTop14x14 = topTexture.makeCopy();
                        TextureImage[] newTopTextures = new TextureImage[]{newTop2x2, newTop4x4, newTop6x6, newTop8x8, newTop10x10, newTop12x12, newTop14x14};
                        for (int i = 0; i < 7; ++i) {
                            TextureImage newTopTexture = newTopTextures[i];
                            this.generateBeamTexture(topTexture, newTopTexture, i);
                            sink.addTextureIfNotPresent(manager, newIds[i].toString(), () -> newTopTexture);
                        }
                    }
                    catch (Exception e) {
                        GuitaWoodworks.LOGGER.error("Failed to generate texture for {} : {}", block, (Object)e);
                    }
                });
            }
            catch (Exception e) {
                GuitaWoodworks.LOGGER.error("Failed to open the beam textures: ", (Throwable)e);
            }
            try {
                this.strippedBeam.blocks.forEach((w, block) -> {
                    class_2960 id = Utils.getID((class_2248)block);
                    String baseTexturePath = "block/stripped_oak_beam_top";
                    try (TextureImage topTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)w.getBlockOfThis("stripped_log"), (Predicate)CompatSpritesHelper.LOOKS_LIKE_TOP_LOG_TEXTURE));){
                        class_2960 newId2x2 = EveryCompat.res((String)BlockTypeResTransformer.replaceTypeNoNamespace((String)(baseTexturePath + "_2x2"), (BlockType)w, (class_2960)id, (String)"oak"));
                        class_2960 newId4x4 = EveryCompat.res((String)BlockTypeResTransformer.replaceTypeNoNamespace((String)(baseTexturePath + "_4x4"), (BlockType)w, (class_2960)id, (String)"oak"));
                        class_2960 newId6x6 = EveryCompat.res((String)BlockTypeResTransformer.replaceTypeNoNamespace((String)(baseTexturePath + "_6x6"), (BlockType)w, (class_2960)id, (String)"oak"));
                        class_2960 newId8x8 = EveryCompat.res((String)BlockTypeResTransformer.replaceTypeNoNamespace((String)(baseTexturePath + "_8x8"), (BlockType)w, (class_2960)id, (String)"oak"));
                        class_2960 newId10x10 = EveryCompat.res((String)BlockTypeResTransformer.replaceTypeNoNamespace((String)(baseTexturePath + "_10x10"), (BlockType)w, (class_2960)id, (String)"oak"));
                        class_2960 newId12x12 = EveryCompat.res((String)BlockTypeResTransformer.replaceTypeNoNamespace((String)(baseTexturePath + "_12x12"), (BlockType)w, (class_2960)id, (String)"oak"));
                        class_2960 newId14x14 = EveryCompat.res((String)BlockTypeResTransformer.replaceTypeNoNamespace((String)(baseTexturePath + "_14x14"), (BlockType)w, (class_2960)id, (String)"oak"));
                        class_2960[] newIds = new class_2960[]{newId2x2, newId4x4, newId6x6, newId8x8, newId10x10, newId12x12, newId14x14};
                        TextureImage newTop2x2 = topTexture.makeCopy();
                        TextureImage newTop4x4 = topTexture.makeCopy();
                        TextureImage newTop6x6 = topTexture.makeCopy();
                        TextureImage newTop8x8 = topTexture.makeCopy();
                        TextureImage newTop10x10 = topTexture.makeCopy();
                        TextureImage newTop12x12 = topTexture.makeCopy();
                        TextureImage newTop14x14 = topTexture.makeCopy();
                        TextureImage[] newTopTextures = new TextureImage[]{newTop2x2, newTop4x4, newTop6x6, newTop8x8, newTop10x10, newTop12x12, newTop14x14};
                        for (int i = 0; i < 7; ++i) {
                            TextureImage newTopTexture = newTopTextures[i];
                            this.generateBeamTexture(topTexture, newTopTexture, i);
                            sink.addTextureIfNotPresent(manager, newIds[i].toString(), () -> newTopTexture);
                        }
                    }
                    catch (Exception e) {
                        GuitaWoodworks.LOGGER.error("Failed to generate texture for {} : {}", block, (Object)e);
                    }
                });
            }
            catch (Exception e) {
                GuitaWoodworks.LOGGER.error("Failed to open the beam textures: ", (Throwable)e);
            }
        });
    }

    private void generateStumpTexture(TextureImage original, TextureImage target) {
        TextureCollager collager = TextureCollager.builder((int)16, (int)16, (int)16, (int)16).copyFrom(0, 0, 16, 1).to(0, 2, 16, 1).copyFrom(0, 15, 16, 1).to(0, 13, 16, 1).copyFrom(0, 0, 1, 16).to(2, 0, 1, 16).copyFrom(15, 0, 1, 16).to(13, 0, 1, 16).build();
        collager.apply(original, target);
        target.forEachPixel(pixel -> {
            if (pixel.frameX() < 2 || pixel.frameX() > 13 || pixel.frameY() < 2 || pixel.frameY() > 13) {
                pixel.setValue(0);
            }
        });
    }

    private TextureImage generateCarvedLogInsideTexture(TextureImage mainTexture, TextureImage logSideTexture, TextureImage planksTexture, TextureImage insideEdgeMask, TextureImage insideMask) {
        Respriter targetEdge = Respriter.masked((TextureImage)mainTexture, (TextureImage)insideMask);
        TextureImage recoloredEdge = targetEdge.recolorWithAnimationOf(logSideTexture);
        Respriter targetInside = Respriter.masked((TextureImage)recoloredEdge, (TextureImage)insideEdgeMask);
        return targetInside.recolorWithAnimationOf(planksTexture);
    }

    private void generateBeamTexture(TextureImage original, TextureImage target, int radius) {
        int boxSize = ++radius * 2;
        int offset = (16 - boxSize) / 2;
        TextureCollager collager = TextureCollager.builder((int)16, (int)16, (int)16, (int)16).copyFrom(0, 0, 16, 1).to(offset, offset, boxSize, 1).copyFrom(15, 0, 1, 16).to(offset + boxSize - 1, offset, 1, boxSize).copyFrom(0, 15, 16, 1).to(offset, offset + boxSize - 1, boxSize, 1).copyFrom(0, 0, 1, 16).to(offset, offset, 1, boxSize).build();
        collager.apply(original, target);
        target.forEachPixel(pixel -> {
            if (pixel.frameX() < offset || pixel.frameX() > offset + boxSize || pixel.frameY() < offset || pixel.frameY() > offset + boxSize) {
                pixel.setValue(0);
            }
        });
    }

    public boolean isEntryAlreadyRegistered(String entrySetId, String blockId, BlockType blockType, class_2378<?> registry) {
        WoodType wt;
        Boolean hardcoded;
        String blockName = blockId.substring(blockId.lastIndexOf("/") + 1);
        if (blockType instanceof WoodType && (hardcoded = CustomHardcodedBlockType.isWoodBlockAlreadyRegistered(entrySetId, blockName, wt = (WoodType)blockType, this.modId)) != null) {
            return hardcoded;
        }
        return super.isEntryAlreadyRegistered(entrySetId, blockId, blockType, registry);
    }

    public static class CustomHardcodedBlockType
    extends HardcodedBlockType {
        @Nullable
        public static Boolean isWoodBlockAlreadyRegistered(String entrySetId, String blockName, WoodType woodType, String ModId) {
            woodTypeFromMod = woodType.getNamespace();
            woodidentify = woodType.getId().toString();
            supportedMod = ModId;
            supportedBlockName = blockName;
            return null;
        }
    }
}

