/*
 * Copyright (c) 2025 macuguita.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package com.macuguita.woodworks.fabric.datagen;

import java.util.Locale;
import java.util.concurrent.CompletableFuture;

import com.macuguita.woodworks.reg.GWObjects;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class GWLangProvider extends FabricLanguageProvider {

	public GWLangProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
		super(dataOutput, "en_us", registryLookup);
	}

	@Override
	public void generateTranslations(class_7225.class_7874 wrapperLookup, TranslationBuilder translationBuilder) {
		generateItemTranslations(translationBuilder, GWObjects.SECATEURS.get());
		GWObjects.STUMP_BLOCKS.stream().forEach(regEntry -> {
			generateBlockTranslations(translationBuilder, regEntry.get());
		});
		GWObjects.STRIPPED_STUMP_BLOCKS.stream().forEach(regEntry -> {
			generateBlockTranslations(translationBuilder, regEntry.get());
		});
		GWObjects.CARVED_LOG_BLOCKS.stream().forEach(regEntry -> {
			generateBlockTranslations(translationBuilder, regEntry.get());
		});
		GWObjects.STRIPPED_CARVED_LOG_BLOCKS.stream().forEach(regEntry -> {
			generateBlockTranslations(translationBuilder, regEntry.get());
		});
		GWObjects.BEAM_BLOCKS.stream().forEach(regEntry -> {
			generateBlockTranslations(translationBuilder, regEntry.get());
		});
		GWObjects.STRIPPED_BEAM_BLOCKS.stream().forEach(regEntry -> {
			generateBlockTranslations(translationBuilder, regEntry.get());
		});
		GWObjects.HOLLOW_LOG_BLOCKS.stream().forEach(regEntry -> {
			generateBlockTranslations(translationBuilder, regEntry.get());
		});
		GWObjects.STRIPPED_HOLLOW_LOG_BLOCKS.stream().forEach(regEntry -> {
			generateBlockTranslations(translationBuilder, regEntry.get());
		});
		generateBlockTranslations(translationBuilder, GWObjects.MUSHROOM_STUMP.get());
		generateBlockTranslations(translationBuilder, GWObjects.CARVED_MUSHROOM_STEM.get());
		generateBlockTranslations(translationBuilder, GWObjects.MUSHROOM_BEAM.get());
		generateBlockTranslations(translationBuilder, GWObjects.HOLLOW_MUSHROOM_STEM.get());

		translationBuilder.add("block_type.gwoodworks.stump", "%s Stump");
		translationBuilder.add("block_type.gwoodworks.stripped_stump", "Stripped %s Stump");
		translationBuilder.add("block_type.gwoodworks.carved_log", "Carved %s Log");
		translationBuilder.add("block_type.gwoodworks.stripped_carved_log", "Stripped Carved %s Log");
		translationBuilder.add("block_type.gwoodworks.beam", "%s Beam");
		translationBuilder.add("block_type.gwoodworks.stripped_beam", "Stripped %s Beam");
		translationBuilder.add("block_type.gwoodworks.hollow_log", "Hollow %s Log");
		translationBuilder.add("block_type.gwoodworks.stripped_hollow_log", "Stripped Hollow %s Log");
		translationBuilder.add("itemGroup.gwoodworks.gwoodworks", "guita's Woodworks");
		translationBuilder.add("tag.item.gwoodworks.stump", "Stump");
		translationBuilder.add("tag.block.gwoodworks.stump", "Stump");
		translationBuilder.add("tag.item.gwoodworks.carved_log", "Carved Log");
		translationBuilder.add("tag.block.gwoodworks.carved_log", "Carved Log");
		translationBuilder.add("tag.item.gwoodworks.beam", "Beam");
		translationBuilder.add("tag.block.gwoodworks.beam", "Beam");
		translationBuilder.add("tag.item.gwoodworks.hollow_log", "Hollow Log");
		translationBuilder.add("tag.block.gwoodworks.hollow_log", "Hollow Log");
		translationBuilder.add("tag.item.gwoodworks.secateurs", "Secateurs");
		translationBuilder.add("tooltip.gwoodworks.beam_block", "Strip with axe, resize with shears, link with secateurs.");
	}

	private String capitalizeString(String string) {
		char[] chars = string.toLowerCase(Locale.getDefault()).toCharArray();
		boolean found = false;
		for (int i = 0; i < chars.length; ++i) {
			if (!found && Character.isLetter(chars[i])) {
				chars[i] = Character.toUpperCase(chars[i]);
				found = true;
			} else if (Character.isWhitespace(chars[i]) || chars[i] == '.' || chars[i] == '\'') {
				found = false;
			}
		}
		return new String(chars);
	}

	private void generateBlockTranslations(TranslationBuilder translationBuilder, class_2248 block) {
		String temp = capitalizeString(class_7923.field_41175.method_10221(block).method_12832().replace("_", " "));
		translationBuilder.add(block, temp);
	}

	private void generateItemTranslations(TranslationBuilder translationBuilder, class_1792 item) {
		String temp = capitalizeString(class_7923.field_41178.method_10221(item).method_12832().replace("_", " "));
		translationBuilder.add(item, temp);
	}
}
