/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.woodworks;

import com.macuguita.lib.platform.registry.GuitaRegistry;
import com.macuguita.lib.platform.registry.GuitaRegistryEntry;
import com.macuguita.woodworks.block.CarvedLogSeatBlock;
import com.macuguita.woodworks.block.HollowLogBlock;
import com.macuguita.woodworks.block.ResizableBeamBlock;
import com.macuguita.woodworks.block.StumpSeatBlock;
import com.macuguita.woodworks.compat.ModCompat;
import com.macuguita.woodworks.mixin.FireBlockAccessor;
import com.macuguita.woodworks.reg.GWEntityTypes;
import com.macuguita.woodworks.reg.GWItemGroups;
import com.macuguita.woodworks.reg.GWObjects;
import com.macuguita.woodworks.utils.GWUtils;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GuitaWoodworks {
    public static final String MOD_ID = "gwoodworks";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"gwoodworks");

    public static void init() {
        GWObjects.init();
        GWEntityTypes.init();
        GWItemGroups.init();
        GuitaWoodworks.everyCompatModule();
    }

    public static void commonSetup() {
        GuitaWoodworks.registerFuelAndRegisterStripped(GWObjects.STUMP_BLOCKS, GWObjects.STRIPPED_STUMP_BLOCKS, StumpSeatBlock.STRIPPED_STUMPS, 150);
        GuitaWoodworks.registerFuelAndRegisterStripped(GWObjects.CARVED_LOG_BLOCKS, GWObjects.STRIPPED_CARVED_LOG_BLOCKS, CarvedLogSeatBlock.STRIPPED_CARVED_LOGS, 250);
        GuitaWoodworks.registerFuelAndRegisterStripped(GWObjects.BEAM_BLOCKS, GWObjects.STRIPPED_BEAM_BLOCKS, ResizableBeamBlock.STRIPPED_BEAM_BLOCKS, 75);
        GuitaWoodworks.registerFuelAndRegisterStripped(GWObjects.HOLLOW_LOG_BLOCKS, GWObjects.STRIPPED_HOLLOW_LOG_BLOCKS, HollowLogBlock.STRIPPED_HOLLOW_LOGS, 150);
    }

    private static void registerFuelAndRegisterStripped(GuitaRegistry<class_2248> blockReg, GuitaRegistry<class_2248> strippedBlockReg, Map<class_2248, class_2248> strippedMap, int fuelTime) {
        int index = 0;
        for (GuitaRegistryEntry regEntry : blockReg.getEntries()) {
            class_2960 id = regEntry.getId();
            class_2248 block = (class_2248)regEntry.get();
            class_1792 item = block.method_8389();
            Optional optionalEntry = strippedBlockReg.stream().skip(index).findFirst();
            class_2248 strippedBlock = null;
            class_1792 strippedItem = null;
            if (optionalEntry.isPresent()) {
                strippedBlock = (class_2248)((GuitaRegistryEntry)optionalEntry.get()).get();
                strippedItem = strippedBlock.method_8389();
            }
            if (!id.method_12832().matches(".*(crimson|warped).*")) {
                GWUtils.registerFuel(fuelTime, (class_1935)item);
                ((FireBlockAccessor)class_2246.field_10036).gwoodworks$registerFlammableBlock(block, 5, 5);
                if (strippedItem != null) {
                    GWUtils.registerFuel(fuelTime, (class_1935)strippedItem);
                    ((FireBlockAccessor)class_2246.field_10036).gwoodworks$registerFlammableBlock(strippedBlock, 5, 5);
                }
            }
            if (strippedBlock != null) {
                strippedMap.put(block, strippedBlock);
            }
            ++index;
        }
    }

    private static void everyCompatModule() {
        try {
            if (GWUtils.isModLoaded("everycomp")) {
                ModCompat.init();
            } else {
                LOGGER.info("EveryCompat module is not loaded");
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to start EveryComp module", (Throwable)e);
        }
    }

    public static class_2960 id(String name) {
        return class_2960.method_60655((String)MOD_ID, (String)name);
    }
}

