/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.woodworks.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.macuguita.woodworks.reg.GWBlockTags;
import com.macuguita.woodworks.reg.GWItemTags;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

public class ResizableBeamBlock
extends class_2248
implements class_3737 {
    public static final Map<class_2248, class_2248> STRIPPED_BEAM_BLOCKS = new HashMap<class_2248, class_2248>();
    private static final class_2350[] FACINGS = class_2350.values();
    public static final class_2746 NORTH = class_2741.field_12489;
    public static final class_2746 EAST = class_2741.field_12487;
    public static final class_2746 SOUTH = class_2741.field_12540;
    public static final class_2746 WEST = class_2741.field_12527;
    public static final class_2746 UP = class_2741.field_12519;
    public static final class_2746 DOWN = class_2741.field_12546;
    public static final Map<class_2350, class_2746> FACING_PROPERTIES = ImmutableMap.copyOf((Map)((Map)class_156.method_654((Object)Maps.newEnumMap(class_2350.class), directions -> {
        directions.put(class_2350.field_11043, NORTH);
        directions.put(class_2350.field_11034, EAST);
        directions.put(class_2350.field_11035, SOUTH);
        directions.put(class_2350.field_11039, WEST);
        directions.put(class_2350.field_11036, UP);
        directions.put(class_2350.field_11033, DOWN);
    })));
    public static final class_2758 RADIUS = class_2758.method_11867((String)"radius", (int)1, (int)7);
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private final class_265[][] radiusToFacingsShape = this.generateRadiusToFacingsShapeMap();
    private final boolean strippable;

    public ResizableBeamBlock(class_4970.class_2251 settings) {
        this(settings, true);
    }

    public ResizableBeamBlock(class_4970.class_2251 settings, boolean strippable) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)RADIUS, (Comparable)Integer.valueOf(4))).method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)UP, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.strippable = strippable;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{RADIUS, NORTH, EAST, SOUTH, WEST, UP, DOWN, WATERLOGGED});
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        class_2680 rotated = state;
        for (class_2350 dir : class_2350.values()) {
            class_2350 newDir = rotation.method_10503(dir);
            rotated = (class_2680)rotated.method_11657((class_2769)FACING_PROPERTIES.get(newDir), (Comparable)((Boolean)state.method_11654((class_2769)FACING_PROPERTIES.get(dir))));
        }
        return rotated;
    }

    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        class_2470 rotation = mirror.method_10345(class_2350.field_11043);
        if (rotation != class_2470.field_11467) {
            return this.method_9598(state, rotation);
        }
        class_2680 mirrored = state;
        for (class_2350 dir : class_2350.values()) {
            class_2350 newDir = mirror.method_10343(dir);
            mirrored = (class_2680)mirrored.method_11657((class_2769)FACING_PROPERTIES.get(newDir), (Comparable)((Boolean)state.method_11654((class_2769)FACING_PROPERTIES.get(dir))));
        }
        return mirrored;
    }

    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            tickView.method_64312(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }
        return this.shouldConnectWithNeighbor(super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random), neighborState, direction);
    }

    private class_2680 shouldConnectWithNeighbor(class_2680 state, class_2680 neighborState, class_2350 dir) {
        if (!neighborState.method_26164(GWBlockTags.BEAM) || !(neighborState.method_26204() instanceof ResizableBeamBlock)) {
            return state;
        }
        if (((Boolean)neighborState.method_11654((class_2769)FACING_PROPERTIES.get(dir.method_10153()))).booleanValue()) {
            return (class_2680)state.method_11657((class_2769)FACING_PROPERTIES.get(dir), (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    private class_2680 shouldConnectWithNeighbors(class_2680 state, class_2338 pos, class_1937 world) {
        class_2680 temp = state;
        for (class_2350 direction : class_2350.values()) {
            temp = this.shouldConnectWithNeighbor(temp, world.method_8320(pos.method_10093(direction)), direction);
        }
        return temp;
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2350 side = ctx.method_8038();
        class_2680 state = (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING_PROPERTIES.get(side.method_10153()), (Comparable)Boolean.valueOf(true))).method_11657((class_2769)FACING_PROPERTIES.get(side), (Comparable)Boolean.valueOf(ctx.method_8036() != null && ctx.method_8036().method_5715()))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.method_8045().method_8316(ctx.method_8037()).method_39360((class_3611)class_3612.field_15910)));
        return this.shouldConnectWithNeighbors(state, ctx.method_8037(), ctx.method_8045());
    }

    private static Optional<class_2350> getDirectionByVec(class_243 hit, class_2338 pos, class_2680 state) {
        int radius = (Integer)state.method_11654((class_2769)RADIUS);
        class_243 relativePos = hit.method_1031((double)(-pos.method_10263()), (double)(-pos.method_10264()), (double)(-pos.method_10260())).method_1021(16.0);
        if (relativePos.field_1352 < (double)(8.0f - (float)radius)) {
            return Optional.of(class_2350.field_11039);
        }
        if (relativePos.field_1352 > (double)(8.0f + (float)radius)) {
            return Optional.of(class_2350.field_11034);
        }
        if (relativePos.field_1350 < (double)(8.0f - (float)radius)) {
            return Optional.of(class_2350.field_11043);
        }
        if (relativePos.field_1350 > (double)(8.0f + (float)radius)) {
            return Optional.of(class_2350.field_11035);
        }
        if (relativePos.field_1351 < (double)(8.0f - (float)radius)) {
            return Optional.of(class_2350.field_11033);
        }
        if (relativePos.field_1351 > (double)(8.0f + (float)radius)) {
            return Optional.of(class_2350.field_11036);
        }
        return Optional.empty();
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_2248 strippedBlock;
        class_1268 hand = player.method_6058();
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7909() instanceof class_1743 && this.strippable && (strippedBlock = STRIPPED_BEAM_BLOCKS.get((Object)this)) != null) {
            if (!player.method_31549().field_7477) {
                stack.method_71012(1, (class_1309)player, hand);
            }
            world.method_43128((class_1297)player, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_14675, class_3419.field_15245, 1.0f, 1.0f);
            class_2680 strippedState = (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)strippedBlock.method_9564().method_11657((class_2769)RADIUS, (Comparable)((Integer)state.method_11654((class_2769)RADIUS)))).method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)EAST)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)UP, (Comparable)((Boolean)state.method_11654((class_2769)UP)))).method_11657((class_2769)DOWN, (Comparable)((Boolean)state.method_11654((class_2769)DOWN)))).method_11657((class_2769)WATERLOGGED, (Comparable)((Boolean)state.method_11654((class_2769)WATERLOGGED)));
            world.method_8501(pos, strippedState);
            return class_1269.field_5812;
        }
        if (stack.method_31573(GWItemTags.SHEARS)) {
            if (!player.method_31549().field_7477) {
                stack.method_71012(1, (class_1309)player, hand);
            }
            world.method_43128((class_1297)player, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_20611, class_3419.field_15245, 1.0f, 1.0f);
            class_2680 newState = this.shiftRadius(state, 1);
            world.method_8501(pos, newState);
            return class_1269.field_5812;
        }
        if (stack.method_31573(GWItemTags.SECATEURS)) {
            Optional<class_2350> oDir = ResizableBeamBlock.getDirectionByVec(hit.method_17784(), pos, state);
            if (oDir.isPresent()) {
                class_2350 dir = oDir.get();
                class_2680 newState = (class_2680)state.method_11657((class_2769)FACING_PROPERTIES.get(dir), (Comparable)Boolean.valueOf(false));
                class_2338 neighborPos = pos.method_10093(dir);
                class_2680 neighborState = world.method_8320(neighborPos);
                world.method_8652(pos, newState, 3);
                if (neighborState.method_26204() instanceof ResizableBeamBlock && neighborState.method_26164(GWBlockTags.BEAM)) {
                    class_2680 newNeighborState = (class_2680)neighborState.method_11657((class_2769)FACING_PROPERTIES.get(dir.method_10153()), (Comparable)Boolean.valueOf(false));
                    world.method_8652(neighborPos, newNeighborState, 3);
                }
                if (!player.method_31549().field_7477) {
                    stack.method_71012(1, (class_1309)player, hand);
                }
                world.method_8396((class_1297)player, pos, class_3417.field_14619, class_3419.field_15245, 1.0f, 1.0f);
                return class_1269.field_5812;
            }
            class_2350 dir = hit.method_17780();
            class_2680 newState = (class_2680)state.method_11657((class_2769)FACING_PROPERTIES.get(dir), (Comparable)Boolean.valueOf(true));
            world.method_8501(pos, newState);
            if (!player.method_31549().field_7477) {
                stack.method_71012(1, (class_1309)player, hand);
            }
            world.method_8396((class_1297)player, pos, class_3417.field_14619, class_3419.field_15245, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        return super.method_55766(state, world, pos, player, hit);
    }

    private class_2680 shiftRadius(class_2680 state, int amount) {
        int radius = (Integer)state.method_11654((class_2769)RADIUS);
        int newRadius = radius + amount;
        if (newRadius > 7) {
            newRadius -= 7;
        } else if (newRadius < 1) {
            newRadius += 7;
        }
        return (class_2680)state.method_11657((class_2769)RADIUS, (Comparable)Integer.valueOf(newRadius));
    }

    private class_265[][] generateRadiusToFacingsShapeMap() {
        class_265[][] shapes = new class_265[8][];
        for (int radius = 1; radius <= 7; ++radius) {
            shapes[radius] = this.generateFacingsToShapeMap((float)radius / 16.0f);
        }
        return shapes;
    }

    private class_265[] generateFacingsToShapeMap(float radius) {
        float f = 0.5f - radius;
        float g = 0.5f + radius;
        class_265 centerShape = class_2248.method_9541((double)(f * 16.0f), (double)(f * 16.0f), (double)(f * 16.0f), (double)(g * 16.0f), (double)(g * 16.0f), (double)(g * 16.0f));
        class_265[] armShapes = new class_265[FACINGS.length];
        for (int i = 0; i < FACINGS.length; ++i) {
            class_2350 direction = FACINGS[i];
            armShapes[i] = class_259.method_1081((double)(0.5 + Math.min((double)(-radius), (double)direction.method_10148() * 0.5)), (double)(0.5 + Math.min((double)(-radius), (double)direction.method_10164() * 0.5)), (double)(0.5 + Math.min((double)(-radius), (double)direction.method_10165() * 0.5)), (double)(0.5 + Math.max((double)radius, (double)direction.method_10148() * 0.5)), (double)(0.5 + Math.max((double)radius, (double)direction.method_10164() * 0.5)), (double)(0.5 + Math.max((double)radius, (double)direction.method_10165() * 0.5)));
        }
        class_265[] facingShapes = new class_265[64];
        for (int mask = 0; mask < 64; ++mask) {
            class_265 shape = centerShape;
            for (int k = 0; k < FACINGS.length; ++k) {
                if ((mask & 1 << k) == 0) continue;
                shape = class_259.method_1084((class_265)shape, (class_265)armShapes[k]);
            }
            facingShapes[mask] = shape;
        }
        return facingShapes;
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        int radius = (Integer)state.method_11654((class_2769)RADIUS);
        int mask = this.getConnectionMask(state);
        return this.radiusToFacingsShape[radius][mask];
    }

    protected int getConnectionMask(class_2680 state) {
        int mask = 0;
        for (int i = 0; i < FACINGS.length; ++i) {
            if (!((Boolean)state.method_11654((class_2769)FACING_PROPERTIES.get(FACINGS[i]))).booleanValue()) continue;
            mask |= 1 << i;
        }
        return mask;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }
}

