/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.woodworks;

import com.macuguita.lib.platform.registry.GuitaRegistry;
import com.macuguita.lib.platform.registry.GuitaRegistryEntry;
import com.macuguita.woodworks.block.CarvedLogSeatBlock;
import com.macuguita.woodworks.block.HollowLogBlock;
import com.macuguita.woodworks.block.ResizableBeamBlock;
import com.macuguita.woodworks.block.StumpSeatBlock;
import com.macuguita.woodworks.mixin.FireBlockAccessor;
import com.macuguita.woodworks.reg.GWEntityTypes;
import com.macuguita.woodworks.reg.GWItemGroups;
import com.macuguita.woodworks.reg.GWObjects;
import com.macuguita.woodworks.utils.GWUtils;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GuitaWoodworks {
    public static final String MOD_ID = "gwoodworks";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"gwoodworks");

    public static void init() {
        GWObjects.init();
        GWEntityTypes.init();
        GWItemGroups.init();
    }

    public static void commonSetup() {
        GuitaWoodworks.registerFuelAndRegisterStripped(GWObjects.STUMP_BLOCKS, GWObjects.STRIPPED_STUMP_BLOCKS, StumpSeatBlock.STRIPPED_STUMPS, 150);
        GuitaWoodworks.registerFuelAndRegisterStripped(GWObjects.CARVED_LOG_BLOCKS, GWObjects.STRIPPED_CARVED_LOG_BLOCKS, CarvedLogSeatBlock.STRIPPED_CARVED_LOGS, 250);
        GuitaWoodworks.registerFuelAndRegisterStripped(GWObjects.BEAM_BLOCKS, GWObjects.STRIPPED_BEAM_BLOCKS, ResizableBeamBlock.STRIPPED_BEAM_BLOCKS, 75);
        GuitaWoodworks.registerFuelAndRegisterStripped(GWObjects.HOLLOW_LOG_BLOCKS, GWObjects.STRIPPED_HOLLOW_LOG_BLOCKS, HollowLogBlock.STRIPPED_HOLLOW_LOGS, 150);
    }

    private static void registerFuelAndRegisterStripped(GuitaRegistry<Block> blockReg, GuitaRegistry<Block> strippedBlockReg, Map<Block, Block> strippedMap, int fuelTime) {
        int index = 0;
        for (GuitaRegistryEntry regEntry : blockReg.getEntries()) {
            ResourceLocation id = regEntry.getId();
            Block block = (Block)regEntry.get();
            Item item = block.asItem();
            Optional optionalEntry = strippedBlockReg.stream().skip(index).findFirst();
            Block strippedBlock = null;
            Item strippedItem = null;
            if (optionalEntry.isPresent()) {
                strippedBlock = (Block)((GuitaRegistryEntry)optionalEntry.get()).get();
                strippedItem = strippedBlock.asItem();
            }
            if (!id.getPath().matches(".*(crimson|warped).*")) {
                GWUtils.registerFuel(fuelTime, (ItemLike)item);
                ((FireBlockAccessor)Blocks.FIRE).gwoodworks$registerFlammableBlock(block, 5, 5);
                if (strippedItem != null) {
                    GWUtils.registerFuel(fuelTime, (ItemLike)strippedItem);
                    ((FireBlockAccessor)Blocks.FIRE).gwoodworks$registerFlammableBlock(strippedBlock, 5, 5);
                }
            }
            if (strippedBlock != null) {
                strippedMap.put(block, strippedBlock);
            }
            ++index;
        }
    }

    public static ResourceLocation id(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }
}

