/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.woodworks.block;

import com.macuguita.woodworks.block.NoCornerModularSeatBlock;
import com.macuguita.woodworks.block.SittableBlock;
import com.macuguita.woodworks.block.property.NoCornerModularSeatProperty;
import com.macuguita.woodworks.reg.GWItemTags;
import com.macuguita.woodworks.utils.GWUtils;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CarvedLogSeatBlock
extends NoCornerModularSeatBlock
implements SittableBlock {
    public static final Map<Block, Block> STRIPPED_CARVED_LOGS = new HashMap<Block, Block>();
    public static final AABB SEAT = new AABB(0.125, 0.0, 0.125, 0.875, 0.5, 0.875);
    public static final MapCodec<CarvedLogSeatBlock> CODEC = CarvedLogSeatBlock.simpleCodec(CarvedLogSeatBlock::new);
    protected static final VoxelShape VOXEL_SHAPE = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Shapes.or((VoxelShape)CarvedLogSeatBlock.box((double)2.0, (double)8.0, (double)0.0, (double)14.0, (double)16.0, (double)11.0), (VoxelShape[])new VoxelShape[0]), (BooleanOp)BooleanOp.ONLY_FIRST);
    private final boolean strippable;

    public CarvedLogSeatBlock(BlockBehaviour.Properties settings) {
        this(settings, true);
    }

    public CarvedLogSeatBlock(BlockBehaviour.Properties settings, boolean strippable) {
        super(settings);
        this.strippable = strippable;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        Block strippedBlock;
        InteractionHand hand = player.getUsedItemHand();
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getItem() instanceof AxeItem && this.strippable && (strippedBlock = STRIPPED_CARVED_LOGS.get(this)) != null) {
            if (!player.getAbilities().instabuild) {
                stack.hurtAndBreak(1, (LivingEntity)player, hand);
            }
            world.playSound((Entity)player, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                BlockState strippedState = (BlockState)((BlockState)((BlockState)strippedBlock.defaultBlockState().setValue((Property)SHAPE, (Comparable)((Object)((NoCornerModularSeatProperty)((Object)state.getValue((Property)SHAPE)))))).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED)));
                serverWorld.setBlockAndUpdate(pos, strippedState);
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.is(GWItemTags.CARVED_LOG)) {
            return InteractionResult.FAIL;
        }
        if (stack.is(GWItemTags.WATER_BUCKETS) || stack.is(GWItemTags.EMPTY_BUCKETS)) {
            return InteractionResult.FAIL;
        }
        return super.useWithoutItem(state, world, pos, player, hit);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        VoxelShape shape = switch ((NoCornerModularSeatProperty)((Object)state.getValue((Property)SHAPE))) {
            default -> throw new MatchException(null, null);
            case NoCornerModularSeatProperty.SINGLE -> VOXEL_SHAPE;
            case NoCornerModularSeatProperty.LEFT -> Shapes.join((VoxelShape)VOXEL_SHAPE, (VoxelShape)Shapes.or((VoxelShape)CarvedLogSeatBlock.box((double)14.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)11.0), (VoxelShape[])new VoxelShape[0]), (BooleanOp)BooleanOp.ONLY_FIRST);
            case NoCornerModularSeatProperty.MIDDLE -> Shapes.join((VoxelShape)VOXEL_SHAPE, (VoxelShape)Shapes.or((VoxelShape)CarvedLogSeatBlock.box((double)14.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)11.0), (VoxelShape)CarvedLogSeatBlock.box((double)0.0, (double)8.0, (double)0.0, (double)2.0, (double)16.0, (double)11.0)), (BooleanOp)BooleanOp.ONLY_FIRST);
            case NoCornerModularSeatProperty.RIGHT -> Shapes.join((VoxelShape)VOXEL_SHAPE, (VoxelShape)Shapes.or((VoxelShape)CarvedLogSeatBlock.box((double)0.0, (double)8.0, (double)0.0, (double)2.0, (double)16.0, (double)11.0), (VoxelShape[])new VoxelShape[0]), (BooleanOp)BooleanOp.ONLY_FIRST);
        };
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN, Direction.UP -> Shapes.empty();
            case Direction.NORTH -> shape;
            case Direction.SOUTH -> GWUtils.rotateVoxelShape(shape, Direction.Axis.Y, 180);
            case Direction.WEST -> GWUtils.rotateVoxelShape(shape, Direction.Axis.Y, 270);
            case Direction.EAST -> GWUtils.rotateVoxelShape(shape, Direction.Axis.Y, 90);
        };
    }

    @Override
    public AABB getSeatSize(BlockState state) {
        return SEAT;
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

