/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.woodworks.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.macuguita.woodworks.reg.GWBlockTags;
import com.macuguita.woodworks.reg.GWItemTags;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ResizableBeamBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final Map<Block, Block> STRIPPED_BEAM_BLOCKS = new HashMap<Block, Block>();
    private static final Direction[] FACINGS = Direction.values();
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final BooleanProperty DOWN = BlockStateProperties.DOWN;
    public static final Map<Direction, BooleanProperty> FACING_PROPERTIES = ImmutableMap.copyOf((Map)((Map)Util.make((Object)Maps.newEnumMap(Direction.class), directions -> {
        directions.put(Direction.NORTH, NORTH);
        directions.put(Direction.EAST, EAST);
        directions.put(Direction.SOUTH, SOUTH);
        directions.put(Direction.WEST, WEST);
        directions.put(Direction.UP, UP);
        directions.put(Direction.DOWN, DOWN);
    })));
    public static final IntegerProperty RADIUS = IntegerProperty.create((String)"radius", (int)1, (int)7);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final VoxelShape[][] radiusToFacingsShape = this.generateRadiusToFacingsShapeMap();
    private final boolean strippable;

    public ResizableBeamBlock(BlockBehaviour.Properties settings) {
        this(settings, true);
    }

    public ResizableBeamBlock(BlockBehaviour.Properties settings, boolean strippable) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)RADIUS, (Comparable)Integer.valueOf(4))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.strippable = strippable;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{RADIUS, NORTH, EAST, SOUTH, WEST, UP, DOWN, WATERLOGGED});
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        BlockState rotated = state;
        for (Direction dir : Direction.values()) {
            Direction newDir = rotation.rotate(dir);
            rotated = (BlockState)rotated.setValue((Property)FACING_PROPERTIES.get(newDir), (Comparable)((Boolean)state.getValue((Property)FACING_PROPERTIES.get(dir))));
        }
        return rotated;
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        Rotation rotation = mirror.getRotation(Direction.NORTH);
        if (rotation != Rotation.NONE) {
            return this.rotate(state, rotation);
        }
        BlockState mirrored = state;
        for (Direction dir : Direction.values()) {
            Direction newDir = mirror.mirror(dir);
            mirrored = (BlockState)mirrored.setValue((Property)FACING_PROPERTIES.get(newDir), (Comparable)((Boolean)state.getValue((Property)FACING_PROPERTIES.get(dir))));
        }
        return mirrored;
    }

    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            tickView.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(world));
        }
        return this.shouldConnectWithNeighbor(super.updateShape(state, world, tickView, pos, direction, neighborPos, neighborState, random), neighborState, direction);
    }

    private BlockState shouldConnectWithNeighbor(BlockState state, BlockState neighborState, Direction dir) {
        if (!neighborState.is(GWBlockTags.BEAM) || !(neighborState.getBlock() instanceof ResizableBeamBlock)) {
            return state;
        }
        if (((Boolean)neighborState.getValue((Property)FACING_PROPERTIES.get(dir.getOpposite()))).booleanValue()) {
            return (BlockState)state.setValue((Property)FACING_PROPERTIES.get(dir), (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    private BlockState shouldConnectWithNeighbors(BlockState state, BlockPos pos, Level world) {
        BlockState temp = state;
        for (Direction direction : Direction.values()) {
            temp = this.shouldConnectWithNeighbor(temp, world.getBlockState(pos.relative(direction)), direction);
        }
        return temp;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction side = ctx.getClickedFace();
        BlockState state = (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING_PROPERTIES.get(side.getOpposite()), (Comparable)Boolean.valueOf(true))).setValue((Property)FACING_PROPERTIES.get(side), (Comparable)Boolean.valueOf(ctx.getPlayer() != null && ctx.getPlayer().isShiftKeyDown()))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.getLevel().getFluidState(ctx.getClickedPos()).is((Fluid)Fluids.WATER)));
        return this.shouldConnectWithNeighbors(state, ctx.getClickedPos(), ctx.getLevel());
    }

    private static Optional<Direction> getDirectionByVec(Vec3 hit, BlockPos pos, BlockState state) {
        int radius = (Integer)state.getValue((Property)RADIUS);
        Vec3 relativePos = hit.add((double)(-pos.getX()), (double)(-pos.getY()), (double)(-pos.getZ())).scale(16.0);
        if (relativePos.x < (double)(8.0f - (float)radius)) {
            return Optional.of(Direction.WEST);
        }
        if (relativePos.x > (double)(8.0f + (float)radius)) {
            return Optional.of(Direction.EAST);
        }
        if (relativePos.z < (double)(8.0f - (float)radius)) {
            return Optional.of(Direction.NORTH);
        }
        if (relativePos.z > (double)(8.0f + (float)radius)) {
            return Optional.of(Direction.SOUTH);
        }
        if (relativePos.y < (double)(8.0f - (float)radius)) {
            return Optional.of(Direction.DOWN);
        }
        if (relativePos.y > (double)(8.0f + (float)radius)) {
            return Optional.of(Direction.UP);
        }
        return Optional.empty();
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        Block strippedBlock;
        InteractionHand hand = player.getUsedItemHand();
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getItem() instanceof AxeItem && this.strippable && (strippedBlock = STRIPPED_BEAM_BLOCKS.get((Object)this)) != null) {
            if (!player.getAbilities().instabuild) {
                stack.hurtAndBreak(1, (LivingEntity)player, hand);
            }
            world.playSound((Entity)player, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            BlockState strippedState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)strippedBlock.defaultBlockState().setValue((Property)RADIUS, (Comparable)((Integer)state.getValue((Property)RADIUS)))).setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)UP, (Comparable)((Boolean)state.getValue((Property)UP)))).setValue((Property)DOWN, (Comparable)((Boolean)state.getValue((Property)DOWN)))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED)));
            world.setBlockAndUpdate(pos, strippedState);
            return InteractionResult.SUCCESS;
        }
        if (stack.is(GWItemTags.SHEARS)) {
            if (!player.getAbilities().instabuild) {
                stack.hurtAndBreak(1, (LivingEntity)player, hand);
            }
            world.playSound((Entity)player, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.BEEHIVE_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
            BlockState newState = this.shiftRadius(state, 1);
            world.setBlockAndUpdate(pos, newState);
            return InteractionResult.SUCCESS;
        }
        if (stack.is(GWItemTags.SECATEURS)) {
            Optional<Direction> oDir = ResizableBeamBlock.getDirectionByVec(hit.getLocation(), pos, state);
            if (oDir.isPresent()) {
                Direction dir = oDir.get();
                BlockState newState = (BlockState)state.setValue((Property)FACING_PROPERTIES.get(dir), (Comparable)Boolean.valueOf(false));
                BlockPos neighborPos = pos.relative(dir);
                BlockState neighborState = world.getBlockState(neighborPos);
                world.setBlock(pos, newState, 3);
                if (neighborState.getBlock() instanceof ResizableBeamBlock && neighborState.is(GWBlockTags.BEAM)) {
                    BlockState newNeighborState = (BlockState)neighborState.setValue((Property)FACING_PROPERTIES.get(dir.getOpposite()), (Comparable)Boolean.valueOf(false));
                    world.setBlock(neighborPos, newNeighborState, 3);
                }
                if (!player.getAbilities().instabuild) {
                    stack.hurtAndBreak(1, (LivingEntity)player, hand);
                }
                world.playSound((Entity)player, pos, SoundEvents.PUMPKIN_CARVE, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            Direction dir = hit.getDirection();
            BlockState newState = (BlockState)state.setValue((Property)FACING_PROPERTIES.get(dir), (Comparable)Boolean.valueOf(true));
            world.setBlockAndUpdate(pos, newState);
            if (!player.getAbilities().instabuild) {
                stack.hurtAndBreak(1, (LivingEntity)player, hand);
            }
            world.playSound((Entity)player, pos, SoundEvents.PUMPKIN_CARVE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, world, pos, player, hit);
    }

    private BlockState shiftRadius(BlockState state, int amount) {
        int radius = (Integer)state.getValue((Property)RADIUS);
        int newRadius = radius + amount;
        if (newRadius > 7) {
            newRadius -= 7;
        } else if (newRadius < 1) {
            newRadius += 7;
        }
        return (BlockState)state.setValue((Property)RADIUS, (Comparable)Integer.valueOf(newRadius));
    }

    private VoxelShape[][] generateRadiusToFacingsShapeMap() {
        VoxelShape[][] shapes = new VoxelShape[8][];
        for (int radius = 1; radius <= 7; ++radius) {
            shapes[radius] = this.generateFacingsToShapeMap((float)radius / 16.0f);
        }
        return shapes;
    }

    private VoxelShape[] generateFacingsToShapeMap(float radius) {
        float f = 0.5f - radius;
        float g = 0.5f + radius;
        VoxelShape centerShape = Block.box((double)(f * 16.0f), (double)(f * 16.0f), (double)(f * 16.0f), (double)(g * 16.0f), (double)(g * 16.0f), (double)(g * 16.0f));
        VoxelShape[] armShapes = new VoxelShape[FACINGS.length];
        for (int i = 0; i < FACINGS.length; ++i) {
            Direction direction = FACINGS[i];
            armShapes[i] = Shapes.box((double)(0.5 + Math.min((double)(-radius), (double)direction.getStepX() * 0.5)), (double)(0.5 + Math.min((double)(-radius), (double)direction.getStepY() * 0.5)), (double)(0.5 + Math.min((double)(-radius), (double)direction.getStepZ() * 0.5)), (double)(0.5 + Math.max((double)radius, (double)direction.getStepX() * 0.5)), (double)(0.5 + Math.max((double)radius, (double)direction.getStepY() * 0.5)), (double)(0.5 + Math.max((double)radius, (double)direction.getStepZ() * 0.5)));
        }
        VoxelShape[] facingShapes = new VoxelShape[64];
        for (int mask = 0; mask < 64; ++mask) {
            VoxelShape shape = centerShape;
            for (int k = 0; k < FACINGS.length; ++k) {
                if ((mask & 1 << k) == 0) continue;
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)armShapes[k]);
            }
            facingShapes[mask] = shape;
        }
        return facingShapes;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        int radius = (Integer)state.getValue((Property)RADIUS);
        int mask = this.getConnectionMask(state);
        return this.radiusToFacingsShape[radius][mask];
    }

    protected int getConnectionMask(BlockState state) {
        int mask = 0;
        for (int i = 0; i < FACINGS.length; ++i) {
            if (!((Boolean)state.getValue((Property)FACING_PROPERTIES.get(FACINGS[i]))).booleanValue()) continue;
            mask |= 1 << i;
        }
        return mask;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }
}

