/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.woodworks.block;

import com.macuguita.woodworks.block.NoCornerModularSeatBlock;
import com.macuguita.woodworks.block.SittableBlock;
import com.macuguita.woodworks.block.property.NoCornerModularSeatProperty;
import com.macuguita.woodworks.reg.GWItemTags;
import com.macuguita.woodworks.utils.GWUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CarvedLogSeatBlock
extends NoCornerModularSeatBlock
implements SittableBlock {
    public static final Map<Block, Block> STRIPPED_CARVED_LOGS = new HashMap<Block, Block>();
    public static final AABB SEAT = new AABB(0.125, 0.0, 0.125, 0.875, 0.5, 0.875);
    protected static final VoxelShape VOXEL_SHAPE = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Shapes.m_83124_((VoxelShape)CarvedLogSeatBlock.m_49796_((double)2.0, (double)8.0, (double)0.0, (double)14.0, (double)16.0, (double)11.0), (VoxelShape[])new VoxelShape[0]), (BooleanOp)BooleanOp.f_82685_);
    private final boolean strippable;

    public CarvedLogSeatBlock(BlockBehaviour.Properties settings) {
        this(settings, true);
    }

    public CarvedLogSeatBlock(BlockBehaviour.Properties settings, boolean strippable) {
        super(settings);
        this.strippable = strippable;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Block strippedBlock;
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof AxeItem && this.strippable && (strippedBlock = STRIPPED_CARVED_LOGS.get(this)) != null) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            world.m_6263_(player, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                BlockState strippedState = (BlockState)((BlockState)((BlockState)strippedBlock.m_49966_().m_61124_((Property)SHAPE, (Comparable)((Object)((NoCornerModularSeatProperty)((Object)state.m_61143_((Property)SHAPE)))))).m_61124_((Property)f_54117_, (Comparable)((Direction)state.m_61143_((Property)f_54117_)))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)WATERLOGGED)));
                serverWorld.m_46597_(pos, strippedState);
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.m_204117_(GWItemTags.WATER_BUCKETS) || stack.m_204117_(GWItemTags.EMPTY_BUCKETS)) {
            return InteractionResult.FAIL;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        VoxelShape shape = switch ((NoCornerModularSeatProperty)((Object)state.m_61143_((Property)SHAPE))) {
            default -> throw new IncompatibleClassChangeError();
            case NoCornerModularSeatProperty.SINGLE -> VOXEL_SHAPE;
            case NoCornerModularSeatProperty.LEFT -> Shapes.m_83113_((VoxelShape)VOXEL_SHAPE, (VoxelShape)Shapes.m_83124_((VoxelShape)CarvedLogSeatBlock.m_49796_((double)14.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)11.0), (VoxelShape[])new VoxelShape[0]), (BooleanOp)BooleanOp.f_82685_);
            case NoCornerModularSeatProperty.MIDDLE -> Shapes.m_83113_((VoxelShape)VOXEL_SHAPE, (VoxelShape)Shapes.m_83110_((VoxelShape)CarvedLogSeatBlock.m_49796_((double)14.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)11.0), (VoxelShape)CarvedLogSeatBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)2.0, (double)16.0, (double)11.0)), (BooleanOp)BooleanOp.f_82685_);
            case NoCornerModularSeatProperty.RIGHT -> Shapes.m_83113_((VoxelShape)VOXEL_SHAPE, (VoxelShape)Shapes.m_83124_((VoxelShape)CarvedLogSeatBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)2.0, (double)16.0, (double)11.0), (VoxelShape[])new VoxelShape[0]), (BooleanOp)BooleanOp.f_82685_);
        };
        return switch ((Direction)state.m_61143_((Property)f_54117_)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN, Direction.UP -> Shapes.m_83040_();
            case Direction.NORTH -> shape;
            case Direction.SOUTH -> GWUtils.rotateVoxelShape(shape, Direction.Axis.Y, 180);
            case Direction.WEST -> GWUtils.rotateVoxelShape(shape, Direction.Axis.Y, 270);
            case Direction.EAST -> GWUtils.rotateVoxelShape(shape, Direction.Axis.Y, 90);
        };
    }

    @Override
    public AABB getSeatSize(BlockState state) {
        return SEAT;
    }
}

