/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.woodworks.block;

import com.macuguita.woodworks.block.SittableBlock;
import com.macuguita.woodworks.block.property.NoCornerModularSeatProperty;
import com.macuguita.woodworks.reg.GWBlockTags;
import com.macuguita.woodworks.reg.GWItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public abstract class NoCornerModularSeatBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock,
SittableBlock {
    public static final EnumProperty<NoCornerModularSeatProperty> SHAPE = EnumProperty.m_61587_((String)"shape", NoCornerModularSeatProperty.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    protected NoCornerModularSeatBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(SHAPE, (Comparable)((Object)NoCornerModularSeatProperty.SINGLE))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SHAPE, f_54117_, WATERLOGGED});
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        NoCornerModularSeatProperty couchShape = (NoCornerModularSeatProperty)((Object)state.m_61143_(SHAPE));
        switch (mirror) {
            case LEFT_RIGHT: {
                if (direction.m_122434_() != Direction.Axis.Z) break;
                return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)((Object)couchShape));
            }
            case FRONT_BACK: {
                if (direction.m_122434_() != Direction.Axis.X) break;
                return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)((Object)couchShape));
            }
        }
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)f_54117_)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_204117_(GWItemTags.WATER_BUCKETS)) {
            return InteractionResult.FAIL;
        }
        if (stack.m_204117_(GWItemTags.CARVED_LOG)) {
            return InteractionResult.FAIL;
        }
        return this.sitOn(world, pos, player, (Direction)state.m_61143_((Property)f_54117_)) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return direction.m_122434_().m_122479_() ? (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)this.getShape(state, world, pos))) : super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos pos = ctx.m_8083_();
        Direction dir = ctx.m_8125_().m_122424_();
        BlockState state = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)dir)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.m_43725_().m_6425_(ctx.m_8083_()).m_192917_((Fluid)Fluids.f_76193_)));
        return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)this.getShape(state, (LevelAccessor)ctx.m_43725_(), pos)));
    }

    private NoCornerModularSeatProperty getShape(BlockState state, LevelAccessor world, BlockPos pos) {
        boolean hasRight;
        Direction dir = (Direction)state.m_61143_((Property)f_54117_);
        Direction left = dir.m_175364_(Direction.Axis.Y);
        Direction right = dir.m_175362_(Direction.Axis.Y);
        boolean hasLeft = world.m_8055_(pos.m_121945_(left)).m_204336_(GWBlockTags.CARVED_LOG) && world.m_8055_(pos.m_121945_(left)).m_61143_((Property)f_54117_) == dir;
        boolean bl = hasRight = world.m_8055_(pos.m_121945_(right)).m_204336_(GWBlockTags.CARVED_LOG) && world.m_8055_(pos.m_121945_(right)).m_61143_((Property)f_54117_) == dir;
        if (hasLeft && hasRight) {
            return NoCornerModularSeatProperty.MIDDLE;
        }
        if (hasLeft) {
            return NoCornerModularSeatProperty.RIGHT;
        }
        if (hasRight) {
            return NoCornerModularSeatProperty.LEFT;
        }
        return NoCornerModularSeatProperty.SINGLE;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }
}

