/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.woodworks.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.macuguita.woodworks.reg.GWBlockTags;
import com.macuguita.woodworks.reg.GWItemTags;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ResizableBeamBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final Map<Block, Block> STRIPPED_BEAM_BLOCKS = new HashMap<Block, Block>();
    private static final Direction[] FACINGS = Direction.values();
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static final Map<Direction, BooleanProperty> FACING_PROPERTIES = ImmutableMap.copyOf((Map)((Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), directions -> {
        directions.put(Direction.NORTH, NORTH);
        directions.put(Direction.EAST, EAST);
        directions.put(Direction.SOUTH, SOUTH);
        directions.put(Direction.WEST, WEST);
        directions.put(Direction.UP, UP);
        directions.put(Direction.DOWN, DOWN);
    })));
    public static final IntegerProperty RADIUS = IntegerProperty.m_61631_((String)"radius", (int)1, (int)7);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final VoxelShape[][] radiusToFacingsShape = this.generateRadiusToFacingsShapeMap();
    private final boolean strippable;

    public ResizableBeamBlock(BlockBehaviour.Properties settings) {
        this(settings, true);
    }

    public ResizableBeamBlock(BlockBehaviour.Properties settings, boolean strippable) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)RADIUS, (Comparable)Integer.valueOf(4))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.strippable = strippable;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{RADIUS, NORTH, EAST, SOUTH, WEST, UP, DOWN, WATERLOGGED});
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag options) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gwoodworks.beam_block").m_130940_(ChatFormatting.DARK_GRAY));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        BlockState rotated = state;
        for (Direction dir : Direction.values()) {
            Direction newDir = rotation.m_55954_(dir);
            rotated = (BlockState)rotated.m_61124_((Property)FACING_PROPERTIES.get(newDir), (Comparable)((Boolean)state.m_61143_((Property)FACING_PROPERTIES.get(dir))));
        }
        return rotated;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Rotation rotation = mirror.m_54846_(Direction.NORTH);
        if (rotation != Rotation.NONE) {
            return this.m_6843_(state, rotation);
        }
        BlockState mirrored = state;
        for (Direction dir : Direction.values()) {
            Direction newDir = mirror.m_54848_(dir);
            mirrored = (BlockState)mirrored.m_61124_((Property)FACING_PROPERTIES.get(newDir), (Comparable)((Boolean)state.m_61143_((Property)FACING_PROPERTIES.get(dir))));
        }
        return mirrored;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return this.shouldConnectWithNeighbor(super.m_7417_(state, direction, neighborState, world, pos, neighborPos), neighborState, direction);
    }

    private BlockState shouldConnectWithNeighbor(BlockState state, BlockState neighborState, Direction dir) {
        if (!neighborState.m_204336_(GWBlockTags.BEAM) || !(neighborState.m_60734_() instanceof ResizableBeamBlock)) {
            return state;
        }
        if (((Boolean)neighborState.m_61143_((Property)FACING_PROPERTIES.get(dir.m_122424_()))).booleanValue()) {
            return (BlockState)state.m_61124_((Property)FACING_PROPERTIES.get(dir), (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    private BlockState shouldConnectWithNeighbors(BlockState state, BlockPos pos, Level world) {
        BlockState temp = state;
        for (Direction direction : Direction.values()) {
            temp = this.shouldConnectWithNeighbor(temp, world.m_8055_(pos.m_121945_(direction)), direction);
        }
        return temp;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction side = ctx.m_43719_();
        BlockState state = (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING_PROPERTIES.get(side.m_122424_()), (Comparable)Boolean.valueOf(true))).m_61124_((Property)FACING_PROPERTIES.get(side), (Comparable)Boolean.valueOf(ctx.m_43723_() != null && ctx.m_43723_().m_6144_()))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.m_43725_().m_6425_(ctx.m_8083_()).m_192917_((Fluid)Fluids.f_76193_)));
        return this.shouldConnectWithNeighbors(state, ctx.m_8083_(), ctx.m_43725_());
    }

    private static Optional<Direction> getDirectionByVec(Vec3 hit, BlockPos pos, BlockState state) {
        int radius = (Integer)state.m_61143_((Property)RADIUS);
        Vec3 relativePos = hit.m_82520_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_())).m_82490_(16.0);
        if (relativePos.f_82479_ < (double)(8.0f - (float)radius)) {
            return Optional.of(Direction.WEST);
        }
        if (relativePos.f_82479_ > (double)(8.0f + (float)radius)) {
            return Optional.of(Direction.EAST);
        }
        if (relativePos.f_82481_ < (double)(8.0f - (float)radius)) {
            return Optional.of(Direction.NORTH);
        }
        if (relativePos.f_82481_ > (double)(8.0f + (float)radius)) {
            return Optional.of(Direction.SOUTH);
        }
        if (relativePos.f_82480_ < (double)(8.0f - (float)radius)) {
            return Optional.of(Direction.DOWN);
        }
        if (relativePos.f_82480_ > (double)(8.0f + (float)radius)) {
            return Optional.of(Direction.UP);
        }
        return Optional.empty();
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Block strippedBlock;
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof AxeItem && this.strippable && (strippedBlock = STRIPPED_BEAM_BLOCKS.get((Object)this)) != null) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            world.m_6263_(player, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            BlockState strippedState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)strippedBlock.m_49966_().m_61124_((Property)RADIUS, (Comparable)((Integer)state.m_61143_((Property)RADIUS)))).m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)UP, (Comparable)((Boolean)state.m_61143_((Property)UP)))).m_61124_((Property)DOWN, (Comparable)((Boolean)state.m_61143_((Property)DOWN)))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)WATERLOGGED)));
            world.m_46597_(pos, strippedState);
            return InteractionResult.SUCCESS;
        }
        if (stack.m_204117_(GWItemTags.SHEARS)) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            world.m_6263_(player, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11697_, SoundSource.BLOCKS, 1.0f, 1.0f);
            BlockState newState = this.shiftRadius(state, 1);
            world.m_46597_(pos, newState);
            return InteractionResult.SUCCESS;
        }
        if (stack.m_204117_(GWItemTags.SECATEURS)) {
            Optional<Direction> oDir = ResizableBeamBlock.getDirectionByVec(hit.m_82450_(), pos, state);
            if (oDir.isPresent()) {
                Direction dir = oDir.get();
                BlockState newState = (BlockState)state.m_61124_((Property)FACING_PROPERTIES.get(dir), (Comparable)Boolean.valueOf(false));
                BlockPos neighborPos = pos.m_121945_(dir);
                BlockState neighborState = world.m_8055_(neighborPos);
                world.m_7731_(pos, newState, 3);
                if (neighborState.m_60734_() instanceof ResizableBeamBlock && neighborState.m_204336_(GWBlockTags.BEAM)) {
                    BlockState newNeighborState = (BlockState)neighborState.m_61124_((Property)FACING_PROPERTIES.get(dir.m_122424_()), (Comparable)Boolean.valueOf(false));
                    world.m_7731_(neighborPos, newNeighborState, 3);
                }
                if (!player.m_150110_().f_35937_) {
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                }
                world.m_5594_(player, pos, SoundEvents.f_12296_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            Direction dir = hit.m_82434_();
            BlockState newState = (BlockState)state.m_61124_((Property)FACING_PROPERTIES.get(dir), (Comparable)Boolean.valueOf(true));
            world.m_46597_(pos, newState);
            if (!player.m_150110_().f_35937_) {
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            world.m_5594_(player, pos, SoundEvents.f_12296_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    private BlockState shiftRadius(BlockState state, int amount) {
        int radius = (Integer)state.m_61143_((Property)RADIUS);
        int newRadius = radius + amount;
        if (newRadius > 7) {
            newRadius -= 7;
        } else if (newRadius < 1) {
            newRadius += 7;
        }
        return (BlockState)state.m_61124_((Property)RADIUS, (Comparable)Integer.valueOf(newRadius));
    }

    private VoxelShape[][] generateRadiusToFacingsShapeMap() {
        VoxelShape[][] shapes = new VoxelShape[8][];
        for (int radius = 1; radius <= 7; ++radius) {
            shapes[radius] = this.generateFacingsToShapeMap((float)radius / 16.0f);
        }
        return shapes;
    }

    private VoxelShape[] generateFacingsToShapeMap(float radius) {
        float f = 0.5f - radius;
        float g = 0.5f + radius;
        VoxelShape centerShape = Block.m_49796_((double)(f * 16.0f), (double)(f * 16.0f), (double)(f * 16.0f), (double)(g * 16.0f), (double)(g * 16.0f), (double)(g * 16.0f));
        VoxelShape[] armShapes = new VoxelShape[FACINGS.length];
        for (int i = 0; i < FACINGS.length; ++i) {
            Direction direction = FACINGS[i];
            armShapes[i] = Shapes.m_83048_((double)(0.5 + Math.min((double)(-radius), (double)direction.m_122429_() * 0.5)), (double)(0.5 + Math.min((double)(-radius), (double)direction.m_122430_() * 0.5)), (double)(0.5 + Math.min((double)(-radius), (double)direction.m_122431_() * 0.5)), (double)(0.5 + Math.max((double)radius, (double)direction.m_122429_() * 0.5)), (double)(0.5 + Math.max((double)radius, (double)direction.m_122430_() * 0.5)), (double)(0.5 + Math.max((double)radius, (double)direction.m_122431_() * 0.5)));
        }
        VoxelShape[] facingShapes = new VoxelShape[64];
        for (int mask = 0; mask < 64; ++mask) {
            VoxelShape shape = centerShape;
            for (int k = 0; k < FACINGS.length; ++k) {
                if ((mask & 1 << k) == 0) continue;
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)armShapes[k]);
            }
            facingShapes[mask] = shape;
        }
        return facingShapes;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        int radius = (Integer)state.m_61143_((Property)RADIUS);
        int mask = this.getConnectionMask(state);
        return this.radiusToFacingsShape[radius][mask];
    }

    protected int getConnectionMask(BlockState state) {
        int mask = 0;
        for (int i = 0; i < FACINGS.length; ++i) {
            if (!((Boolean)state.m_61143_((Property)FACING_PROPERTIES.get(FACINGS[i]))).booleanValue()) continue;
            mask |= 1 << i;
        }
        return mask;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }
}

