/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.woodworks.entity;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.macuguita.woodworks.block.SittableBlock;
import com.macuguita.woodworks.reg.GWEntityTypes;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
public class Seat
extends Entity {
    public static final Multimap<ResourceKey<Level>, BlockPos> SITTING_POSITIONS = ArrayListMultimap.create();
    private AABB shape;
    private boolean remove;
    private boolean canRotate;

    public Seat(EntityType<? extends Entity> type, Level world) {
        super(type, world);
        this.m_141960_(EntityInLevelCallback.f_156799_);
    }

    public Seat(Level world, AABB shape) {
        super((EntityType)GWEntityTypes.SEAT.get(), world);
        this.shape = Seat.copyBox(shape);
    }

    public static Seat of(Level world, BlockPos pos, Direction dir) {
        BlockState state = world.m_8055_(pos);
        AABB shape = new AABB(pos);
        Block block = state.m_60734_();
        if (block instanceof SittableBlock) {
            SittableBlock seat = (SittableBlock)block;
            shape = seat.getSeatSize(state);
        }
        Seat entity = new Seat(world, shape);
        if (dir != null) {
            entity.m_146922_(dir.m_122435_());
        } else {
            entity.canRotate = true;
        }
        entity.m_20343_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        return entity;
    }

    private static AABB copyBox(AABB box) {
        return new AABB(box.f_82288_, box.f_82289_, box.f_82290_, box.f_82291_, box.f_82292_, box.f_82293_);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, this.canRotate ? 1 : 0);
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        this.canRotate = packet.m_131509_() == 1;
    }

    public boolean m_20147_() {
        return true;
    }

    public boolean m_20160_() {
        return true;
    }

    public boolean m_6000_(double x, double y, double z) {
        return false;
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        Direction facing = this.m_6350_();
        BlockPos seatPos = this.m_20183_();
        Vec3 seatCenter = this.m_20182_();
        for (Direction offset : new Direction[]{facing, facing.m_122427_(), facing.m_122428_(), facing.m_122424_()}) {
            BlockPos targetPos = seatPos.m_121945_(offset);
            Vec3 dismountPos = DismountHelper.m_38441_((EntityType)passenger.m_6095_(), (CollisionGetter)this.m_9236_(), (BlockPos)targetPos, (boolean)false);
            if (dismountPos == null) continue;
            double distance = dismountPos.m_82557_(seatCenter);
            if (distance > 9.0) {
                return seatCenter.m_82520_(0.0, 1.0, 0.0);
            }
            return new Vec3(dismountPos.f_82479_, dismountPos.f_82480_ + (double)passenger.m_20206_() * 0.5 + 0.1, dismountPos.f_82481_);
        }
        return this.m_20182_().m_82520_(0.0, 1.0, 0.0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!(this.m_9236_().m_5776_() || this.m_9236_().m_8055_(this.m_20183_()).m_60734_() instanceof SittableBlock && !this.remove)) {
            this.removeSeat();
        }
    }

    protected void m_20351_(Entity passenger) {
        super.m_20351_(passenger);
        if (!this.m_9236_().m_5776_() && this.m_20197_().isEmpty()) {
            this.remove = true;
        }
    }

    public void removeSeat() {
        SITTING_POSITIONS.get((Object)this.m_9236_().m_46472_()).remove(this.m_20183_());
        this.m_146870_();
    }

    protected AABB m_142242_() {
        return this.shape == null ? super.m_142242_() : this.shape.m_82338_(this.m_20183_());
    }

    public double m_6048_() {
        if (this.shape == null) {
            return super.m_6048_();
        }
        return this.shape.m_82376_() * 0.75;
    }

    protected void clampRotation(Entity entity) {
        entity.m_5618_(this.m_146908_());
        float diff = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
        float clamped = Mth.m_14036_((float)diff, (float)-105.0f, (float)105.0f);
        entity.f_19859_ += clamped - diff;
        entity.m_146922_(entity.m_146908_() + clamped - diff);
        entity.m_5616_(entity.m_146908_());
    }

    public void m_7340_(Entity entity) {
        if (!this.canRotate) {
            this.clampRotation(entity);
        }
    }

    public void m_141960_(EntityInLevelCallback callback) {
        super.m_141960_((EntityInLevelCallback)new WrappedCallback(callback));
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag tag) {
    }

    protected void m_7380_(CompoundTag tag) {
    }

    private class WrappedCallback
    implements EntityInLevelCallback {
        private final EntityInLevelCallback delegate;

        public WrappedCallback(EntityInLevelCallback delegate) {
            this.delegate = delegate;
        }

        public void m_142044_() {
            if (this.delegate != null) {
                this.delegate.m_142044_();
                Block block = Seat.this.m_9236_().m_8055_(Seat.this.m_20183_()).m_60734_();
                if (block instanceof SittableBlock) {
                    SittableBlock seat = (SittableBlock)block;
                    Seat.this.shape = seat.getSeatSize(Seat.this.m_9236_().m_8055_(Seat.this.m_20183_()));
                }
            } else {
                Seat.this.shape = null;
            }
        }

        public void m_142472_(Entity.RemovalReason reason) {
            if (this.delegate != null) {
                this.delegate.m_142472_(reason);
            }
        }
    }
}

