/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.woodworks.reg;

import com.macuguita.lib.platform.registry.GuitaRegistries;
import com.macuguita.lib.platform.registry.GuitaRegistry;
import com.macuguita.lib.platform.registry.GuitaRegistryEntry;
import com.macuguita.woodworks.block.CarvedLogSeatBlock;
import com.macuguita.woodworks.block.HollowLogBlock;
import com.macuguita.woodworks.block.ResizableBeamBlock;
import com.macuguita.woodworks.block.StumpSeatBlock;
import com.macuguita.woodworks.utils.GWUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class GWObjects {
    public static final Map<Block, Block> WOOD_ASSOCIATIONS = new HashMap<Block, Block>();
    public static final GuitaRegistry<Block> BLOCKS = GuitaRegistries.create((Registry)BuiltInRegistries.f_256975_, (String)"gwoodworks");
    public static final GuitaRegistry<Item> ITEMS = GuitaRegistries.create((Registry)BuiltInRegistries.f_257033_, (String)"gwoodworks");
    public static final GuitaRegistry<Block> STUMP_BLOCKS = GuitaRegistries.create(BLOCKS);
    public static final GuitaRegistry<Block> STRIPPED_STUMP_BLOCKS = GuitaRegistries.create(BLOCKS);
    public static final GuitaRegistry<Item> STUMP_ITEMS = GuitaRegistries.create(ITEMS);
    public static final GuitaRegistry<Item> STRIPPED_STUMP_ITEMS = GuitaRegistries.create(ITEMS);
    public static final GuitaRegistry<Block> CARVED_LOG_BLOCKS = GuitaRegistries.create(BLOCKS);
    public static final GuitaRegistry<Block> STRIPPED_CARVED_LOG_BLOCKS = GuitaRegistries.create(BLOCKS);
    public static final GuitaRegistry<Item> CARVED_LOG_ITEMS = GuitaRegistries.create(ITEMS);
    public static final GuitaRegistry<Item> STRIPPED_CARVED_LOG_ITEMS = GuitaRegistries.create(ITEMS);
    public static final GuitaRegistry<Block> BEAM_BLOCKS = GuitaRegistries.create(BLOCKS);
    public static final GuitaRegistry<Block> STRIPPED_BEAM_BLOCKS = GuitaRegistries.create(BLOCKS);
    public static final GuitaRegistry<Item> BEAM_ITEMS = GuitaRegistries.create(ITEMS);
    public static final GuitaRegistry<Item> STRIPPED_BEAM_ITEMS = GuitaRegistries.create(ITEMS);
    public static final GuitaRegistry<Block> HOLLOW_LOG_BLOCKS = GuitaRegistries.create(BLOCKS);
    public static final GuitaRegistry<Block> STRIPPED_HOLLOW_LOG_BLOCKS = GuitaRegistries.create(BLOCKS);
    public static final GuitaRegistry<Item> HOLLOW_LOG_ITEMS = GuitaRegistries.create(ITEMS);
    public static final GuitaRegistry<Item> STRIPPED_HOLLOW_LOG_ITEMS = GuitaRegistries.create(ITEMS);
    public static final GuitaRegistryEntry<Item> SECATEURS = ITEMS.register("secateurs", () -> new ShearsItem(new Item.Properties().m_41503_(476)));
    public static final GuitaRegistryEntry<Block> OAK_STUMP = GWObjects.createStump("oak_stump", Blocks.f_49999_);
    public static final GuitaRegistryEntry<Block> STRIPPED_OAK_STUMP = GWObjects.createStrippedStump("stripped_oak_stump", Blocks.f_50010_);
    public static final GuitaRegistryEntry<Block> SPRUCE_STUMP = GWObjects.createStump("spruce_stump", Blocks.f_50000_);
    public static final GuitaRegistryEntry<Block> STRIPPED_SPRUCE_STUMP = GWObjects.createStrippedStump("stripped_spruce_stump", Blocks.f_50005_);
    public static final GuitaRegistryEntry<Block> BIRCH_STUMP = GWObjects.createStump("birch_stump", Blocks.f_50001_);
    public static final GuitaRegistryEntry<Block> STRIPPED_BIRCH_STUMP = GWObjects.createStrippedStump("stripped_birch_stump", Blocks.f_50006_);
    public static final GuitaRegistryEntry<Block> JUNGLE_STUMP = GWObjects.createStump("jungle_stump", Blocks.f_50002_);
    public static final GuitaRegistryEntry<Block> STRIPPED_JUNGLE_STUMP = GWObjects.createStrippedStump("stripped_jungle_stump", Blocks.f_50007_);
    public static final GuitaRegistryEntry<Block> ACACIA_STUMP = GWObjects.createStump("acacia_stump", Blocks.f_50003_);
    public static final GuitaRegistryEntry<Block> STRIPPED_ACACIA_STUMP = GWObjects.createStrippedStump("stripped_acacia_stump", Blocks.f_50008_);
    public static final GuitaRegistryEntry<Block> DARK_OAK_STUMP = GWObjects.createStump("dark_oak_stump", Blocks.f_50004_);
    public static final GuitaRegistryEntry<Block> STRIPPED_DARK_OAK_STUMP = GWObjects.createStrippedStump("stripped_dark_oak_stump", Blocks.f_50009_);
    public static final GuitaRegistryEntry<Block> MANGROVE_STUMP = GWObjects.createStump("mangrove_stump", Blocks.f_220832_);
    public static final GuitaRegistryEntry<Block> STRIPPED_MANGROVE_STUMP = GWObjects.createStrippedStump("stripped_mangrove_stump", Blocks.f_220835_);
    public static final GuitaRegistryEntry<Block> CHERRY_STUMP = GWObjects.createStump("cherry_stump", Blocks.f_271170_);
    public static final GuitaRegistryEntry<Block> STRIPPED_CHERRY_STUMP = GWObjects.createStrippedStump("stripped_cherry_stump", Blocks.f_271326_);
    public static final GuitaRegistryEntry<Block> CRIMSON_STUMP = GWObjects.createStump("crimson_stump", Blocks.f_50695_);
    public static final GuitaRegistryEntry<Block> STRIPPED_CRIMSON_STUMP = GWObjects.createStrippedStump("stripped_crimson_stump", Blocks.f_50696_);
    public static final GuitaRegistryEntry<Block> WARPED_STUMP = GWObjects.createStump("warped_stump", Blocks.f_50686_);
    public static final GuitaRegistryEntry<Block> STRIPPED_WARPED_STUMP = GWObjects.createStrippedStump("stripped_warped_stump", Blocks.f_50687_);
    public static final GuitaRegistryEntry<Block> MUSHROOM_STUMP = GWObjects.registerWithItem("mushroom_stump", () -> new StumpSeatBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50182_).m_284180_(Blocks.f_50182_.m_284356_()), false), BLOCKS, ITEMS);
    public static final GuitaRegistryEntry<Block> CARVED_OAK_LOG = GWObjects.createCarvedLog("carved_oak_log", Blocks.f_49999_);
    public static final GuitaRegistryEntry<Block> STRIPPED_CARVED_OAK_LOG = GWObjects.createStrippedCarvedLog("stripped_carved_oak_log", Blocks.f_50010_);
    public static final GuitaRegistryEntry<Block> CARVED_SPRUCE_LOG = GWObjects.createCarvedLog("carved_spruce_log", Blocks.f_50000_);
    public static final GuitaRegistryEntry<Block> STRIPPED_CARVED_SPRUCE_LOG = GWObjects.createStrippedCarvedLog("stripped_carved_spruce_log", Blocks.f_50005_);
    public static final GuitaRegistryEntry<Block> CARVED_BIRCH_LOG = GWObjects.createCarvedLog("carved_birch_log", Blocks.f_50001_);
    public static final GuitaRegistryEntry<Block> STRIPPED_CARVED_BIRCH_LOG = GWObjects.createStrippedCarvedLog("stripped_carved_birch_log", Blocks.f_50006_);
    public static final GuitaRegistryEntry<Block> CARVED_JUNGLE_LOG = GWObjects.createCarvedLog("carved_jungle_log", Blocks.f_50002_);
    public static final GuitaRegistryEntry<Block> STRIPPED_CARVED_JUNGLE_LOG = GWObjects.createStrippedCarvedLog("stripped_carved_jungle_log", Blocks.f_50007_);
    public static final GuitaRegistryEntry<Block> CARVED_ACACIA_LOG = GWObjects.createCarvedLog("carved_acacia_log", Blocks.f_50003_);
    public static final GuitaRegistryEntry<Block> STRIPPED_CARVED_ACACIA_LOG = GWObjects.createStrippedCarvedLog("stripped_carved_acacia_log", Blocks.f_50008_);
    public static final GuitaRegistryEntry<Block> CARVED_DARK_OAK_LOG = GWObjects.createCarvedLog("carved_dark_oak_log", Blocks.f_50004_);
    public static final GuitaRegistryEntry<Block> STRIPPED_CARVED_DARK_OAK_LOG = GWObjects.createStrippedCarvedLog("stripped_carved_dark_oak_log", Blocks.f_50009_);
    public static final GuitaRegistryEntry<Block> CARVED_MANGROVE_LOG = GWObjects.createCarvedLog("carved_mangrove_log", Blocks.f_220832_);
    public static final GuitaRegistryEntry<Block> STRIPPED_CARVED_MANGROVE_LOG = GWObjects.createStrippedCarvedLog("stripped_carved_mangrove_log", Blocks.f_220835_);
    public static final GuitaRegistryEntry<Block> CARVED_CHERRY_LOG = GWObjects.createCarvedLog("carved_cherry_log", Blocks.f_271170_);
    public static final GuitaRegistryEntry<Block> STRIPPED_CARVED_CHERRY_LOG = GWObjects.createStrippedCarvedLog("stripped_carved_cherry_log", Blocks.f_271326_);
    public static final GuitaRegistryEntry<Block> CARVED_CRIMSON_STEM = GWObjects.createCarvedLog("carved_crimson_stem", Blocks.f_50695_);
    public static final GuitaRegistryEntry<Block> STRIPPED_CARVED_CRIMSON_STEM = GWObjects.createStrippedCarvedLog("stripped_carved_crimson_stem", Blocks.f_50696_);
    public static final GuitaRegistryEntry<Block> CARVED_WARPED_STEM = GWObjects.createCarvedLog("carved_warped_stem", Blocks.f_50686_);
    public static final GuitaRegistryEntry<Block> STRIPPED_CARVED_WARPED_STEM = GWObjects.createStrippedCarvedLog("stripped_carved_warped_stem", Blocks.f_50687_);
    public static final GuitaRegistryEntry<Block> CARVED_MUSHROOM_STEM = GWObjects.registerWithItem("carved_mushroom_stem", () -> new CarvedLogSeatBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50182_).m_284180_(Blocks.f_50182_.m_284356_()), false), BLOCKS, ITEMS);
    public static final GuitaRegistryEntry<Block> OAK_BEAM = GWObjects.createBeam("oak_beam", Blocks.f_49999_);
    public static final GuitaRegistryEntry<Block> STRIPPED_OAK_BEAM = GWObjects.createStrippedBeam("stripped_oak_beam", Blocks.f_50010_);
    public static final GuitaRegistryEntry<Block> SPRUCE_BEAM = GWObjects.createBeam("spruce_beam", Blocks.f_50000_);
    public static final GuitaRegistryEntry<Block> STRIPPED_SPRUCE_BEAM = GWObjects.createStrippedBeam("stripped_spruce_beam", Blocks.f_50005_);
    public static final GuitaRegistryEntry<Block> BIRCH_BEAM = GWObjects.createBeam("birch_beam", Blocks.f_50001_);
    public static final GuitaRegistryEntry<Block> STRIPPED_BIRCH_BEAM = GWObjects.createStrippedBeam("stripped_birch_beam", Blocks.f_50006_);
    public static final GuitaRegistryEntry<Block> JUNGLE_BEAM = GWObjects.createBeam("jungle_beam", Blocks.f_50002_);
    public static final GuitaRegistryEntry<Block> STRIPPED_JUNGLE_BEAM = GWObjects.createStrippedBeam("stripped_jungle_beam", Blocks.f_50007_);
    public static final GuitaRegistryEntry<Block> ACACIA_BEAM = GWObjects.createBeam("acacia_beam", Blocks.f_50003_);
    public static final GuitaRegistryEntry<Block> STRIPPED_ACACIA_BEAM = GWObjects.createStrippedBeam("stripped_acacia_beam", Blocks.f_50008_);
    public static final GuitaRegistryEntry<Block> DARK_OAK_BEAM = GWObjects.createBeam("dark_oak_beam", Blocks.f_50004_);
    public static final GuitaRegistryEntry<Block> STRIPPED_DARK_OAK_BEAM = GWObjects.createStrippedBeam("stripped_dark_oak_beam", Blocks.f_50009_);
    public static final GuitaRegistryEntry<Block> MANGROVE_BEAM = GWObjects.createBeam("mangrove_beam", Blocks.f_220832_);
    public static final GuitaRegistryEntry<Block> STRIPPED_MANGROVE_BEAM = GWObjects.createStrippedBeam("stripped_mangrove_beam", Blocks.f_220835_);
    public static final GuitaRegistryEntry<Block> CHERRY_BEAM = GWObjects.createBeam("cherry_beam", Blocks.f_271170_);
    public static final GuitaRegistryEntry<Block> STRIPPED_CHERRY_BEAM = GWObjects.createStrippedBeam("stripped_cherry_beam", Blocks.f_271326_);
    public static final GuitaRegistryEntry<Block> CRIMSON_BEAM = GWObjects.createBeam("crimson_beam", Blocks.f_50695_);
    public static final GuitaRegistryEntry<Block> STRIPPED_CRIMSON_BEAM = GWObjects.createStrippedBeam("stripped_crimson_beam", Blocks.f_50696_);
    public static final GuitaRegistryEntry<Block> WARPED_BEAM = GWObjects.createBeam("warped_beam", Blocks.f_50686_);
    public static final GuitaRegistryEntry<Block> STRIPPED_WARPED_BEAM = GWObjects.createStrippedBeam("stripped_warped_beam", Blocks.f_50687_);
    public static final GuitaRegistryEntry<Block> MUSHROOM_BEAM = GWObjects.registerWithItem("mushroom_beam", () -> new ResizableBeamBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50182_).m_284180_(Blocks.f_50182_.m_284356_()), false), BLOCKS, ITEMS);
    public static final GuitaRegistryEntry<Block> HOLLOW_OAK_LOG = GWObjects.createHollowLog("hollow_oak_log", Blocks.f_49999_);
    public static final GuitaRegistryEntry<Block> STRIPPED_HOLLOW_OAK_LOG = GWObjects.createStrippedHollowLog("stripped_hollow_oak_log", Blocks.f_50010_);
    public static final GuitaRegistryEntry<Block> HOLLOW_SPRUCE_LOG = GWObjects.createHollowLog("hollow_spruce_log", Blocks.f_50000_);
    public static final GuitaRegistryEntry<Block> STRIPPED_HOLLOW_SPRUCE_LOG = GWObjects.createStrippedHollowLog("stripped_hollow_spruce_log", Blocks.f_50005_);
    public static final GuitaRegistryEntry<Block> HOLLOW_BIRCH_LOG = GWObjects.createHollowLog("hollow_birch_log", Blocks.f_50001_);
    public static final GuitaRegistryEntry<Block> STRIPPED_HOLLOW_BIRCH_LOG = GWObjects.createStrippedHollowLog("stripped_hollow_birch_log", Blocks.f_50006_);
    public static final GuitaRegistryEntry<Block> HOLLOW_JUNGLE_LOG = GWObjects.createHollowLog("hollow_jungle_log", Blocks.f_50002_);
    public static final GuitaRegistryEntry<Block> STRIPPED_HOLLOW_JUNGLE_LOG = GWObjects.createStrippedHollowLog("stripped_hollow_jungle_log", Blocks.f_50007_);
    public static final GuitaRegistryEntry<Block> HOLLOW_ACACIA_LOG = GWObjects.createHollowLog("hollow_acacia_log", Blocks.f_50003_);
    public static final GuitaRegistryEntry<Block> STRIPPED_HOLLOW_ACACIA_LOG = GWObjects.createStrippedHollowLog("stripped_hollow_acacia_log", Blocks.f_50008_);
    public static final GuitaRegistryEntry<Block> HOLLOW_DARK_OAK_LOG = GWObjects.createHollowLog("hollow_dark_oak_log", Blocks.f_50004_);
    public static final GuitaRegistryEntry<Block> STRIPPED_HOLLOW_DARK_OAK_LOG = GWObjects.createStrippedHollowLog("stripped_hollow_dark_oak_log", Blocks.f_50009_);
    public static final GuitaRegistryEntry<Block> HOLLOW_MANGROVE_LOG = GWObjects.createHollowLog("hollow_mangrove_log", Blocks.f_220832_);
    public static final GuitaRegistryEntry<Block> STRIPPED_HOLLOW_MANGROVE_LOG = GWObjects.createStrippedHollowLog("stripped_hollow_mangrove_log", Blocks.f_220835_);
    public static final GuitaRegistryEntry<Block> HOLLOW_CHERRY_LOG = GWObjects.createHollowLog("hollow_cherry_log", Blocks.f_271170_);
    public static final GuitaRegistryEntry<Block> STRIPPED_HOLLOW_CHERRY_LOG = GWObjects.createStrippedHollowLog("stripped_hollow_cherry_log", Blocks.f_271326_);
    public static final GuitaRegistryEntry<Block> HOLLOW_CRIMSON_STEM = GWObjects.createHollowLog("hollow_crimson_stem", Blocks.f_50695_);
    public static final GuitaRegistryEntry<Block> STRIPPED_HOLLOW_CRIMSON_STEM = GWObjects.createStrippedHollowLog("stripped_hollow_crimson_stem", Blocks.f_50696_);
    public static final GuitaRegistryEntry<Block> HOLLOW_WARPED_STEM = GWObjects.createHollowLog("hollow_warped_stem", Blocks.f_50686_);
    public static final GuitaRegistryEntry<Block> STRIPPED_HOLLOW_WARPED_STEM = GWObjects.createStrippedHollowLog("stripped_hollow_warped_stem", Blocks.f_50687_);
    public static final GuitaRegistryEntry<Block> HOLLOW_MUSHROOM_STEM = GWObjects.registerWithItem("hollow_mushroom_stem", () -> new HollowLogBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50182_).m_284180_(Blocks.f_50182_.m_284356_()), false), BLOCKS, ITEMS);

    public static GuitaRegistryEntry<Block> createStump(String name, Block wood) {
        GuitaRegistryEntry<Block> block = GWObjects.registerWithItem(name, () -> new StumpSeatBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)wood).m_284180_(wood.m_284356_())), STUMP_BLOCKS, STUMP_ITEMS);
        if (GWUtils.isFabric()) {
            WOOD_ASSOCIATIONS.put((Block)block.get(), wood);
        }
        return block;
    }

    public static GuitaRegistryEntry<Block> createStrippedStump(String name, Block wood) {
        GuitaRegistryEntry<Block> block = GWObjects.registerWithItem(name, () -> new StumpSeatBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)wood).m_284180_(wood.m_284356_()), false), STRIPPED_STUMP_BLOCKS, STRIPPED_STUMP_ITEMS);
        if (GWUtils.isFabric()) {
            WOOD_ASSOCIATIONS.put((Block)block.get(), wood);
        }
        return block;
    }

    public static GuitaRegistryEntry<Block> createCarvedLog(String name, Block wood) {
        GuitaRegistryEntry<Block> block = GWObjects.registerWithItem(name, () -> new CarvedLogSeatBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)wood).m_284180_(wood.m_284356_())), CARVED_LOG_BLOCKS, CARVED_LOG_ITEMS);
        if (GWUtils.isFabric()) {
            WOOD_ASSOCIATIONS.put((Block)block.get(), wood);
        }
        return block;
    }

    public static GuitaRegistryEntry<Block> createStrippedCarvedLog(String name, Block wood) {
        GuitaRegistryEntry<Block> block = GWObjects.registerWithItem(name, () -> new CarvedLogSeatBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)wood).m_284180_(wood.m_284356_()), false), STRIPPED_CARVED_LOG_BLOCKS, STRIPPED_CARVED_LOG_ITEMS);
        if (GWUtils.isFabric()) {
            WOOD_ASSOCIATIONS.put((Block)block.get(), wood);
        }
        return block;
    }

    public static GuitaRegistryEntry<Block> createBeam(String name, Block wood) {
        GuitaRegistryEntry<Block> block = GWObjects.registerWithItem(name, () -> new ResizableBeamBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)wood).m_284180_(wood.m_284356_())), BEAM_BLOCKS, BEAM_ITEMS);
        if (GWUtils.isFabric()) {
            WOOD_ASSOCIATIONS.put((Block)block.get(), wood);
        }
        return block;
    }

    public static GuitaRegistryEntry<Block> createStrippedBeam(String name, Block wood) {
        GuitaRegistryEntry<Block> block = GWObjects.registerWithItem(name, () -> new ResizableBeamBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)wood).m_284180_(wood.m_284356_()), false), STRIPPED_BEAM_BLOCKS, STRIPPED_BEAM_ITEMS);
        if (GWUtils.isFabric()) {
            WOOD_ASSOCIATIONS.put((Block)block.get(), wood);
        }
        return block;
    }

    public static GuitaRegistryEntry<Block> createHollowLog(String name, Block wood) {
        GuitaRegistryEntry<Block> block = GWObjects.registerWithItem(name, () -> new HollowLogBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)wood).m_284180_(wood.m_284356_())), HOLLOW_LOG_BLOCKS, HOLLOW_LOG_ITEMS);
        if (GWUtils.isFabric()) {
            WOOD_ASSOCIATIONS.put((Block)block.get(), wood);
        }
        return block;
    }

    public static GuitaRegistryEntry<Block> createStrippedHollowLog(String name, Block wood) {
        GuitaRegistryEntry<Block> block = GWObjects.registerWithItem(name, () -> new HollowLogBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)wood).m_284180_(wood.m_284356_()), false), STRIPPED_HOLLOW_LOG_BLOCKS, STRIPPED_HOLLOW_LOG_ITEMS);
        if (GWUtils.isFabric()) {
            WOOD_ASSOCIATIONS.put((Block)block.get(), wood);
        }
        return block;
    }

    public static <T extends Block> GuitaRegistryEntry<T> registerWithItem(String name, Supplier<T> block, GuitaRegistry<Block> blockReg, GuitaRegistry<Item> itemReg) {
        GuitaRegistryEntry toReturn = blockReg.register(name, block);
        itemReg.register(name, () -> new BlockItem((Block)toReturn.get(), new Item.Properties()));
        return toReturn;
    }

    public static void init() {
        BLOCKS.init();
        ITEMS.init();
    }
}

