/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.woodworks.block;

import com.macuguita.woodworks.block.SittableBlock;
import com.macuguita.woodworks.block.property.NoCornerModularSeatProperty;
import com.macuguita.woodworks.reg.GWBlockTags;
import com.macuguita.woodworks.reg.GWItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public abstract class NoCornerModularSeatBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock,
SittableBlock {
    public static final EnumProperty<NoCornerModularSeatProperty> SHAPE = EnumProperty.create((String)"shape", NoCornerModularSeatProperty.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    protected NoCornerModularSeatBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(SHAPE, (Comparable)((Object)NoCornerModularSeatProperty.SINGLE))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SHAPE, FACING, WATERLOGGED});
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        NoCornerModularSeatProperty couchShape = (NoCornerModularSeatProperty)((Object)state.getValue(SHAPE));
        switch (mirror) {
            case LEFT_RIGHT: {
                if (direction.getAxis() != Direction.Axis.Z) break;
                return (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)((Object)couchShape));
            }
            case FRONT_BACK: {
                if (direction.getAxis() != Direction.Axis.X) break;
                return (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)((Object)couchShape));
            }
        }
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        InteractionHand hand = player.getUsedItemHand();
        ItemStack stack = player.getItemInHand(hand);
        if (stack.is(GWItemTags.WATER_BUCKETS)) {
            return InteractionResult.FAIL;
        }
        if (stack.is(GWItemTags.CARVED_LOG)) {
            return InteractionResult.FAIL;
        }
        return this.sitOn(world, pos, player, (Direction)state.getValue((Property)FACING)) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return direction.getAxis().isHorizontal() ? (BlockState)state.setValue(SHAPE, (Comparable)((Object)this.getShape(state, world, pos))) : super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos pos = ctx.getClickedPos();
        Direction dir = ctx.getHorizontalDirection().getOpposite();
        BlockState state = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)dir)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.getLevel().getFluidState(ctx.getClickedPos()).is((Fluid)Fluids.WATER)));
        return (BlockState)state.setValue(SHAPE, (Comparable)((Object)this.getShape(state, (LevelAccessor)ctx.getLevel(), pos)));
    }

    private NoCornerModularSeatProperty getShape(BlockState state, LevelAccessor world, BlockPos pos) {
        boolean hasRight;
        Direction dir = (Direction)state.getValue((Property)FACING);
        Direction left = dir.getCounterClockWise(Direction.Axis.Y);
        Direction right = dir.getClockWise(Direction.Axis.Y);
        boolean hasLeft = world.getBlockState(pos.relative(left)).is(GWBlockTags.CARVED_LOG) && world.getBlockState(pos.relative(left)).getValue((Property)FACING) == dir;
        boolean bl = hasRight = world.getBlockState(pos.relative(right)).is(GWBlockTags.CARVED_LOG) && world.getBlockState(pos.relative(right)).getValue((Property)FACING) == dir;
        if (hasLeft && hasRight) {
            return NoCornerModularSeatProperty.MIDDLE;
        }
        if (hasLeft) {
            return NoCornerModularSeatProperty.RIGHT;
        }
        if (hasRight) {
            return NoCornerModularSeatProperty.LEFT;
        }
        return NoCornerModularSeatProperty.SINGLE;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

