/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.woodworks.reg;

import com.macuguita.lib.platform.registry.GuitaRegistries;
import com.macuguita.lib.platform.registry.GuitaRegistry;
import com.macuguita.lib.platform.registry.GuitaRegistryEntry;
import com.macuguita.woodworks.block.CarvedLogSeatBlock;
import com.macuguita.woodworks.block.HollowLogBlock;
import com.macuguita.woodworks.block.ResizableBeamBlock;
import com.macuguita.woodworks.block.StumpSeatBlock;
import com.macuguita.woodworks.utils.GWUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class GWObjects {
    public static final Map<Block, Block> WOOD_ASSOCIATIONS = new HashMap<Block, Block>();
    public static final GuitaRegistry<Block> BLOCKS = GuitaRegistries.create((Registry)BuiltInRegistries.BLOCK, (String)"gwoodworks");
    public static final GuitaRegistry<Item> ITEMS = GuitaRegistries.create((Registry)BuiltInRegistries.ITEM, (String)"gwoodworks");
    public static final GuitaRegistry<Block> STUMP_BLOCKS = GuitaRegistries.create(BLOCKS);
    public static final GuitaRegistry<Block> STRIPPED_STUMP_BLOCKS = GuitaRegistries.create(BLOCKS);
    public static final GuitaRegistry<Item> STUMP_ITEMS = GuitaRegistries.create(ITEMS);
    public static final GuitaRegistry<Item> STRIPPED_STUMP_ITEMS = GuitaRegistries.create(ITEMS);
    public static final GuitaRegistry<Block> CARVED_LOG_BLOCKS = GuitaRegistries.create(BLOCKS);
    public static final GuitaRegistry<Block> STRIPPED_CARVED_LOG_BLOCKS = GuitaRegistries.create(BLOCKS);
    public static final GuitaRegistry<Item> CARVED_LOG_ITEMS = GuitaRegistries.create(ITEMS);
    public static final GuitaRegistry<Item> STRIPPED_CARVED_LOG_ITEMS = GuitaRegistries.create(ITEMS);
    public static final GuitaRegistry<Block> BEAM_BLOCKS = GuitaRegistries.create(BLOCKS);
    public static final GuitaRegistry<Block> STRIPPED_BEAM_BLOCKS = GuitaRegistries.create(BLOCKS);
    public static final GuitaRegistry<Item> BEAM_ITEMS = GuitaRegistries.create(ITEMS);
    public static final GuitaRegistry<Item> STRIPPED_BEAM_ITEMS = GuitaRegistries.create(ITEMS);
    public static final GuitaRegistry<Block> HOLLOW_LOG_BLOCKS = GuitaRegistries.create(BLOCKS);
    public static final GuitaRegistry<Block> STRIPPED_HOLLOW_LOG_BLOCKS = GuitaRegistries.create(BLOCKS);
    public static final GuitaRegistry<Item> HOLLOW_LOG_ITEMS = GuitaRegistries.create(ITEMS);
    public static final GuitaRegistry<Item> STRIPPED_HOLLOW_LOG_ITEMS = GuitaRegistries.create(ITEMS);
    public static final GuitaRegistryEntry<Item> SECATEURS = ITEMS.register("secateurs", () -> new Item(new Item.Properties().durability(476).component(DataComponents.TOOL, (Object)ShearsItem.createToolProperties())));
    public static final GuitaRegistryEntry<Block> OAK_STUMP = GWObjects.createStump("oak_stump", Blocks.OAK_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_OAK_STUMP = GWObjects.createStrippedStump("stripped_oak_stump", Blocks.STRIPPED_OAK_LOG);
    public static final GuitaRegistryEntry<Block> SPRUCE_STUMP = GWObjects.createStump("spruce_stump", Blocks.SPRUCE_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_SPRUCE_STUMP = GWObjects.createStrippedStump("stripped_spruce_stump", Blocks.STRIPPED_SPRUCE_LOG);
    public static final GuitaRegistryEntry<Block> BIRCH_STUMP = GWObjects.createStump("birch_stump", Blocks.BIRCH_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_BIRCH_STUMP = GWObjects.createStrippedStump("stripped_birch_stump", Blocks.STRIPPED_BIRCH_LOG);
    public static final GuitaRegistryEntry<Block> JUNGLE_STUMP = GWObjects.createStump("jungle_stump", Blocks.JUNGLE_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_JUNGLE_STUMP = GWObjects.createStrippedStump("stripped_jungle_stump", Blocks.STRIPPED_JUNGLE_LOG);
    public static final GuitaRegistryEntry<Block> ACACIA_STUMP = GWObjects.createStump("acacia_stump", Blocks.ACACIA_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_ACACIA_STUMP = GWObjects.createStrippedStump("stripped_acacia_stump", Blocks.STRIPPED_ACACIA_LOG);
    public static final GuitaRegistryEntry<Block> DARK_OAK_STUMP = GWObjects.createStump("dark_oak_stump", Blocks.DARK_OAK_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_DARK_OAK_STUMP = GWObjects.createStrippedStump("stripped_dark_oak_stump", Blocks.STRIPPED_DARK_OAK_LOG);
    public static final GuitaRegistryEntry<Block> MANGROVE_STUMP = GWObjects.createStump("mangrove_stump", Blocks.MANGROVE_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_MANGROVE_STUMP = GWObjects.createStrippedStump("stripped_mangrove_stump", Blocks.STRIPPED_MANGROVE_LOG);
    public static final GuitaRegistryEntry<Block> CHERRY_STUMP = GWObjects.createStump("cherry_stump", Blocks.CHERRY_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_CHERRY_STUMP = GWObjects.createStrippedStump("stripped_cherry_stump", Blocks.STRIPPED_CHERRY_LOG);
    public static final GuitaRegistryEntry<Block> CRIMSON_STUMP = GWObjects.createStump("crimson_stump", Blocks.CRIMSON_STEM);
    public static final GuitaRegistryEntry<Block> STRIPPED_CRIMSON_STUMP = GWObjects.createStrippedStump("stripped_crimson_stump", Blocks.STRIPPED_CRIMSON_STEM);
    public static final GuitaRegistryEntry<Block> WARPED_STUMP = GWObjects.createStump("warped_stump", Blocks.WARPED_STEM);
    public static final GuitaRegistryEntry<Block> STRIPPED_WARPED_STUMP = GWObjects.createStrippedStump("stripped_warped_stump", Blocks.STRIPPED_WARPED_STEM);
    public static final GuitaRegistryEntry<Block> MUSHROOM_STUMP = GWObjects.registerWithItem("mushroom_stump", () -> new StumpSeatBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUSHROOM_STEM).mapColor(Blocks.MUSHROOM_STEM.defaultMapColor()), false), BLOCKS, ITEMS);
    public static final GuitaRegistryEntry<Block> CARVED_OAK_LOG = GWObjects.createCarvedLog("carved_oak_log", Blocks.OAK_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_CARVED_OAK_LOG = GWObjects.createStrippedCarvedLog("stripped_carved_oak_log", Blocks.STRIPPED_OAK_LOG);
    public static final GuitaRegistryEntry<Block> CARVED_SPRUCE_LOG = GWObjects.createCarvedLog("carved_spruce_log", Blocks.SPRUCE_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_CARVED_SPRUCE_LOG = GWObjects.createStrippedCarvedLog("stripped_carved_spruce_log", Blocks.STRIPPED_SPRUCE_LOG);
    public static final GuitaRegistryEntry<Block> CARVED_BIRCH_LOG = GWObjects.createCarvedLog("carved_birch_log", Blocks.BIRCH_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_CARVED_BIRCH_LOG = GWObjects.createStrippedCarvedLog("stripped_carved_birch_log", Blocks.STRIPPED_BIRCH_LOG);
    public static final GuitaRegistryEntry<Block> CARVED_JUNGLE_LOG = GWObjects.createCarvedLog("carved_jungle_log", Blocks.JUNGLE_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_CARVED_JUNGLE_LOG = GWObjects.createStrippedCarvedLog("stripped_carved_jungle_log", Blocks.STRIPPED_JUNGLE_LOG);
    public static final GuitaRegistryEntry<Block> CARVED_ACACIA_LOG = GWObjects.createCarvedLog("carved_acacia_log", Blocks.ACACIA_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_CARVED_ACACIA_LOG = GWObjects.createStrippedCarvedLog("stripped_carved_acacia_log", Blocks.STRIPPED_ACACIA_LOG);
    public static final GuitaRegistryEntry<Block> CARVED_DARK_OAK_LOG = GWObjects.createCarvedLog("carved_dark_oak_log", Blocks.DARK_OAK_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_CARVED_DARK_OAK_LOG = GWObjects.createStrippedCarvedLog("stripped_carved_dark_oak_log", Blocks.STRIPPED_DARK_OAK_LOG);
    public static final GuitaRegistryEntry<Block> CARVED_MANGROVE_LOG = GWObjects.createCarvedLog("carved_mangrove_log", Blocks.MANGROVE_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_CARVED_MANGROVE_LOG = GWObjects.createStrippedCarvedLog("stripped_carved_mangrove_log", Blocks.STRIPPED_MANGROVE_LOG);
    public static final GuitaRegistryEntry<Block> CARVED_CHERRY_LOG = GWObjects.createCarvedLog("carved_cherry_log", Blocks.CHERRY_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_CARVED_CHERRY_LOG = GWObjects.createStrippedCarvedLog("stripped_carved_cherry_log", Blocks.STRIPPED_CHERRY_LOG);
    public static final GuitaRegistryEntry<Block> CARVED_CRIMSON_STEM = GWObjects.createCarvedLog("carved_crimson_stem", Blocks.CRIMSON_STEM);
    public static final GuitaRegistryEntry<Block> STRIPPED_CARVED_CRIMSON_STEM = GWObjects.createStrippedCarvedLog("stripped_carved_crimson_stem", Blocks.STRIPPED_CRIMSON_STEM);
    public static final GuitaRegistryEntry<Block> CARVED_WARPED_STEM = GWObjects.createCarvedLog("carved_warped_stem", Blocks.WARPED_STEM);
    public static final GuitaRegistryEntry<Block> STRIPPED_CARVED_WARPED_STEM = GWObjects.createStrippedCarvedLog("stripped_carved_warped_stem", Blocks.STRIPPED_WARPED_STEM);
    public static final GuitaRegistryEntry<Block> CARVED_MUSHROOM_STEM = GWObjects.registerWithItem("carved_mushroom_stem", () -> new CarvedLogSeatBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUSHROOM_STEM).mapColor(Blocks.MUSHROOM_STEM.defaultMapColor()), false), BLOCKS, ITEMS);
    public static final GuitaRegistryEntry<Block> OAK_BEAM = GWObjects.createBeam("oak_beam", Blocks.OAK_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_OAK_BEAM = GWObjects.createStrippedBeam("stripped_oak_beam", Blocks.STRIPPED_OAK_LOG);
    public static final GuitaRegistryEntry<Block> SPRUCE_BEAM = GWObjects.createBeam("spruce_beam", Blocks.SPRUCE_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_SPRUCE_BEAM = GWObjects.createStrippedBeam("stripped_spruce_beam", Blocks.STRIPPED_SPRUCE_LOG);
    public static final GuitaRegistryEntry<Block> BIRCH_BEAM = GWObjects.createBeam("birch_beam", Blocks.BIRCH_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_BIRCH_BEAM = GWObjects.createStrippedBeam("stripped_birch_beam", Blocks.STRIPPED_BIRCH_LOG);
    public static final GuitaRegistryEntry<Block> JUNGLE_BEAM = GWObjects.createBeam("jungle_beam", Blocks.JUNGLE_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_JUNGLE_BEAM = GWObjects.createStrippedBeam("stripped_jungle_beam", Blocks.STRIPPED_JUNGLE_LOG);
    public static final GuitaRegistryEntry<Block> ACACIA_BEAM = GWObjects.createBeam("acacia_beam", Blocks.ACACIA_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_ACACIA_BEAM = GWObjects.createStrippedBeam("stripped_acacia_beam", Blocks.STRIPPED_ACACIA_LOG);
    public static final GuitaRegistryEntry<Block> DARK_OAK_BEAM = GWObjects.createBeam("dark_oak_beam", Blocks.DARK_OAK_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_DARK_OAK_BEAM = GWObjects.createStrippedBeam("stripped_dark_oak_beam", Blocks.STRIPPED_DARK_OAK_LOG);
    public static final GuitaRegistryEntry<Block> MANGROVE_BEAM = GWObjects.createBeam("mangrove_beam", Blocks.MANGROVE_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_MANGROVE_BEAM = GWObjects.createStrippedBeam("stripped_mangrove_beam", Blocks.STRIPPED_MANGROVE_LOG);
    public static final GuitaRegistryEntry<Block> CHERRY_BEAM = GWObjects.createBeam("cherry_beam", Blocks.CHERRY_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_CHERRY_BEAM = GWObjects.createStrippedBeam("stripped_cherry_beam", Blocks.STRIPPED_CHERRY_LOG);
    public static final GuitaRegistryEntry<Block> CRIMSON_BEAM = GWObjects.createBeam("crimson_beam", Blocks.CRIMSON_STEM);
    public static final GuitaRegistryEntry<Block> STRIPPED_CRIMSON_BEAM = GWObjects.createStrippedBeam("stripped_crimson_beam", Blocks.STRIPPED_CRIMSON_STEM);
    public static final GuitaRegistryEntry<Block> WARPED_BEAM = GWObjects.createBeam("warped_beam", Blocks.WARPED_STEM);
    public static final GuitaRegistryEntry<Block> STRIPPED_WARPED_BEAM = GWObjects.createStrippedBeam("stripped_warped_beam", Blocks.STRIPPED_WARPED_STEM);
    public static final GuitaRegistryEntry<Block> MUSHROOM_BEAM = GWObjects.registerWithItem("mushroom_beam", () -> new ResizableBeamBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUSHROOM_STEM).mapColor(Blocks.MUSHROOM_STEM.defaultMapColor()), false), BLOCKS, ITEMS);
    public static final GuitaRegistryEntry<Block> HOLLOW_OAK_LOG = GWObjects.createHollowLog("hollow_oak_log", Blocks.OAK_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_HOLLOW_OAK_LOG = GWObjects.createStrippedHollowLog("stripped_hollow_oak_log", Blocks.STRIPPED_OAK_LOG);
    public static final GuitaRegistryEntry<Block> HOLLOW_SPRUCE_LOG = GWObjects.createHollowLog("hollow_spruce_log", Blocks.SPRUCE_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_HOLLOW_SPRUCE_LOG = GWObjects.createStrippedHollowLog("stripped_hollow_spruce_log", Blocks.STRIPPED_SPRUCE_LOG);
    public static final GuitaRegistryEntry<Block> HOLLOW_BIRCH_LOG = GWObjects.createHollowLog("hollow_birch_log", Blocks.BIRCH_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_HOLLOW_BIRCH_LOG = GWObjects.createStrippedHollowLog("stripped_hollow_birch_log", Blocks.STRIPPED_BIRCH_LOG);
    public static final GuitaRegistryEntry<Block> HOLLOW_JUNGLE_LOG = GWObjects.createHollowLog("hollow_jungle_log", Blocks.JUNGLE_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_HOLLOW_JUNGLE_LOG = GWObjects.createStrippedHollowLog("stripped_hollow_jungle_log", Blocks.STRIPPED_JUNGLE_LOG);
    public static final GuitaRegistryEntry<Block> HOLLOW_ACACIA_LOG = GWObjects.createHollowLog("hollow_acacia_log", Blocks.ACACIA_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_HOLLOW_ACACIA_LOG = GWObjects.createStrippedHollowLog("stripped_hollow_acacia_log", Blocks.STRIPPED_ACACIA_LOG);
    public static final GuitaRegistryEntry<Block> HOLLOW_DARK_OAK_LOG = GWObjects.createHollowLog("hollow_dark_oak_log", Blocks.DARK_OAK_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_HOLLOW_DARK_OAK_LOG = GWObjects.createStrippedHollowLog("stripped_hollow_dark_oak_log", Blocks.STRIPPED_DARK_OAK_LOG);
    public static final GuitaRegistryEntry<Block> HOLLOW_MANGROVE_LOG = GWObjects.createHollowLog("hollow_mangrove_log", Blocks.MANGROVE_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_HOLLOW_MANGROVE_LOG = GWObjects.createStrippedHollowLog("stripped_hollow_mangrove_log", Blocks.STRIPPED_MANGROVE_LOG);
    public static final GuitaRegistryEntry<Block> HOLLOW_CHERRY_LOG = GWObjects.createHollowLog("hollow_cherry_log", Blocks.CHERRY_LOG);
    public static final GuitaRegistryEntry<Block> STRIPPED_HOLLOW_CHERRY_LOG = GWObjects.createStrippedHollowLog("stripped_hollow_cherry_log", Blocks.STRIPPED_CHERRY_LOG);
    public static final GuitaRegistryEntry<Block> HOLLOW_CRIMSON_STEM = GWObjects.createHollowLog("hollow_crimson_stem", Blocks.CRIMSON_STEM);
    public static final GuitaRegistryEntry<Block> STRIPPED_HOLLOW_CRIMSON_STEM = GWObjects.createStrippedHollowLog("stripped_hollow_crimson_stem", Blocks.STRIPPED_CRIMSON_STEM);
    public static final GuitaRegistryEntry<Block> HOLLOW_WARPED_STEM = GWObjects.createHollowLog("hollow_warped_stem", Blocks.WARPED_STEM);
    public static final GuitaRegistryEntry<Block> STRIPPED_HOLLOW_WARPED_STEM = GWObjects.createStrippedHollowLog("stripped_hollow_warped_stem", Blocks.STRIPPED_WARPED_STEM);
    public static final GuitaRegistryEntry<Block> HOLLOW_MUSHROOM_STEM = GWObjects.registerWithItem("hollow_mushroom_stem", () -> new HollowLogBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUSHROOM_STEM).mapColor(Blocks.MUSHROOM_STEM.defaultMapColor()), false), BLOCKS, ITEMS);

    public static GuitaRegistryEntry<Block> createStump(String name, Block wood) {
        GuitaRegistryEntry<Block> block = GWObjects.registerWithItem(name, () -> new StumpSeatBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)wood).mapColor(wood.defaultMapColor())), STUMP_BLOCKS, STUMP_ITEMS);
        if (GWUtils.isFabric()) {
            WOOD_ASSOCIATIONS.put((Block)block.get(), wood);
        }
        return block;
    }

    public static GuitaRegistryEntry<Block> createStrippedStump(String name, Block wood) {
        GuitaRegistryEntry<Block> block = GWObjects.registerWithItem(name, () -> new StumpSeatBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)wood).mapColor(wood.defaultMapColor()), false), STRIPPED_STUMP_BLOCKS, STRIPPED_STUMP_ITEMS);
        if (GWUtils.isFabric()) {
            WOOD_ASSOCIATIONS.put((Block)block.get(), wood);
        }
        return block;
    }

    public static GuitaRegistryEntry<Block> createCarvedLog(String name, Block wood) {
        GuitaRegistryEntry<Block> block = GWObjects.registerWithItem(name, () -> new CarvedLogSeatBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)wood).mapColor(wood.defaultMapColor())), CARVED_LOG_BLOCKS, CARVED_LOG_ITEMS);
        if (GWUtils.isFabric()) {
            WOOD_ASSOCIATIONS.put((Block)block.get(), wood);
        }
        return block;
    }

    public static GuitaRegistryEntry<Block> createStrippedCarvedLog(String name, Block wood) {
        GuitaRegistryEntry<Block> block = GWObjects.registerWithItem(name, () -> new CarvedLogSeatBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)wood).mapColor(wood.defaultMapColor()), false), STRIPPED_CARVED_LOG_BLOCKS, STRIPPED_CARVED_LOG_ITEMS);
        if (GWUtils.isFabric()) {
            WOOD_ASSOCIATIONS.put((Block)block.get(), wood);
        }
        return block;
    }

    public static GuitaRegistryEntry<Block> createBeam(String name, Block wood) {
        GuitaRegistryEntry<Block> block = GWObjects.registerWithItem(name, () -> new ResizableBeamBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)wood).mapColor(wood.defaultMapColor())), BEAM_BLOCKS, BEAM_ITEMS);
        if (GWUtils.isFabric()) {
            WOOD_ASSOCIATIONS.put((Block)block.get(), wood);
        }
        return block;
    }

    public static GuitaRegistryEntry<Block> createStrippedBeam(String name, Block wood) {
        GuitaRegistryEntry<Block> block = GWObjects.registerWithItem(name, () -> new ResizableBeamBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)wood).mapColor(wood.defaultMapColor()), false), STRIPPED_BEAM_BLOCKS, STRIPPED_BEAM_ITEMS);
        if (GWUtils.isFabric()) {
            WOOD_ASSOCIATIONS.put((Block)block.get(), wood);
        }
        return block;
    }

    public static GuitaRegistryEntry<Block> createHollowLog(String name, Block wood) {
        GuitaRegistryEntry<Block> block = GWObjects.registerWithItem(name, () -> new HollowLogBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)wood).mapColor(wood.defaultMapColor())), HOLLOW_LOG_BLOCKS, HOLLOW_LOG_ITEMS);
        if (GWUtils.isFabric()) {
            WOOD_ASSOCIATIONS.put((Block)block.get(), wood);
        }
        return block;
    }

    public static GuitaRegistryEntry<Block> createStrippedHollowLog(String name, Block wood) {
        GuitaRegistryEntry<Block> block = GWObjects.registerWithItem(name, () -> new HollowLogBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)wood).mapColor(wood.defaultMapColor()), false), STRIPPED_HOLLOW_LOG_BLOCKS, STRIPPED_HOLLOW_LOG_ITEMS);
        if (GWUtils.isFabric()) {
            WOOD_ASSOCIATIONS.put((Block)block.get(), wood);
        }
        return block;
    }

    public static <T extends Block> GuitaRegistryEntry<T> registerWithItem(String name, Supplier<T> block, GuitaRegistry<Block> blockReg, GuitaRegistry<Item> itemReg) {
        GuitaRegistryEntry toReturn = blockReg.register(name, block);
        itemReg.register(name, () -> new BlockItem((Block)toReturn.get(), new Item.Properties()));
        return toReturn;
    }

    public static void init() {
        BLOCKS.init();
        ITEMS.init();
    }
}

