/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.forge;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.commands.BWGCommands;
import net.potionstudios.biomeswevegone.forge.ForgePlatformHandler;
import net.potionstudios.biomeswevegone.forge.VanillaCompatForge;
import net.potionstudios.biomeswevegone.forge.client.BiomesWeveGoneClientForge;
import net.potionstudios.biomeswevegone.forge.loot.LootModifiersRegister;
import net.potionstudios.biomeswevegone.world.entity.BWGEntityType;
import net.potionstudios.biomeswevegone.world.entity.npc.BWGVillagerTrades;
import net.potionstudios.biomeswevegone.world.level.levelgen.biome.BWGOverworldSurfaceRules;
import net.potionstudios.biomeswevegone.world.level.levelgen.biome.BWGTerraBlenderRegion;
import terrablender.api.SurfaceRuleManager;

@Mod(value="biomeswevegone")
public class BiomesWeveGoneForge {
    public BiomesWeveGoneForge(FMLJavaModLoadingContext context) {
        BusGroup modBusGroup = context.getModBusGroup();
        BiomesWeveGone.init();
        ForgePlatformHandler.register(modBusGroup);
        FMLCommonSetupEvent.getBus((BusGroup)modBusGroup).addListener(this::onInitialize);
        FMLLoadCompleteEvent.getBus((BusGroup)modBusGroup).addListener(this::onPostInitialize);
        ServerAboutToStartEvent.BUS.addListener(event -> BiomesWeveGone.serverStart(event.getServer()));
        EntityAttributeCreationEvent.getBus((BusGroup)modBusGroup).addListener(event -> BWGEntityType.registerEntityAttributes((arg_0, arg_1) -> ((EntityAttributeCreationEvent)event).put(arg_0, arg_1)));
        SpawnPlacementRegisterEvent.getBus((BusGroup)modBusGroup).addListener(event -> BWGEntityType.registerSpawnPlacements(consumer -> event.register(consumer.entityType(), consumer.spawnPlacementType(), consumer.heightmapType(), consumer.predicate(), SpawnPlacementRegisterEvent.Operation.OR)));
        RegisterCommandsEvent.BUS.addListener(event -> BWGCommands.register(arg_0 -> ((CommandDispatcher)event.getDispatcher()).register(arg_0)));
        EntityJoinLevelEvent.BUS.addListener(event -> BiomesWeveGone.onEntityLoad(event.getEntity()));
        VanillaCompatForge.registerVanillaCompatEvents(modBusGroup);
        if (FMLEnvironment.dist.isClient()) {
            BiomesWeveGoneClientForge.init(modBusGroup);
        }
        LootModifiersRegister.register(modBusGroup);
    }

    private void onInitialize(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            BiomesWeveGone.commonSetup();
            VanillaCompatForge.init();
            BWGTerraBlenderRegion.registerTerrablenderRegions();
            ForgePlatformHandler.registerPottedPlants();
            SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)"biomeswevegone", (SurfaceRules.RuleSource)BWGOverworldSurfaceRules.makeRules());
        });
    }

    private void onPostInitialize(FMLLoadCompleteEvent event) {
        event.enqueueWork(BiomesWeveGone::postInit);
        BWGVillagerTrades.makeTrades();
        BWGVillagerTrades.makeWanderingTrades();
    }
}

