/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.potionstudios.biomeswevegone.world.entity.pumpkinwarden.PumpkinWarden;
import org.jetbrains.annotations.NotNull;

public class DestroyPumpkin
extends Behavior<PumpkinWarden> {
    private BlockPos targetBlock;
    private Block fruitBlock;
    protected int tryTicks;

    public DestroyPumpkin() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull PumpkinWarden pumpkinWarden) {
        return pumpkinWarden.canMove() && pumpkinWarden.getItemInHand(InteractionHand.MAIN_HAND).isEmpty();
    }

    protected void tick(@NotNull ServerLevel level, @NotNull PumpkinWarden pumpkinWarden, long gameTime) {
        if (this.targetBlock == null) {
            return;
        }
        if (!this.targetBlock.closerToCenterThan((Position)pumpkinWarden.position(), 1.0)) {
            ++this.tryTicks;
            if (this.tryTicks > 200) {
                this.stop(level, pumpkinWarden, gameTime);
            }
        } else if (level.getBlockState(this.targetBlock).is(this.fruitBlock)) {
            BlockState blockState = level.getBlockState(this.targetBlock);
            level.destroyBlock(this.targetBlock, false, (Entity)pumpkinWarden);
            level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, this.targetBlock, GameEvent.Context.of((Entity)pumpkinWarden, (BlockState)blockState));
            pumpkinWarden.setItemInHand(InteractionHand.MAIN_HAND, blockState.getBlock().asItem().getDefaultInstance());
            this.stop(level, pumpkinWarden, gameTime);
        } else {
            this.stop(level, pumpkinWarden, gameTime);
        }
    }

    protected boolean canStillUse(@NotNull ServerLevel level, @NotNull PumpkinWarden pumpkinWarden, long gameTime) {
        return this.checkExtraStartConditions(level, pumpkinWarden);
    }

    protected void start(@NotNull ServerLevel level, @NotNull PumpkinWarden pumpkinWarden, long gameTime) {
        Optional<BlockPos> optionalBlockPos = this.findNearestBlock(level, pumpkinWarden.blockPosition(), blockState -> blockState.getBlock() instanceof AttachedStemBlock, 15.0);
        if (optionalBlockPos.isPresent()) {
            this.targetBlock = optionalBlockPos.get().relative((Direction)level.getBlockState(optionalBlockPos.get()).getValue((Property)AttachedStemBlock.FACING));
            this.fruitBlock = level.getBlockState(this.targetBlock).getBlock();
            pumpkinWarden.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((PositionTracker)new BlockPosTracker(this.targetBlock), 0.8f, 1));
            pumpkinWarden.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(this.targetBlock));
        } else {
            this.stop(level, pumpkinWarden, gameTime);
        }
    }

    private Optional<BlockPos> findNearestBlock(@NotNull ServerLevel level, BlockPos blockPos, Predicate<BlockState> predicate, double distance) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int i = 0;
        while ((double)i <= distance) {
            int j = 0;
            while ((double)j < distance) {
                int k = 0;
                while (k <= j) {
                    int l;
                    int n = l = k < j && k > -j ? j : 0;
                    while (l <= j) {
                        mutableBlockPos.setWithOffset((Vec3i)blockPos, k, i - 1, l);
                        if (blockPos.closerThan((Vec3i)mutableBlockPos, distance) && predicate.test(level.getBlockState((BlockPos)mutableBlockPos))) {
                            return Optional.of(mutableBlockPos.immutable());
                        }
                        l = l > 0 ? -l : 1 - l;
                    }
                    k = k > 0 ? -k : 1 - k;
                }
                ++j;
            }
            i = i > 0 ? -i : 1 - i;
        }
        return Optional.empty();
    }

    protected void stop(@NotNull ServerLevel level, @NotNull PumpkinWarden pumpkinWarden, long gameTime) {
        pumpkinWarden.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        pumpkinWarden.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
    }
}

