/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.block.plants.tree.leaves;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.UntintedParticleLeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class BWGChangingLeavesBlock
extends UntintedParticleLeavesBlock
implements BonemealableBlock {
    private final Supplier<LeavesBlock> next;
    private final float chance;

    public BWGChangingLeavesBlock(BlockBehaviour.Properties properties, ParticleOptions leafParticle, Supplier<LeavesBlock> next, float chance) {
        super(0.01f, leafParticle, properties);
        this.next = next;
        this.chance = chance;
    }

    public boolean isRandomlyTicking(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)PERSISTENT) == false;
    }

    public void randomTick(@NotNull BlockState state, @NotNull ServerLevel serverLevel, @NotNull BlockPos pos, @NotNull RandomSource randomSource) {
        super.randomTick(state, serverLevel, pos, randomSource);
        if (randomSource.nextFloat() < this.chance) {
            this.placeNext(state, (Level)serverLevel, pos);
        }
    }

    private void placeNext(BlockState state, Level level, BlockPos pos) {
        level.setBlock(pos, (BlockState)((BlockState)this.next.get().defaultBlockState().setValue((Property)DISTANCE, (Comparable)((Integer)state.getValue((Property)DISTANCE)))).setValue((Property)PERSISTENT, (Comparable)((Boolean)state.getValue((Property)PERSISTENT))), 2);
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state) {
        return (Boolean)state.getValue((Property)PERSISTENT) == false;
    }

    public boolean isBonemealSuccess(@NotNull Level level, RandomSource randomSource, @NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return randomSource.nextBoolean();
    }

    public void performBonemeal(@NotNull ServerLevel level, @NotNull RandomSource randomSource, @NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        this.placeNext(blockState, (Level)level, blockPos);
    }
}

