/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.client.particle.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.NotNull;

public class FallingLeafParticle
extends SingleQuadParticle {
    FallingLeafParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, TextureAtlasSprite sprite) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, sprite);
        this.quadSize *= this.random.nextFloat() * 0.6f + 0.6f;
        this.lifetime = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        this.hasPhysics = true;
        this.friction = 1.0f;
        this.gravity = 1.0f;
        this.yd = -Math.abs(this.yd);
        this.setSize(0.01f, 0.01f);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.lifetime-- <= 0 || this.onGround) {
            this.remove();
        } else {
            this.move(this.xd, this.yd, this.zd);
            this.xd *= 0.99;
            this.zd *= 0.99;
        }
    }

    @NotNull
    protected SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.OPAQUE;
    }

    public record Provider(SpriteSet sprite) implements ParticleProvider<SimpleParticleType>
    {
        @NotNull
        public Particle createParticle(@NotNull SimpleParticleType particleType, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, @NotNull RandomSource random) {
            FallingLeafParticle leaf = new FallingLeafParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprite.get(random));
            leaf.lifetime = Mth.randomBetweenInclusive((RandomSource)random, (int)500, (int)1000);
            leaf.setColor(1.0f, 1.0f, 1.0f);
            leaf.setSprite(this.sprite.get(random.nextInt(16), 16));
            return leaf;
        }
    }
}

