/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.client.renderer.entity.pumpkinwarden;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.potionstudios.biomeswevegone.client.renderer.entity.pumpkinwarden.PumpkinWardenModel;
import net.potionstudios.biomeswevegone.world.entity.pumpkinwarden.PumpkinWarden;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.constant.dataticket.DataTicket;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.layer.ItemInHandGeoLayer;

public class PumpkinWardenRenderer<R extends EntityRenderState>
extends GeoEntityRenderer<PumpkinWarden, R> {
    protected static final DataTicket<Boolean> HIDING = DataTicket.create((String)"hiding", Boolean.class);
    protected static final DataTicket<String> VARIANT = DataTicket.create((String)"variant", String.class);

    public PumpkinWardenRenderer(EntityRendererProvider.Context context) {
        super(context, new PumpkinWardenModel());
        this.getRenderLayers().add(new ItemInHandGeoLayer((GeoRenderer)this));
    }

    public void preRender(R renderState, PoseStack poseStack, BakedGeoModel model, SubmitNodeCollector renderTasks, CameraRenderState cameraState, int packedLight, int packedOverlay, int renderColor) {
        poseStack.scale(0.5f, 0.5f, 0.5f);
        super.preRender(renderState, poseStack, model, renderTasks, cameraState, packedLight, packedOverlay, renderColor);
    }

    protected float getShadowRadius(@NotNull R renderState) {
        return (Boolean)((GeoRenderState)renderState).getGeckolibData(HIDING) != false ? 0.0f : 0.6f;
    }

    public void addRenderData(PumpkinWarden animatable, Void relatedObject, R renderState, float partialTick) {
        ((GeoRenderState)renderState).addGeckolibData(HIDING, (Object)animatable.isHiding());
        ((GeoRenderState)renderState).addGeckolibData(VARIANT, (Object)animatable.getVariant().getSerializedName());
    }
}

