/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.client.renderer.entity.wreath;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.potionstudios.biomeswevegone.client.model.ModelAccess;
import net.potionstudios.biomeswevegone.client.renderer.entity.wreath.WreathRenderState;
import net.potionstudios.biomeswevegone.world.entity.decoration.Wreath;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;

public class WreathRenderer
extends EntityRenderer<Wreath, WreathRenderState> {
    private final BlockRenderDispatcher blockRenderer;

    public WreathRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.blockRenderer = context.getBlockRenderDispatcher();
    }

    public void submit(@NotNull WreathRenderState renderState, @NotNull PoseStack poseStack, @NotNull SubmitNodeCollector nodeCollector, @NotNull CameraRenderState cameraRenderState) {
        float g;
        float f;
        super.submit((EntityRenderState)renderState, poseStack, nodeCollector, cameraRenderState);
        poseStack.pushPose();
        Direction direction = renderState.direction;
        Vec3 vec3 = this.getRenderOffset(renderState);
        poseStack.translate(-vec3.x, -vec3.y, -vec3.z);
        poseStack.translate((double)direction.getStepX() * 0.46875, (double)direction.getStepY() * 0.46875, (double)direction.getStepZ() * 0.46875);
        if (direction.getAxis().isHorizontal()) {
            f = 0.0f;
            g = 180.0f - direction.toYRot();
        } else {
            f = -90 * direction.getAxisDirection().getStep();
            g = 180.0f;
        }
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(f));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(g));
        if (!renderState.isInvisible) {
            poseStack.pushPose();
            poseStack.translate(-0.5, -0.5, -0.5);
            nodeCollector.submitBlockModel(poseStack, RenderType.entitySolidZOffsetForward((ResourceLocation)TextureAtlas.LOCATION_BLOCKS), ModelAccess.MODEL_ACCESS.getModel(renderState.type.getSerializedName() + "_wreath", this.blockRenderer), 1.0f, 1.0f, 1.0f, renderState.lightCoords, OverlayTexture.NO_OVERLAY, renderState.outlineColor);
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    @NotNull
    public WreathRenderState createRenderState() {
        return new WreathRenderState();
    }

    public void extractRenderState(@NotNull Wreath entity, @NotNull WreathRenderState reusedState, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)reusedState, partialTick);
        reusedState.direction = entity.getDirection();
        reusedState.type = entity.getVariant();
    }
}

