/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.forge.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class AddItemModifier
extends LootModifier {
    public static final Supplier<MapCodec<AddItemModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> AddItemModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ForgeRegistries.ITEMS.getCodec().listOf().fieldOf("items").forGetter(m -> m.items)).apply((Applicative)inst, AddItemModifier::new)));
    private final List<Item> items;

    public AddItemModifier(LootItemCondition[] conditionsIn, List<Item> items) {
        super(conditionsIn);
        this.items = items;
    }

    public AddItemModifier(LootItemCondition[] conditionsIn, Item ... items) {
        this(conditionsIn, Arrays.asList(items));
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(LootTable arg, ObjectArrayList<ItemStack> objectArrayList, LootContext arg2) {
        for (LootItemCondition condition : this.conditions) {
            if (condition.test((Object)arg2)) continue;
            return objectArrayList;
        }
        if (!this.items.isEmpty()) {
            objectArrayList.add((Object)this.items.get(arg2.getRandom().nextInt(this.items.size())).getDefaultInstance());
        }
        return objectArrayList;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

