/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EatBlockGoal.class})
public abstract class EatBlockGoalMixin {
    @Shadow
    @Final
    private Mob mob;
    @Shadow
    @Final
    private Level level;
    @Shadow
    @Final
    private static Predicate<BlockState> IS_EDIBLE;

    @Inject(method={"canUse()Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Mob;blockPosition()Lnet/minecraft/core/BlockPos;")}, cancellable=true)
    private void canUse(CallbackInfoReturnable<Boolean> cir) {
        BlockPos blockPos = this.mob.blockPosition();
        if (IS_EDIBLE.test(this.level.getBlockState(blockPos))) {
            cir.setReturnValue((Object)true);
        } else if (this.level.getBlockState(blockPos.below()).is((Block)BWGBlocks.LUSH_GRASS_BLOCK.get())) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/BlockPos;below()Lnet/minecraft/core/BlockPos;")})
    private void tick(CallbackInfo ci, @Local BlockPos blockPos) {
        BlockPos below;
        ServerLevel serverLevel;
        Level level = this.level;
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).getBlockState(below = blockPos.below()).is((Block)BWGBlocks.LUSH_GRASS_BLOCK.get()) && serverLevel.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            serverLevel.levelEvent(2001, below, Block.getId((BlockState)BWGBlocks.LUSH_GRASS_BLOCK.get().defaultBlockState()));
            serverLevel.setBlock(below, BWGBlocks.LUSH_DIRT.get().defaultBlockState(), 2);
            this.mob.ate();
        }
    }
}

