/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.level.levelgen.Heightmap;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.PlatformHandler;
import net.potionstudios.biomeswevegone.world.entity.decoration.Wreath;
import net.potionstudios.biomeswevegone.world.entity.manowar.ManOWar;
import net.potionstudios.biomeswevegone.world.entity.oddion.Oddion;
import net.potionstudios.biomeswevegone.world.entity.pumpkinwarden.PumpkinWarden;

public class BWGEntityType {
    public static final Supplier<EntityType<ManOWar>> MAN_O_WAR = BWGEntityType.createEntity("man_o_war", ManOWar::new, MobCategory.WATER_CREATURE, 0.6f, 1.0f, 0.7f);
    public static final Supplier<EntityType<PumpkinWarden>> PUMPKIN_WARDEN = BWGEntityType.createEntity("pumpkin_warden", PumpkinWarden::new, MobCategory.AMBIENT, 0.64f, 1.1f, 0.9f);
    public static final Supplier<EntityType<Oddion>> ODDION = BWGEntityType.createEntity("oddion", Oddion::new, MobCategory.CREATURE, 0.5f, 0.75f, 0.37f);
    public static final Supplier<EntityType<Wreath>> WREATH = BWGEntityType.createEntity("wreath", Wreath::new, MobCategory.MISC, 0.5f, 0.5f, 0.25f);

    private static <E extends Entity> Supplier<EntityType<E>> createEntity(String id, EntityType.EntityFactory<E> factory, MobCategory category, float width, float height, float eyeHeight) {
        return PlatformHandler.PLATFORM_HANDLER.register(BuiltInRegistries.ENTITY_TYPE, id, () -> EntityType.Builder.of((EntityType.EntityFactory)factory, (MobCategory)category).sized(width, height).eyeHeight(eyeHeight).build(BiomesWeveGone.key(Registries.ENTITY_TYPE, id)));
    }

    public static <E extends Entity> Supplier<EntityType<E>> createEntity(String id, EntityType.EntityFactory<E> factory, MobCategory category, float width, float height, float eyeHeight, int trackingRange) {
        return PlatformHandler.PLATFORM_HANDLER.register(BuiltInRegistries.ENTITY_TYPE, id, () -> EntityType.Builder.of((EntityType.EntityFactory)factory, (MobCategory)category).sized(width, height).eyeHeight(eyeHeight).clientTrackingRange(trackingRange).build(BiomesWeveGone.key(Registries.ENTITY_TYPE, id)));
    }

    public static <T extends Mob> void registerSpawnPlacements(Consumer<SpawnPlacement<T>> consumer) {
        consumer.accept(new SpawnPlacement<ManOWar>(MAN_O_WAR.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ManOWar::checkManOWarSpawnRules));
        consumer.accept(new SpawnPlacement<Oddion>(ODDION.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Oddion::checkOddionSpawnRules));
    }

    public static void registerEntityAttributes(BiConsumer<EntityType<? extends LivingEntity>, AttributeSupplier> consumer) {
        consumer.accept(MAN_O_WAR.get(), ManOWar.createAttributes().build());
        consumer.accept(PUMPKIN_WARDEN.get(), PumpkinWarden.createAttributes().build());
        consumer.accept(ODDION.get(), Oddion.createAttributes().build());
    }

    public static void entities() {
        BiomesWeveGone.LOGGER.info("Registering Oh The Biomes We've Gone Entities");
    }

    public record SpawnPlacement<T extends Mob>(EntityType<T> entityType, SpawnPlacementType spawnPlacementType, Heightmap.Types heightmapType, SpawnPlacements.SpawnPredicate<T> predicate) {
    }
}

