/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity.pumpkinwarden;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.potionstudios.biomeswevegone.tags.BWGItemTags;
import net.potionstudios.biomeswevegone.world.entity.BWGEntityType;
import net.potionstudios.biomeswevegone.world.entity.ai.behavior.PumpkinWardenGoalPackages;
import net.potionstudios.biomeswevegone.world.entity.ai.memory.BWGMemoryModuleType;
import net.potionstudios.biomeswevegone.world.entity.ai.sensing.BWGSensorType;
import net.potionstudios.biomeswevegone.world.entity.ai.village.poi.BWGPoiTypes;
import net.potionstudios.biomeswevegone.world.entity.schedule.BWGSchedule;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.entities.PumpkinBurrowBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animatable.processing.AnimationTest;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PumpkinWarden
extends PathfinderMob
implements GeoEntity {
    private final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private BlockPos jukebox;
    private boolean party;
    private static final EntityDataAccessor<Boolean> HIDING = SynchedEntityData.defineId(PumpkinWarden.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.defineId(PumpkinWarden.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.HOME, (Object)MemoryModuleType.MEETING_POINT, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, BWGMemoryModuleType.VISIBLE_PUMPKIN_WARDENS.get(), (Object)MemoryModuleType.VISIBLE_VILLAGER_BABIES, (Object)MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, (Object)MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.INTERACTION_TARGET, (Object)MemoryModuleType.PATH, (Object[])new MemoryModuleType[]{MemoryModuleType.DOORS_TO_CLOSE, MemoryModuleType.HURT_BY, MemoryModuleType.HURT_BY_ENTITY, MemoryModuleType.NEAREST_HOSTILE, MemoryModuleType.HEARD_BELL_TIME, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, BWGMemoryModuleType.HOPPER_BARREL_LOCATION.get()});
    private static final ImmutableList<SensorType<? extends Sensor<? super PumpkinWarden>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.NEAREST_ITEMS, (Object)SensorType.VILLAGER_HOSTILES, BWGSensorType.NEAREST_PUMPKIN_WARDENS.get(), (Object)SensorType.VILLAGER_BABIES, (Object)SensorType.HURT_BY);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<PumpkinWarden, Holder<PoiType>>> POI_MEMORIES = ImmutableMap.of((Object)MemoryModuleType.HOME, (pumpkinWarden, holder) -> holder.is(BWGPoiTypes.PUMPKIN_BURROW), (Object)MemoryModuleType.MEETING_POINT, (pumpkinWarden, holder) -> holder.is(PoiTypes.MEETING));
    private static final RawAnimation HIDE_START = RawAnimation.begin().then("animation.pumpkinwarden.hidestart", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation HIDE = RawAnimation.begin().thenLoop("animation.pumpkinwarden.hide");
    private static final RawAnimation HIDE_END = RawAnimation.begin().then("animation.pumpkinwarden.hideend", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation HOLDING_WALKING = RawAnimation.begin().thenPlay("animation.pumpkinwarden.holding_walking");
    private static final RawAnimation HOLDING_IDLE = RawAnimation.begin().thenPlay("animation.pumpkinwarden.holding_idle");
    private static final RawAnimation WALKING = RawAnimation.begin().thenPlay("animation.pumpkinwarden.walking");
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("animation.pumpkinwarden.idle");
    private static final RawAnimation WAVE = RawAnimation.begin().thenPlay("animation.pumpkinwarden.wave");

    public PumpkinWarden(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 16.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.getNavigation().setCanOpenDoors(true);
        this.getNavigation().setCanFloat(true);
    }

    @NotNull
    public Brain<PumpkinWarden> getBrain() {
        return super.getBrain();
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Brain.Provider<?> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    @NotNull
    protected Brain<?> makeBrain(@NotNull Dynamic<?> dynamic) {
        Brain brain = super.makeBrain(dynamic);
        this.registerBrainGoals((Brain<PumpkinWarden>)brain);
        return brain;
    }

    private void refreshBrain(ServerLevel serverLevel) {
        Brain<PumpkinWarden> brain = this.getBrain();
        brain.stopAll(serverLevel, (LivingEntity)this);
        this.brain = brain.copyWithoutBehaviors();
        this.registerBrainGoals(this.getBrain());
    }

    private void registerBrainGoals(Brain<PumpkinWarden> brain) {
        brain.setSchedule(BWGSchedule.PUMPKIN_WARDEN.get());
        brain.addActivity(Activity.CORE, PumpkinWardenGoalPackages.getCorePackage());
        brain.addActivity(Activity.PLAY, PumpkinWardenGoalPackages.getPlayPackage());
        brain.addActivity(Activity.IDLE, PumpkinWardenGoalPackages.getIdlePackage());
        brain.addActivity(Activity.WORK, PumpkinWardenGoalPackages.getWorkPackage());
        brain.addActivity(Activity.REST, PumpkinWardenGoalPackages.getRestPackage());
        brain.addActivity(Activity.PANIC, PumpkinWardenGoalPackages.getPanicPackage());
        brain.addActivity(Activity.HIDE, PumpkinWardenGoalPackages.getHidePackage());
        brain.addActivityWithConditions(Activity.MEET, PumpkinWardenGoalPackages.getMeetPackage(), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.MEETING_POINT, (Object)MemoryStatus.VALUE_PRESENT)));
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.PLAY);
        if (this.isHiding()) {
            brain.setActiveActivityIfPossible(Activity.HIDE);
        } else {
            brain.setActiveActivityIfPossible(Activity.PLAY);
        }
        brain.updateActivityFromSchedule(this.level().getDayTime(), this.level().getGameTime());
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HIDING, (Object)false);
        builder.define(DATA_VARIANT, (Object)0);
    }

    protected void addAdditionalSaveData(@NotNull ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putInt("Variant", this.getVariant().getId());
        valueOutput.putBoolean("Hiding", this.isHiding());
    }

    protected void readAdditionalSaveData(@NotNull ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.setVariant(Variant.byId(valueInput.getIntOr("Variant", 0)));
        this.setHiding(valueInput.getBooleanOr("Hiding", false));
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.refreshBrain(serverLevel);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.4).add(Attributes.FOLLOW_RANGE, 48.0);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public void checkDespawn() {
    }

    @NotNull
    protected InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.isHiding()) {
            return InteractionResult.FAIL;
        }
        ItemStack itemInHand = player.getItemInHand(hand);
        if (itemInHand.is(BWGBlocks.ROSE.getBlock().asItem())) {
            if (player.level().isClientSide()) {
                this.level().addParticle((ParticleOptions)ParticleTypes.HEART, this.getX(), this.getY() + 1.0, this.getZ(), 1.0, 1.0, 1.0);
                this.level().playSound((Entity)player, player.blockPosition(), SoundEvents.VILLAGER_AMBIENT, SoundSource.NEUTRAL, 1.0f, this.getVoicePitch());
            }
            itemInHand.shrink(1);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController("controller", 0, this::predicate).triggerableAnim("hide_start", HIDE_START).triggerableAnim("hide_end", HIDE_END));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    private PlayState predicate(@NotNull AnimationTest<PumpkinWarden> event) {
        event.controller().transitionLength(0);
        if (this.isHiding()) {
            if (event.controller().hasAnimationFinished()) {
                return event.setAndContinue(HIDE);
            }
            return PlayState.CONTINUE;
        }
        if (!this.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
            if (event.isMoving()) {
                return event.setAndContinue(HOLDING_WALKING);
            }
            return event.setAndContinue(HOLDING_IDLE);
        }
        if (event.isMoving()) {
            return event.setAndContinue(WALKING);
        }
        if (this.party) {
            return event.setAndContinue(WAVE);
        }
        return event.setAndContinue(IDLE);
    }

    public void setRecordPlayingNearby(@NotNull BlockPos blockPos, boolean partying) {
        this.jukebox = blockPos;
        this.party = partying;
    }

    public void aiStep() {
        if (this.jukebox == null || !this.jukebox.closerToCenterThan((Position)this.position(), 10.0) || !this.level().getBlockState(this.jukebox).is(Blocks.JUKEBOX)) {
            this.party = false;
            this.jukebox = null;
        }
        super.aiStep();
    }

    protected void customServerAiStep(@NotNull ServerLevel level) {
        ProfilerFiller profilerFiller = Profiler.get();
        profilerFiller.push("pumpkinwardenBrain");
        this.getBrain().tick(level, (LivingEntity)this);
        profilerFiller.pop();
        super.customServerAiStep(level);
    }

    protected void updateControlFlags() {
        this.goalSelector.setControlFlag(Goal.Flag.MOVE, this.canMove());
        this.goalSelector.setControlFlag(Goal.Flag.JUMP, this.canMove());
        this.goalSelector.setControlFlag(Goal.Flag.LOOK, !this.isHiding());
        this.goalSelector.setControlFlag(Goal.Flag.TARGET, !this.isHiding());
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull EntitySpawnReason spawnReason, @Nullable SpawnGroupData spawnGroupData) {
        this.setVariant(Variant.getSpawnVariant(level.getRandom()));
        return super.finalizeSpawn(level, difficulty, spawnReason, spawnGroupData);
    }

    public boolean canHoldItem(@NotNull ItemStack stack) {
        return this.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() && stack.is(BWGItemTags.PUMPKIN_WARDEN_PICKS_UP);
    }

    public boolean canPickUpLoot() {
        return this.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() && !this.isHiding();
    }

    protected void pickUpItem(@NotNull ServerLevel level, @NotNull ItemEntity entity) {
        ItemStack itemStack = entity.getItem();
        this.setItemInHand(InteractionHand.MAIN_HAND, itemStack.copy());
        this.onItemPickup(entity);
        this.take((Entity)entity, itemStack.getCount());
        itemStack.shrink(itemStack.getCount());
        if (itemStack.isEmpty()) {
            entity.discard();
        }
    }

    public boolean canBeLeashed() {
        return true;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return SoundEvents.VILLAGER_AMBIENT;
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return SoundEvents.VILLAGER_HURT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.VILLAGER_DEATH;
    }

    public float getVoicePitch() {
        return (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.2f + 1.5f;
    }

    public boolean hurtServer(@NotNull ServerLevel level, @NotNull DamageSource damageSource, float amount) {
        if (this.isHiding() && damageSource.is(DamageTypes.MOB_PROJECTILE)) {
            amount /= 2.0f;
        }
        return super.hurtServer(level, damageSource, amount);
    }

    protected void tickHeadTurn(float yBodyRot) {
        if (this.isHiding()) {
            return;
        }
        super.tickHeadTurn(yBodyRot);
    }

    public void travel(@NotNull Vec3 travelVector) {
        if (!this.canMove()) {
            travelVector = Vec3.ZERO;
        }
        super.travel(travelVector);
    }

    public boolean canMove() {
        return !this.isHiding() && !this.party;
    }

    public boolean isHiding() {
        return (Boolean)this.entityData.get(HIDING);
    }

    public void hide() {
        if (!this.isHiding()) {
            this.triggerAnim("controller", "hide_start");
            this.setHiding(true);
        }
    }

    public void unhide() {
        if (this.isHiding()) {
            this.triggerAnim("controller", "hide_end");
            this.setHiding(false);
        }
    }

    private void setHiding(boolean flag) {
        this.entityData.set(HIDING, (Object)flag);
    }

    public void setVariant(@NotNull Variant variant) {
        this.entityData.set(DATA_VARIANT, (Object)variant.getId());
    }

    @NotNull
    public Variant getVariant() {
        return Variant.byId((Integer)this.entityData.get(DATA_VARIANT));
    }

    @NotNull
    public EntityDimensions getDimensions(@NotNull Pose pose) {
        if (this.isHiding()) {
            return this.getType().getDimensions().scale(1.0f, 0.5f);
        }
        return super.getDimensions(pose);
    }

    public void onSyncedDataUpdated(@NotNull EntityDataAccessor<?> dataAccessor) {
        super.onSyncedDataUpdated(dataAccessor);
        if (HIDING.equals(dataAccessor)) {
            this.refreshDimensions();
        }
    }

    public void die(@NotNull DamageSource damageSource) {
        this.releaseAllPois();
        super.die(damageSource);
    }

    public boolean canBeSeenAsEnemy() {
        return !this.isHiding() && super.canBeSeenAsEnemy();
    }

    public void startSleeping(@NotNull BlockPos pos) {
        PumpkinBurrowBlockEntity pumpkinBurrow;
        BlockEntity blockEntity;
        if (this.isPassenger()) {
            this.stopRiding();
        }
        if ((blockEntity = this.level().getBlockEntity(pos)) instanceof PumpkinBurrowBlockEntity && (pumpkinBurrow = (PumpkinBurrowBlockEntity)blockEntity).isEmpty()) {
            pumpkinBurrow.addOccupant((LivingEntity)this);
            this.setSleepingPos(pos);
        }
    }

    public void stopSleeping() {
        this.setPose(Pose.STANDING);
        this.clearSleepingPos();
    }

    public void handleEntityEvent(byte id) {
        super.handleEntityEvent(id);
        if (id == 13) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.ANGRY_VILLAGER);
        } else if (id == 14) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.HAPPY_VILLAGER);
        }
    }

    protected void addParticlesAroundSelf(ParticleOptions particleOption) {
        for (int i = 0; i < 5; ++i) {
            double d = this.random.nextGaussian() * 0.02;
            double e = this.random.nextGaussian() * 0.02;
            double f = this.random.nextGaussian() * 0.02;
            this.level().addParticle(particleOption, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d, e, f);
        }
    }

    private void releaseAllPois() {
        this.releasePoi((MemoryModuleType<GlobalPos>)MemoryModuleType.HOME);
        this.releasePoi((MemoryModuleType<GlobalPos>)MemoryModuleType.MEETING_POINT);
    }

    public void releasePoi(MemoryModuleType<GlobalPos> moduleType) {
        if (this.level() instanceof ServerLevel) {
            MinecraftServer minecraftServer = ((ServerLevel)this.level()).getServer();
            this.brain.getMemory(moduleType).ifPresent(globalPos -> {
                ServerLevel serverLevel = minecraftServer.getLevel(globalPos.dimension());
                if (serverLevel != null) {
                    PoiManager poiManager = serverLevel.getPoiManager();
                    Optional optional = poiManager.getType(globalPos.pos());
                    BiPredicate<PumpkinWarden, Holder<PoiType>> biPredicate = POI_MEMORIES.get(moduleType);
                    if (optional.isPresent() && biPredicate.test(this, (Holder<PoiType>)((Holder)optional.get()))) {
                        poiManager.release(globalPos.pos());
                        serverLevel.debugSynchronizers().updatePoi(globalPos.pos());
                    }
                }
            });
        }
    }

    public static boolean villagerToPumpkinWarden(Entity entity, ItemStack stack, Level level) {
        Villager villager;
        if (entity instanceof Villager && (villager = (Villager)entity).isBaby() && villager.hasEffect(MobEffects.WEAKNESS) && (stack.is(Items.CARVED_PUMPKIN) || stack.is(BWGBlocks.CARVED_PALE_PUMPKIN.get().asItem())) && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PumpkinWarden warden = (PumpkinWarden)BWGEntityType.PUMPKIN_WARDEN.get().create((Level)serverLevel, EntitySpawnReason.CONVERSION);
            warden.setPos(villager.position());
            if (stack.is(BWGBlocks.CARVED_PALE_PUMPKIN.get().asItem())) {
                warden.setVariant(Variant.PALE);
            }
            serverLevel.addFreshEntity((Entity)warden);
            serverLevel.playSound(null, villager.blockPosition(), SoundEvents.ZOMBIE_VILLAGER_CURE, SoundSource.NEUTRAL, 1.0f, 1.0f);
            villager.remove(Entity.RemovalReason.DISCARDED);
            stack.shrink(1);
            return true;
        }
        return false;
    }

    public static enum Variant implements StringRepresentable
    {
        DEFAULT(0, "default"),
        PALE(1, "pale"),
        CHEERY(2, "cheery"),
        FROWNY(3, "frowny"),
        SILLY(4, "silly");

        private static final IntFunction<Variant> BY_ID;
        public static final Codec<Variant> CODEC;
        private final String name;
        private final int id;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        private static Variant getSpawnVariant(@NotNull RandomSource random) {
            int i = random.nextInt(100);
            if (i < 25) {
                return DEFAULT;
            }
            if (i < 50) {
                return CHEERY;
            }
            if (i < 75) {
                return SILLY;
            }
            if (i < 95) {
                return FROWNY;
            }
            return PALE;
        }

        static {
            BY_ID = ByIdMap.continuous(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            CODEC = StringRepresentable.fromEnum(Variant::values);
        }
    }
}

