/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.block.plants.vegetation;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.redstone.Orientation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlowCaneBlock
extends SugarCaneBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final Supplier<Supplier<Item>> shoot;

    public GlowCaneBlock(BlockBehaviour.Properties properties, Supplier<Supplier<Item>> shoot) {
        super(properties);
        this.shoot = shoot;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (level.isEmptyBlock(pos.above())) {
            int i = 1;
            while (level.getBlockState(pos.below(i)).is((Block)this)) {
                ++i;
            }
            if (i < 4) {
                int j = (Integer)state.getValue((Property)AGE);
                if (j == 15) {
                    level.setBlockAndUpdate(pos.above(), this.defaultBlockState());
                    level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0)), 4);
                } else {
                    level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(j + 1)), 4);
                }
            }
        }
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        BlockState blockState = level.getBlockState(pos.below());
        if (blockState.is((Block)this)) {
            return true;
        }
        if (blockState.is(BlockTags.DIRT) || blockState.is(BlockTags.SAND)) {
            BlockPos blockPos = pos.below();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockState blockState2 = level.getBlockState(blockPos.relative(direction));
                FluidState fluidState = level.getFluidState(blockPos.relative(direction));
                if (!fluidState.is(FluidTags.WATER) && !blockState2.is(Blocks.FROSTED_ICE)) continue;
                return true;
            }
            return level.getFluidState(pos).is(FluidTags.WATER);
        }
        return false;
    }

    protected void neighborChanged(BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
                level.setBlockAndUpdate(pos, Fluids.WATER.defaultFluidState().createLegacyBlock());
            } else {
                level.destroyBlock(pos, true);
            }
        }
    }

    @NotNull
    protected ItemStack getCloneItemStack(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state, boolean includeData) {
        return this.shoot.get().get().getDefaultInstance();
    }

    @NotNull
    protected FluidState getFluidState(@NotNull BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        if (context.getLevel().getFluidState(context.getClickedPos()).is(FluidTags.WATER)) {
            return (BlockState)super.getStateForPlacement(context).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        return this.defaultBlockState();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
        super.createBlockStateDefinition(builder);
    }
}

