/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.block.sand;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ColorRGBA;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ColoredFallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.potionstudios.biomeswevegone.world.damagesource.BWGDamageTypes;
import org.jetbrains.annotations.NotNull;

public class BWGQuickSand
extends ColoredFallingBlock {
    public BWGQuickSand(int dustColor, BlockBehaviour.Properties properties) {
        super(new ColorRGBA(dustColor), properties);
    }

    @NotNull
    protected VoxelShape getOcclusionShape(@NotNull BlockState state) {
        return Shapes.empty();
    }

    protected void entityInside(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity, @NotNull InsideBlockEffectApplier applier, boolean intersects) {
        ServerLevel serverLevel;
        if (entity instanceof LivingEntity) {
            entity.makeStuckInBlock(state, new Vec3((double)0.9f, 1.5, (double)0.9f));
            if (level.isClientSide()) {
                boolean bl;
                RandomSource randomSource = level.getRandom();
                boolean bl2 = bl = entity.xOld != entity.getX() || entity.zOld != entity.getZ();
                if (bl && randomSource.nextBoolean()) {
                    level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, state), entity.getX() + (double)Mth.randomBetween((RandomSource)randomSource, (float)-1.0f, (float)1.0f), entity.getEyeY() + (double)Mth.randomBetween((RandomSource)randomSource, (float)0.0f, (float)1.0f), entity.getZ() + (double)Mth.randomBetween((RandomSource)randomSource, (float)-1.0f, (float)1.0f), (double)(Mth.randomBetween((RandomSource)randomSource, (float)-1.0f, (float)1.0f) * 0.083333336f), (double)0.05f, (double)(Mth.randomBetween((RandomSource)randomSource, (float)-1.0f, (float)1.0f) * 0.083333336f));
                }
            } else {
                serverLevel = (ServerLevel)level;
                BlockPos headPos = new BlockPos(entity.getBlockX(), (int)entity.getEyeY(), entity.getBlockZ());
                if (serverLevel.getBlockState(headPos).getBlock() instanceof BWGQuickSand) {
                    entity.hurtServer(serverLevel, new DamageSource((Holder)serverLevel.registryAccess().lookupOrThrow(Registries.DAMAGE_TYPE).getOrThrow(BWGDamageTypes.IN_QUICKSAND)), 0.5f);
                }
            }
        }
        if (level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            if (entity.isOnFire() && (serverLevel.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) || entity instanceof Player) && entity.mayInteract(serverLevel, pos)) {
                level.destroyBlock(pos, false);
            }
            entity.setSharedFlagOnFire(false);
        }
    }

    public void fallOn(@NotNull Level level, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull Entity entity, double fallDistance) {
        if (!(fallDistance < 4.0) && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            LivingEntity.Fallsounds fallsounds = livingEntity.getFallSounds();
            SoundEvent soundEvent = fallDistance < 7.0 ? fallsounds.small() : fallsounds.big();
            entity.playSound(soundEvent, 1.0f, 1.0f);
        }
    }

    @NotNull
    public VoxelShape getVisualShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shapes.empty();
    }
}

