/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.block.wood;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.BlockFamilies;
import net.minecraft.data.BlockFamily;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.CraftingTableBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TintedParticleLeavesBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.UntintedParticleLeavesBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.PlatformHandler;
import net.potionstudios.biomeswevegone.world.entity.BWGEntityType;
import net.potionstudios.biomeswevegone.world.item.BWGItems;
import net.potionstudios.biomeswevegone.world.level.block.plants.PottedBlock;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGCraftingTable;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWood;
import net.potionstudios.biomeswevegone.world.level.block.wood.sign.BWGCeilingHangingSignBlock;
import net.potionstudios.biomeswevegone.world.level.block.wood.sign.BWGStandingSignBlock;
import net.potionstudios.biomeswevegone.world.level.block.wood.sign.BWGWallHangingSignBlock;
import net.potionstudios.biomeswevegone.world.level.block.wood.sign.BWGWallSignBlock;
import org.jetbrains.annotations.Nullable;

public class BWGWoodSet {
    private static final ArrayList<BWGWoodSet> woodSets = new ArrayList();
    private final String name;
    private final WoodType woodType;
    private final LogStem logstemEnum;
    private final Supplier<RotatedPillarBlock> logstem;
    private final Supplier<RotatedPillarBlock> wood;
    private final Supplier<RotatedPillarBlock> strippedLogStem;
    private final Supplier<RotatedPillarBlock> strippedWood;
    private final Supplier<Block> planks;
    private final Supplier<StairBlock> stairs;
    private final Supplier<SlabBlock> slab;
    private final Supplier<FenceBlock> fence;
    private final Supplier<FenceGateBlock> fenceGate;
    private final Supplier<DoorBlock> door;
    private final Supplier<TrapDoorBlock> trapdoor;
    private final Supplier<PressurePlateBlock> pressurePlate;
    private final Supplier<ButtonBlock> button;
    private final Supplier<Block> bookshelf;
    private final Supplier<CraftingTableBlock> craftingTable;
    @Nullable
    private Supplier<LeavesBlock> leaves = null;
    @Nullable
    private PottedBlock sapling = null;
    private final Supplier<StandingSignBlock> sign;
    private final Supplier<WallSignBlock> wallSign;
    private final Supplier<SignItem> signItem;
    private final Supplier<CeilingHangingSignBlock> hangingSign;
    private final Supplier<WallHangingSignBlock> wallHangingSign;
    private final Supplier<HangingSignItem> hangingSignItem;
    private final Supplier<Item> boatItem;
    private final Supplier<Item> chestBoatItem;
    private final TagKey<Block> logBlockTag;
    private final TagKey<Item> logItemTag;
    private final Supplier<EntityType<Boat>> boat;
    private final Supplier<EntityType<ChestBoat>> chestBoat;
    private BlockFamily family = null;

    protected BWGWoodSet(BlockSetType blockSetType, MapColor mapColor, LogStem logstem, @Nullable Supplier<TreeGrower> saplingGrower, boolean leaves, boolean glowLeaves, @Nullable TagKey<Block> saplingPlantAbleOn, int leafTint) {
        this.woodType = PlatformHandler.PLATFORM_HANDLER.createWoodType(blockSetType.name(), blockSetType);
        this.name = blockSetType.name().replace("biomeswevegone:", "");
        this.logstemEnum = logstem;
        this.logstem = BWGWood.registerBlockItem(this.name + "_" + logstem.getName(), RotatedPillarBlock::new, Blocks.logProperties((MapColor)mapColor, (MapColor)mapColor, (SoundType)SoundType.WOOD));
        this.wood = BWGWood.registerBlockItem(this.name + "_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(mapColor).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).ignitedByLava());
        this.strippedLogStem = BWGWood.registerBlockItem("stripped_" + this.name + "_" + logstem.getName(), RotatedPillarBlock::new, Blocks.logProperties((MapColor)mapColor, (MapColor)mapColor, (SoundType)SoundType.WOOD));
        this.strippedWood = BWGWood.registerBlockItem("stripped_" + this.name + "_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(mapColor).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).ignitedByLava());
        this.planks = BWGWood.registerBlockItem(this.name + "_planks", Block::new, BlockBehaviour.Properties.of().mapColor(mapColor).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava());
        this.stairs = BWGWood.registerBlockItem(this.name + "_stairs", properties -> new StairBlock(this.planks.get().defaultBlockState(), properties), BlockBehaviour.Properties.of().mapColor(mapColor).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava());
        this.slab = BWGWood.registerBlockItem(this.name + "_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(mapColor).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava());
        this.fence = BWGWood.registerBlockItem(this.name + "_fence", FenceBlock::new, BlockBehaviour.Properties.of().mapColor(mapColor).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava().sound(SoundType.WOOD));
        this.fenceGate = BWGWood.registerBlockItem(this.name + "_fence_gate", properties -> new FenceGateBlock(this.woodType, properties), BlockBehaviour.Properties.of().mapColor(mapColor).forceSolidOn().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava());
        this.door = BWGWood.registerBlockItem(this.name + "_door", properties -> new DoorBlock(this.woodType.setType(), properties), BlockBehaviour.Properties.of().mapColor(mapColor).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().ignitedByLava().pushReaction(PushReaction.DESTROY));
        this.trapdoor = BWGWood.registerBlockItem(this.name + "_trapdoor", properties -> new TrapDoorBlock(this.woodType.setType(), properties), BlockBehaviour.Properties.of().mapColor(mapColor).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never).ignitedByLava());
        this.pressurePlate = BWGWood.registerBlockItem(this.name + "_pressure_plate", properties -> new PressurePlateBlock(this.woodType.setType(), properties), BlockBehaviour.Properties.of().mapColor(mapColor).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(0.5f).ignitedByLava().pushReaction(PushReaction.DESTROY));
        this.button = BWGWood.registerBlockItem(this.name + "_button", properties -> new ButtonBlock(this.woodType.setType(), 30, properties), Blocks.buttonProperties());
        this.bookshelf = BWGWood.registerBlockItem(this.name + "_bookshelf", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BOOKSHELF).mapColor(mapColor));
        this.craftingTable = BWGWood.registerBlockItem(this.name + "_crafting_table", BWGCraftingTable::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CRAFTING_TABLE).mapColor(mapColor));
        if (leaves) {
            this.leaves = leafTint == 0 ? (glowLeaves ? BWGWood.registerBlockItem(this.name + "_leaves", properties -> new TintedParticleLeavesBlock(0.01f, properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES).lightLevel(level -> 8)) : BWGWood.registerBlockItem(this.name + "_leaves", properties -> new TintedParticleLeavesBlock(0.01f, properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES))) : (glowLeaves ? BWGWood.registerBlockItem(this.name + "_leaves", properties -> new UntintedParticleLeavesBlock(0.01f, (ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.TINTED_LEAVES, (int)leafTint), properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES).lightLevel(level -> 8)) : BWGWood.registerBlockItem(this.name + "_leaves", properties -> new UntintedParticleLeavesBlock(0.01f, (ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.TINTED_LEAVES, (int)leafTint), properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES)));
        }
        if (saplingGrower != null) {
            this.sapling = BWGWood.createSapling(this.name, saplingGrower, saplingPlantAbleOn);
        }
        this.sign = BWGWood.register(this.name + "_sign", properties -> new BWGStandingSignBlock((BlockBehaviour.Properties)properties, this.woodType), BlockBehaviour.Properties.of().mapColor(mapColor).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
        this.wallSign = BWGWood.register(this.name + "_wall_sign", () -> new BWGWallSignBlock(Blocks.wallVariant((Block)((Block)this.sign.get()), (boolean)true).mapColor(mapColor).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava().setId(BWGWoodSet.key(this.name + "_wall_sign")), this.woodType));
        this.signItem = BWGItems.register(this.name + "_sign", properties -> new SignItem((Block)this.sign.get(), (Block)this.wallSign.get(), properties), new Item.Properties().stacksTo(16).useBlockDescriptionPrefix());
        BWGWood.WOOD_BLOCK_ITEMS.add(this.signItem);
        this.hangingSign = BWGWood.register(this.name + "_hanging_sign", properties -> new BWGCeilingHangingSignBlock((BlockBehaviour.Properties)properties, this.woodType), BlockBehaviour.Properties.of().mapColor(mapColor).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
        this.wallHangingSign = BWGWood.register(this.name + "_wall_hanging_sign", () -> new BWGWallHangingSignBlock(Blocks.wallVariant((Block)this.hangingSign(), (boolean)true).mapColor(mapColor).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(1.0f).ignitedByLava().setId(BWGWoodSet.key(this.name + "_wall_hanging_sign")), this.woodType));
        this.hangingSignItem = BWGItems.register(this.name + "_hanging_sign", properties -> new HangingSignItem((Block)this.hangingSign.get(), (Block)this.wallHangingSign.get(), properties), new Item.Properties().stacksTo(16).useBlockDescriptionPrefix());
        BWGWood.WOOD_BLOCK_ITEMS.add(this.hangingSignItem);
        this.boat = BWGEntityType.createEntity(this.name + "_boat", (type, level) -> new Boat(type, level, this.boatItem()), MobCategory.MISC, EntityType.OAK_BOAT.getWidth(), EntityType.OAK_BOAT.getHeight(), 0.5625f, 10);
        this.chestBoat = BWGEntityType.createEntity(this.name + "_chest_boat", (type, level) -> new ChestBoat(type, level, this.chestBoatItem()), MobCategory.MISC, EntityType.OAK_CHEST_BOAT.getWidth(), EntityType.OAK_CHEST_BOAT.getHeight(), 0.5625f, 10);
        this.boatItem = BWGWood.registerItem(this.name + "_boat", properties -> new BoatItem(this.boat.get(), properties), new Item.Properties().stacksTo(1));
        this.chestBoatItem = BWGWood.registerItem(this.name + "_chest_boat", properties -> new BoatItem(this.chestBoat.get(), properties), new Item.Properties().stacksTo(1));
        this.logBlockTag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)BiomesWeveGone.id(this.name + "_logs"));
        this.logItemTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)BiomesWeveGone.id(this.name + "_logs"));
        woodSets.add(this);
    }

    protected BWGWoodSet(BlockSetType blockSetType, MapColor mapColor, @Nullable Supplier<TreeGrower> saplingGrower, boolean leaves, int leafTint) {
        this(blockSetType, mapColor, LogStem.LOG, saplingGrower, leaves, false, (TagKey<Block>)BlockTags.DIRT, leafTint);
    }

    protected BWGWoodSet(BlockSetType blockSetType, MapColor mapColor, @Nullable Supplier<TreeGrower> saplingGrower, boolean leaves, TagKey<Block> saplingPlantAbleOn, int leafTint) {
        this(blockSetType, mapColor, LogStem.LOG, saplingGrower, leaves, false, saplingPlantAbleOn, leafTint);
    }

    protected BWGWoodSet(BlockSetType blockSetType, MapColor mapColor, @Nullable Supplier<TreeGrower> saplingGrower, boolean leaves, boolean glowLeaves, int leafTint) {
        this(blockSetType, mapColor, LogStem.LOG, saplingGrower, leaves, glowLeaves, (TagKey<Block>)BlockTags.DIRT, leafTint);
    }

    protected BWGWoodSet(String name, MapColor mapColor, @Nullable Supplier<TreeGrower> saplingGrower, int leafTint) {
        this(BlockSetType.register((BlockSetType)new BlockSetType(name)), mapColor, saplingGrower, true, leafTint);
    }

    protected BWGWoodSet(String name, MapColor mapColor, @Nullable Supplier<TreeGrower> saplingGrower, TagKey<Block> saplingPlantAbleOn, int leafTint) {
        this(BlockSetType.register((BlockSetType)new BlockSetType(name)), mapColor, saplingGrower, true, saplingPlantAbleOn, leafTint);
    }

    protected BWGWoodSet(String name, MapColor mapColor, @Nullable Supplier<TreeGrower> saplingGrower, boolean glowLeaves, int leafTint) {
        this(BlockSetType.register((BlockSetType)new BlockSetType(name)), mapColor, saplingGrower, true, glowLeaves, leafTint);
    }

    public String name() {
        return this.name;
    }

    public WoodType woodType() {
        return this.woodType;
    }

    public RotatedPillarBlock logstem() {
        return this.logstem.get();
    }

    public RotatedPillarBlock wood() {
        return this.wood.get();
    }

    public RotatedPillarBlock strippedLogStem() {
        return this.strippedLogStem.get();
    }

    public RotatedPillarBlock strippedWood() {
        return this.strippedWood.get();
    }

    public Block planks() {
        return this.planks.get();
    }

    public StairBlock stairs() {
        return this.stairs.get();
    }

    public SlabBlock slab() {
        return this.slab.get();
    }

    public TagKey<Block> logBlockTag() {
        return this.logBlockTag;
    }

    public TagKey<Item> logItemTag() {
        return this.logItemTag;
    }

    public FenceBlock fence() {
        return this.fence.get();
    }

    public FenceGateBlock fenceGate() {
        return this.fenceGate.get();
    }

    public DoorBlock door() {
        return this.door.get();
    }

    public TrapDoorBlock trapdoor() {
        return this.trapdoor.get();
    }

    public PressurePlateBlock pressurePlate() {
        return this.pressurePlate.get();
    }

    public ButtonBlock button() {
        return this.button.get();
    }

    public Block bookshelf() {
        return this.bookshelf.get();
    }

    public CraftingTableBlock craftingTable() {
        return this.craftingTable.get();
    }

    @Nullable
    public LeavesBlock leaves() {
        if (this.leaves != null) {
            return this.leaves.get();
        }
        return null;
    }

    @Nullable
    public PottedBlock sapling() {
        if (this.sapling != null) {
            return this.sapling;
        }
        return null;
    }

    public StandingSignBlock sign() {
        return this.sign.get();
    }

    public WallSignBlock wallSign() {
        return this.wallSign.get();
    }

    public SignItem signItem() {
        return this.signItem.get();
    }

    public CeilingHangingSignBlock hangingSign() {
        return this.hangingSign.get();
    }

    public WallHangingSignBlock wallHangingSign() {
        return this.wallHangingSign.get();
    }

    public HangingSignItem hangingSignItem() {
        return this.hangingSignItem.get();
    }

    public Supplier<Item> boatItem() {
        return this.boatItem;
    }

    public Supplier<Item> chestBoatItem() {
        return this.chestBoatItem;
    }

    public Supplier<EntityType<Boat>> boat() {
        return this.boat;
    }

    public Supplier<EntityType<ChestBoat>> chestBoat() {
        return this.chestBoat;
    }

    public ModelLayerLocation boatModelLayer() {
        return new ModelLayerLocation(BiomesWeveGone.id("boat/" + this.name), "main");
    }

    public ModelLayerLocation chestBoatModelLayer() {
        return new ModelLayerLocation(BiomesWeveGone.id("chest_boat/" + this.name), "main");
    }

    public ArrayList<ItemLike> itemList() {
        ArrayList<Block> items = new ArrayList<Block>(List.of(this.planks.get(), (Block)this.slab.get(), (Block)this.stairs.get(), (Block)this.logstem.get(), (Block)this.strippedLogStem.get(), (Block)this.wood.get(), (Block)this.strippedWood.get(), (Block)this.sign.get(), (Block)this.hangingSign.get(), (Block)this.pressurePlate.get(), (Block)this.trapdoor.get(), (Block)this.button.get(), (Block)this.fenceGate.get(), (Block)this.fence.get(), (Block)this.door.get(), this.bookshelf.get(), (Block)this.craftingTable.get()));
        if (this.leaves != null) {
            items.add((Block)((ItemLike)this.leaves.get()));
        }
        return items;
    }

    public void makeFamily() {
        this.family = BlockFamilies.familyBuilder((Block)this.planks.get()).button((Block)this.button.get()).fence((Block)this.fence.get()).fenceGate((Block)this.fenceGate.get()).pressurePlate((Block)this.pressurePlate.get()).sign((Block)this.sign.get(), (Block)this.wallSign.get()).slab((Block)this.slab.get()).stairs((Block)this.stairs.get()).door((Block)this.door.get()).trapdoor((Block)this.trapdoor.get()).recipeGroupPrefix("wooden").recipeUnlockedBy("has_planks").getFamily();
    }

    public BlockFamily family() {
        return this.family;
    }

    public static ArrayList<BWGWoodSet> woodsets() {
        return woodSets;
    }

    public LogStem logStemEnum() {
        return this.logstemEnum;
    }

    private static ResourceKey<Block> key(String id) {
        return BiomesWeveGone.key(Registries.BLOCK, id);
    }

    public static enum LogStem {
        LOG("log"),
        STEM("stem");

        private final String name;

        private LogStem(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

