/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedList;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import net.potionstudios.biomeswevegone.world.level.levelgen.CheckedBlockPlacement;

public class PillarFeature
extends Feature<Config> {
    public PillarFeature(Codec<Config> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<Config> context) {
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        WorldGenLevel level = context.level();
        Config config = (Config)context.config();
        int height = config.height.sample(random);
        int radius = config.radius.sample(random);
        double frequency = config.noisefreq.sample(random);
        double minRadiusScale = config.minRadiusScale.sample(random);
        DistanceTestType tester = (DistanceTestType)((Object)config.distanceTestType.getRandomOrThrow(random));
        ImprovedNoise noise = new ImprovedNoise(random);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        LongOpenHashSet cache = new LongOpenHashSet();
        for (int xOffset = -radius; xOffset <= radius; ++xOffset) {
            for (int zOffset = -radius; zOffset <= radius; ++zOffset) {
                mutableBlockPos.setWithOffset((Vec3i)origin, xOffset, 0, zOffset);
                if (!tester.distanceTester.withinDistance(origin, (BlockPos)mutableBlockPos, radius)) continue;
                int heightmap = level.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, mutableBlockPos.getX(), mutableBlockPos.getZ());
                int radius1 = radius;
                int maxY = origin.getY() + height;
                for (int worldY = heightmap - 5; worldY <= maxY; ++worldY) {
                    mutableBlockPos.set(origin.getX() + xOffset, worldY, origin.getZ() + zOffset);
                    double pillarNoise = (noise.noise((double)mutableBlockPos.getX() * frequency, (double)mutableBlockPos.getY() * frequency, (double)mutableBlockPos.getZ() * frequency) + 1.0) * 0.5;
                    double localRadius = Mth.clampedLerp((double)((double)radius1 * minRadiusScale), (double)radius1, (double)pillarNoise);
                    if (!tester.distanceTester.withinDistance(origin.atY(worldY), (BlockPos)mutableBlockPos, localRadius)) continue;
                    cache.add(mutableBlockPos.asLong());
                }
            }
        }
        for (Pair<BlockPredicate, BlockStateProvider> blockPlacement : config.checkedBlockPlacement.blockPlacement()) {
            cache.forEach(pos -> {
                mutableBlockPos.set(pos);
                if (((BlockPredicate)blockPlacement.getFirst()).test((Object)level, (Object)mutableBlockPos)) {
                    level.setBlock((BlockPos)mutableBlockPos, ((BlockStateProvider)blockPlacement.getSecond()).getState(random, (BlockPos)mutableBlockPos), 2);
                }
            });
        }
        UniformInt vineLengthSampler = UniformInt.of((int)1, (int)10);
        int vineLength = vineLengthSampler.sample(random);
        cache.forEach(arg_0 -> PillarFeature.lambda$place$1(mutableBlockPos, random, vineLength, level, (LongSet)cache, arg_0));
        return true;
    }

    private static /* synthetic */ void lambda$place$1(BlockPos.MutableBlockPos mutableBlockPos, RandomSource random, int vineLength, WorldGenLevel level, LongSet cache, long pos) {
        mutableBlockPos.set(pos);
        Direction.Plane horizontal = Direction.Plane.HORIZONTAL;
        for (Direction direction : horizontal) {
            if (!(random.nextDouble() < 0.1)) continue;
            mutableBlockPos.set(pos).move(direction);
            for (int i = 0; i < vineLength; ++i) {
                if (level.getBlockState((BlockPos)mutableBlockPos).isAir() && !cache.contains(mutableBlockPos.asLong())) {
                    level.setBlock((BlockPos)mutableBlockPos, (BlockState)Blocks.VINE.defaultBlockState().setValue((Property)VineBlock.getPropertyForFace((Direction)direction.getOpposite()), (Comparable)Boolean.valueOf(true)), 2);
                }
                mutableBlockPos.move(Direction.DOWN);
            }
        }
    }

    public record Config(CheckedBlockPlacement checkedBlockPlacement, IntProvider height, IntProvider radius, FloatProvider noisefreq, FloatProvider minRadiusScale, WeightedList<DistanceTestType> distanceTestType) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CheckedBlockPlacement.CODEC.fieldOf("block_placement").forGetter(Config::checkedBlockPlacement), (App)IntProvider.CODEC.fieldOf("height").forGetter(Config::height), (App)IntProvider.CODEC.fieldOf("radius").forGetter(Config::radius), (App)FloatProvider.CODEC.fieldOf("noise_frequency").forGetter(Config::noisefreq), (App)FloatProvider.CODEC.fieldOf("min_radius_scale").forGetter(Config::minRadiusScale), (App)WeightedList.codec(DistanceTestType.CODEC).fieldOf("distance_test_type").forGetter(Config::distanceTestType)).apply((Applicative)instance, Config::new));
    }

    public static enum DistanceTestType {
        EUCLIDEAN(Vec3i::closerThan),
        MANHATTAN((origin, from, radius) -> (double)origin.distManhattan((Vec3i)from) < radius),
        CHEBYSHEV((origin, from, radius) -> {
            int dx = Math.abs(origin.getX() - from.getX());
            int dy = Math.abs(origin.getY() - from.getY());
            int dz = Math.abs(origin.getZ() - from.getZ());
            return (double)Math.max(Math.max(dx, dy), dz) < radius;
        });

        public static final Codec<DistanceTestType> CODEC;
        private final DistanceTester distanceTester;

        private DistanceTestType(DistanceTester distanceTester) {
            this.distanceTester = distanceTester;
        }

        public DistanceTester getDistanceTester() {
            return this.distanceTester;
        }

        static {
            CODEC = Codec.STRING.xmap(DistanceTestType::valueOf, Enum::name);
        }
    }

    @FunctionalInterface
    public static interface DistanceTester {
        public boolean withinDistance(BlockPos var1, BlockPos var2, double var3);
    }
}

